/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enchantableblocks.menu.crafting;

import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class EnchantedCraftingContainer
extends TransientCraftingContainer {
    boolean pauseUpdates;
    final ItemStackHandler inventory;

    public EnchantedCraftingContainer(AbstractContainerMenu menu, ItemStackHandler itemHandler) {
        super(menu, 3, 3);
        this.inventory = itemHandler;
    }

    public List<ItemStack> getItems() {
        NonNullList stacks = NonNullList.withSize((int)this.inventory.getSlots(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            stacks.set(i, (Object)this.inventory.getStackInSlot(i));
        }
        return List.copyOf(stacks);
    }

    public ItemStack getItem(int slot) {
        this.validateSlot(slot);
        return this.inventory.getStackInSlot(slot);
    }

    public ItemStack removeItem(int slot, int amount) {
        this.validateSlot(slot);
        ItemStack stack = this.inventory.extractItem(slot, amount, false);
        if (!stack.isEmpty()) {
            this.onCraftMatrixChanged();
        }
        return stack;
    }

    public void setItem(int slot, @NotNull ItemStack stack) {
        this.validateSlot(slot);
        this.inventory.setStackInSlot(slot, stack);
        this.onCraftMatrixChanged();
    }

    public ItemStack removeItemNoUpdate(int slot) {
        this.validateSlot(slot);
        ItemStack s = this.getItem(slot);
        if (s.isEmpty()) {
            return ItemStack.EMPTY;
        }
        this.onCraftMatrixChanged();
        this.setItem(slot, ItemStack.EMPTY);
        return s;
    }

    public boolean isEmpty() {
        return IntStream.range(0, this.inventory.getSlots()).allMatch(i -> this.inventory.getStackInSlot(i).isEmpty());
    }

    public void clearContent() {
    }

    public void validateSlot(int slot) {
        if (slot >= 0 && slot < this.getContainerSize()) {
            return;
        }
        throw new IndexOutOfBoundsException("Someone attempted to an out of bound stack at slot " + slot);
    }

    public void onCraftMatrixChanged() {
        if (!this.pauseUpdates) {
            this.menu.slotsChanged((Container)this);
        }
    }
}

