/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enchantableblocks;

import com.mojang.logging.LogUtils;
import com.mrbysco.enchantableblocks.client.ClientHandler;
import com.mrbysco.enchantableblocks.compat.top.TOPCompat;
import com.mrbysco.enchantableblocks.registry.ModEnchantments;
import com.mrbysco.enchantableblocks.registry.ModLootFunctions;
import com.mrbysco.enchantableblocks.registry.ModMenus;
import com.mrbysco.enchantableblocks.registry.ModRegistry;
import com.mrbysco.enchantableblocks.registry.ModTags;
import com.mrbysco.enchantableblocks.util.ReplacementUtil;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="enchantableblocks")
public class EnchantableBlocks {
    public static final String MOD_ID = "enchantableblocks";
    public static final Logger LOGGER = LogUtils.getLogger();

    public EnchantableBlocks() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModRegistry.BLOCKS.register(eventBus);
        ModRegistry.BLOCK_ENTITY_TYPES.register(eventBus);
        ModRegistry.ITEMS.register(eventBus);
        ModEnchantments.ENCHANTMENTS.register(eventBus);
        ModMenus.MENU_TYPES.register(eventBus);
        ModLootFunctions.LOOT_ITEM_FUNCTIONS.register(eventBus);
        eventBus.addListener(this::sendImc);
        MinecraftForge.EVENT_BUS.addListener(this::onServerStarted);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            eventBus.addListener(ClientHandler::onClientSetup);
            eventBus.addListener(ClientHandler::registerRenderers);
            eventBus.addListener(ClientHandler::loadComplete);
        });
    }

    public void sendImc(InterModEnqueueEvent event) {
        if (ModList.get().isLoaded("theoneprobe")) {
            TOPCompat.register();
        }
    }

    private void onServerStarted(ServerStartedEvent event) {
        ReplacementUtil.addReplacement(Blocks.f_50094_, ModRegistry.ENCHANTED_FURNACE, ModTags.FURNACE_APPLICABLE);
        ReplacementUtil.addReplacement(Blocks.f_50620_, ModRegistry.ENCHANTED_BLAST_FURNACE, ModTags.BLAST_FURNACE_APPLICABLE);
        ReplacementUtil.addReplacement(Blocks.f_50619_, ModRegistry.ENCHANTED_SMOKER, ModTags.SMOKER_APPLICABLE);
        ReplacementUtil.addReplacement(Blocks.f_50273_, ModRegistry.ENCHANTED_BEACON, ModTags.BEACON_APPLICABLE);
        ReplacementUtil.addReplacement(Blocks.f_50683_, ModRegistry.ENCHANTED_CAMPFIRE, ModTags.CAMPFIRE_APPLICABLE);
        ReplacementUtil.addReplacement(Blocks.f_50684_, ModRegistry.ENCHANTED_SOUL_CAMPFIRE, ModTags.SOUL_CAMPFIRE_APPLICABLE);
        ReplacementUtil.addReplacement(Blocks.f_50450_, ModRegistry.ENCHANTED_MAGMA_BLOCK, ModTags.MAGMA_BLOCK_APPLICABLE);
        ReplacementUtil.addReplacement(Blocks.f_50061_, ModRegistry.ENCHANTED_DISPENSER, ModTags.DISPENSER_APPLICABLE);
        ReplacementUtil.addReplacement(Blocks.f_50724_, ModRegistry.ENCHANTED_RESPAWN_ANCHOR, ModTags.RESPAWN_ANCHOR_APPLICABLE);
        ReplacementUtil.addReplacement(Blocks.f_50332_, ModRegistry.ENCHANTED_HOPPER, ModTags.HOPPER_APPLICABLE);
        ReplacementUtil.addReplacement(Blocks.f_50201_, ModRegistry.ENCHANTED_ENCHANTING_TABLE, ModTags.ENCHANTMENT_TABLE_APPLICABLE);
        ReplacementUtil.addReplacement(Blocks.f_50569_, ModRegistry.ENCHANTED_CONDUIT, ModTags.CONDUIT_APPLICABLE);
        ReplacementUtil.addReplacement(Blocks.f_50091_, ModRegistry.ENCHANTED_CRAFTING_TABLE, ModTags.CRAFTING_TABLE_APPLICABLE);
        ReplacementUtil.addReplacement(Blocks.f_50718_, ModRegistry.ENCHANTED_BEEHIVE, ModTags.BEEHIVE_APPLICABLE);
        ReplacementUtil.addReplacement(Blocks.f_50087_, ModRegistry.ENCHANTED_CHEST, ModTags.CHEST_APPLICABLE);
        ReplacementUtil.addReplacement(Blocks.f_50325_, ModRegistry.ENCHANTED_TRAPPED_CHEST, ModTags.TRAPPED_CHEST_APPLICABLE);
        ReplacementUtil.addReplacement(Blocks.f_50066_, ModRegistry.ENCHANTED_WHITE_BED, ModTags.WHITE_BED_APPLICABLE);
        ReplacementUtil.addReplacement(Blocks.f_50067_, ModRegistry.ENCHANTED_ORANGE_BED, ModTags.ORANGE_BED_APPLICABLE);
        ReplacementUtil.addReplacement(Blocks.f_50068_, ModRegistry.ENCHANTED_MAGENTA_BED, ModTags.MAGENTA_BED_APPLICABLE);
        ReplacementUtil.addReplacement(Blocks.f_50017_, ModRegistry.ENCHANTED_LIGHT_BLUE_BED, ModTags.LIGHT_BLUE_BED_APPLICABLE);
        ReplacementUtil.addReplacement(Blocks.f_50018_, ModRegistry.ENCHANTED_YELLOW_BED, ModTags.YELLOW_BED_APPLICABLE);
        ReplacementUtil.addReplacement(Blocks.f_50019_, ModRegistry.ENCHANTED_LIME_BED, ModTags.LIME_BED_APPLICABLE);
        ReplacementUtil.addReplacement(Blocks.f_50020_, ModRegistry.ENCHANTED_PINK_BED, ModTags.PINK_BED_APPLICABLE);
        ReplacementUtil.addReplacement(Blocks.f_50021_, ModRegistry.ENCHANTED_GRAY_BED, ModTags.GRAY_BED_APPLICABLE);
        ReplacementUtil.addReplacement(Blocks.f_50022_, ModRegistry.ENCHANTED_LIGHT_GRAY_BED, ModTags.LIGHT_GRAY_BED_APPLICABLE);
        ReplacementUtil.addReplacement(Blocks.f_50023_, ModRegistry.ENCHANTED_CYAN_BED, ModTags.CYAN_BED_APPLICABLE);
        ReplacementUtil.addReplacement(Blocks.f_50024_, ModRegistry.ENCHANTED_PURPLE_BED, ModTags.PURPLE_BED_APPLICABLE);
        ReplacementUtil.addReplacement(Blocks.f_50025_, ModRegistry.ENCHANTED_BLUE_BED, ModTags.BLUE_BED_APPLICABLE);
        ReplacementUtil.addReplacement(Blocks.f_50026_, ModRegistry.ENCHANTED_BROWN_BED, ModTags.BROWN_BED_APPLICABLE);
        ReplacementUtil.addReplacement(Blocks.f_50027_, ModRegistry.ENCHANTED_GREEN_BED, ModTags.GREEN_BED_APPLICABLE);
        ReplacementUtil.addReplacement(Blocks.f_50028_, ModRegistry.ENCHANTED_RED_BED, ModTags.RED_BED_APPLICABLE);
        ReplacementUtil.addReplacement(Blocks.f_50029_, ModRegistry.ENCHANTED_BLACK_BED, ModTags.BLACK_BED_APPLICABLE);
    }
}

