/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enchantableblocks.block;

import com.mrbysco.enchantableblocks.block.blockentity.EnchantedCampfireBlockEntity;
import com.mrbysco.enchantableblocks.block.blockentity.IEnchantable;
import com.mrbysco.enchantableblocks.registry.ModEnchantments;
import com.mrbysco.enchantableblocks.registry.ModRegistry;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.Nullable;

public class EnchantedCampfireBlock
extends CampfireBlock {
    private final Supplier<Block> originalBlock;

    public EnchantedCampfireBlock(boolean spawnParticles, int fireDamage, Supplier<Block> originalBlock, BlockBehaviour.Properties properties) {
        super(spawnParticles, fireDamage, properties);
        this.originalBlock = originalBlock;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new EnchantedCampfireBlockEntity(pos, state);
    }

    public Item m_5456_() {
        return this.originalBlock.get().m_5456_();
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (level.f_46443_) {
            return (Boolean)state.m_61143_((Property)f_51227_) != false ? EnchantedCampfireBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)ModRegistry.ENCHANTED_CAMPFIRE_BLOCK_ENTITY.get()), EnchantedCampfireBlockEntity::particleTick) : null;
        }
        return (Boolean)state.m_61143_((Property)f_51227_) != false ? EnchantedCampfireBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)ModRegistry.ENCHANTED_CAMPFIRE_BLOCK_ENTITY.get()), EnchantedCampfireBlockEntity::cookTick) : EnchantedCampfireBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)ModRegistry.ENCHANTED_CAMPFIRE_BLOCK_ENTITY.get()), EnchantedCampfireBlockEntity::cooldownTick);
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (((Boolean)state.m_61143_((Property)f_51227_)).booleanValue() && entity instanceof LivingEntity && !EnchantmentHelper.m_44938_((LivingEntity)((LivingEntity)entity))) {
            IEnchantable enchantable;
            float damage = this.f_51233_;
            BlockEntity blockentity = level.m_7702_(pos);
            if (blockentity instanceof IEnchantable && (enchantable = (IEnchantable)blockentity).hasEnchantment((Enchantment)ModEnchantments.BOILING.get())) {
                int enchantmentLevel = enchantable.getEnchantmentLevel((Enchantment)ModEnchantments.BOILING.get());
                damage *= (float)(enchantmentLevel + 1);
            }
            entity.m_6469_(level.m_269111_().m_269387_(), damage);
        }
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        IEnchantable blockEntity;
        ItemStack originalStack = new ItemStack((ItemLike)this.originalBlock.get());
        BlockEntity blockEntity2 = level.m_7702_(pos);
        if (blockEntity2 instanceof IEnchantable && (blockEntity = (IEnchantable)blockEntity2).getEnchantmentsTag() != null) {
            originalStack.m_41784_().m_128365_("Enchantments", (Tag)blockEntity.getEnchantmentsTag());
        }
        return originalStack;
    }

    public float getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        IEnchantable enchantable;
        float explosionResistance = super.getExplosionResistance(state, level, pos, explosion);
        BlockEntity blockentity = level.m_7702_(pos);
        if (blockentity instanceof IEnchantable && (enchantable = (IEnchantable)blockentity).hasEnchantment(Enchantments.f_44968_)) {
            int enchantmentLevel = enchantable.getEnchantmentLevel(Enchantments.f_44968_);
            explosionResistance *= (float)((enchantmentLevel + 1) * 30);
        }
        return explosionResistance;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            EnchantedCampfireBlockEntity campfireBlockEntity;
            BlockEntity blockentity = level.m_7702_(pos);
            if (blockentity instanceof EnchantedCampfireBlockEntity && !(campfireBlockEntity = (EnchantedCampfireBlockEntity)blockentity).hasEnchantment(Enchantments.f_44963_)) {
                Containers.m_19010_((Level)level, (BlockPos)pos, (NonNullList)campfireBlockEntity.m_59065_());
            }
            if (!(!state.m_155947_() || state.m_60713_(newState.m_60734_()) && newState.m_155947_())) {
                level.m_46747_(pos);
            }
        }
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder params) {
        IEnchantable enchantable;
        BlockEntity blockentity = (BlockEntity)params.m_287261_(LootContextParams.f_81462_);
        if (blockentity instanceof IEnchantable && (enchantable = (IEnchantable)blockentity).hasEnchantment(Enchantments.f_44963_)) {
            return List.of();
        }
        return super.m_49635_(state, params);
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource prandom) {
        IEnchantable enchantable;
        BlockEntity blockentity = level.m_7702_(pos);
        if (blockentity instanceof IEnchantable && !(enchantable = (IEnchantable)blockentity).hasEnchantment((Enchantment)ModEnchantments.CONCEALED.get())) {
            super.m_214162_(state, level, pos, prandom);
        }
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        BlockEntity blockentity = level.m_7702_(pos);
        if (blockentity instanceof IEnchantable) {
            IEnchantable enchantable = (IEnchantable)blockentity;
            enchantable.setEnchantments(stack.m_41785_());
        }
    }
}

