/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enchantableblocks.block;

import com.mrbysco.enchantableblocks.block.blockentity.EnchantedDispenserBlockEntity;
import com.mrbysco.enchantableblocks.block.blockentity.IEnchantable;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.BlockSourceImpl;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.Nullable;

public class EnchantedDispenserBlock
extends DispenserBlock {
    public EnchantedDispenserBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new EnchantedDispenserBlockEntity(pos, state);
    }

    protected void m_5824_(ServerLevel serverLevel, BlockPos pos) {
        BlockSourceImpl blocksourceimpl = new BlockSourceImpl(serverLevel, pos);
        EnchantedDispenserBlockEntity dispenserBlockEntity = (EnchantedDispenserBlockEntity)blocksourceimpl.m_8118_();
        int i = dispenserBlockEntity.m_222761_(serverLevel.f_46441_);
        if (i < 0) {
            serverLevel.m_46796_(1001, pos, 0);
            serverLevel.m_220407_(GameEvent.f_223702_, pos, GameEvent.Context.m_223722_((BlockState)dispenserBlockEntity.m_58900_()));
        } else {
            ItemStack itemstack = dispenserBlockEntity.m_8020_(i);
            DispenseItemBehavior dispenseitembehavior = this.m_7216_(itemstack);
            if (dispenseitembehavior != DispenseItemBehavior.f_123393_) {
                if (dispenserBlockEntity.hasEnchantment(Enchantments.f_44952_) && itemstack.m_204117_(ItemTags.f_13161_)) {
                    dispenseitembehavior.m_6115_((BlockSource)blocksourceimpl, itemstack);
                } else {
                    dispenserBlockEntity.m_6836_(i, dispenseitembehavior.m_6115_((BlockSource)blocksourceimpl, itemstack));
                }
            }
        }
    }

    public Item m_5456_() {
        return Items.f_41855_;
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        IEnchantable blockEntity;
        ItemStack originalStack = new ItemStack((ItemLike)Blocks.f_50061_);
        BlockEntity blockEntity2 = level.m_7702_(pos);
        if (blockEntity2 instanceof IEnchantable && (blockEntity = (IEnchantable)blockEntity2).getEnchantmentsTag() != null) {
            originalStack.m_41784_().m_128365_("Enchantments", (Tag)blockEntity.getEnchantmentsTag());
        }
        return originalStack;
    }

    public float getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        IEnchantable enchantable;
        float explosionResistance = super.getExplosionResistance(state, level, pos, explosion);
        BlockEntity blockentity = level.m_7702_(pos);
        if (blockentity instanceof IEnchantable && (enchantable = (IEnchantable)blockentity).hasEnchantment(Enchantments.f_44968_)) {
            int enchantmentLevel = enchantable.getEnchantmentLevel(Enchantments.f_44968_);
            explosionResistance *= (float)((enchantmentLevel + 1) * 30);
        }
        return explosionResistance;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            EnchantedDispenserBlockEntity dispenserBlockEntity;
            BlockEntity blockentity = level.m_7702_(pos);
            if (blockentity instanceof EnchantedDispenserBlockEntity && !(dispenserBlockEntity = (EnchantedDispenserBlockEntity)blockentity).hasEnchantment(Enchantments.f_44963_)) {
                Containers.m_19002_((Level)level, (BlockPos)pos, (Container)dispenserBlockEntity);
                level.m_46717_(pos, (Block)this);
            }
            if (!(!state.m_155947_() || state.m_60713_(newState.m_60734_()) && newState.m_155947_())) {
                level.m_46747_(pos);
            }
        }
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder params) {
        IEnchantable enchantable;
        BlockEntity blockentity = (BlockEntity)params.m_287261_(LootContextParams.f_81462_);
        if (blockentity instanceof IEnchantable && (enchantable = (IEnchantable)blockentity).hasEnchantment(Enchantments.f_44963_)) {
            return List.of();
        }
        return super.m_49635_(state, params);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        BlockEntity blockentity = level.m_7702_(pos);
        if (blockentity instanceof IEnchantable) {
            IEnchantable enchantable = (IEnchantable)blockentity;
            enchantable.setEnchantments(stack.m_41785_());
        }
    }
}

