/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enchantableblocks.block;

import com.mrbysco.enchantableblocks.block.blockentity.IEnchantable;
import com.mrbysco.enchantableblocks.block.blockentity.furnace.AbstractEnchantedFurnaceBlockEntity;
import com.mrbysco.enchantableblocks.block.blockentity.furnace.EnchantedFurnaceBlockEntity;
import com.mrbysco.enchantableblocks.registry.ModEnchantments;
import com.mrbysco.enchantableblocks.registry.ModRegistry;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FurnaceBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class EnchantedFurnaceBlock
extends FurnaceBlock {
    public EnchantedFurnaceBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new EnchantedFurnaceBlockEntity(pos, state);
    }

    public float getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        IEnchantable enchantable;
        float explosionResistance = super.getExplosionResistance(state, level, pos, explosion);
        BlockEntity blockentity = level.m_7702_(pos);
        if (blockentity instanceof IEnchantable && (enchantable = (IEnchantable)blockentity).hasEnchantment(Enchantments.f_44968_)) {
            int enchantmentLevel = enchantable.getEnchantmentLevel(Enchantments.f_44968_);
            explosionResistance *= (float)((enchantmentLevel + 1) * 30);
        }
        return explosionResistance;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockentity = level.m_7702_(pos);
            if (blockentity instanceof AbstractEnchantedFurnaceBlockEntity) {
                AbstractEnchantedFurnaceBlockEntity enchantedFurnaceBlockEntity = (AbstractEnchantedFurnaceBlockEntity)blockentity;
                if (level instanceof ServerLevel && !enchantedFurnaceBlockEntity.hasEnchantment(Enchantments.f_44963_)) {
                    Containers.m_19002_((Level)level, (BlockPos)pos, (Container)enchantedFurnaceBlockEntity);
                    enchantedFurnaceBlockEntity.m_154995_((ServerLevel)level, Vec3.m_82512_((Vec3i)pos));
                }
                level.m_46717_(pos, (Block)this);
            }
            if (!(!state.m_155947_() || state.m_60713_(newState.m_60734_()) && newState.m_155947_())) {
                level.m_46747_(pos);
            }
        }
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder params) {
        IEnchantable enchantable;
        BlockEntity blockentity = (BlockEntity)params.m_287261_(LootContextParams.f_81462_);
        if (blockentity instanceof IEnchantable && (enchantable = (IEnchantable)blockentity).hasEnchantment(Enchantments.f_44963_)) {
            return List.of();
        }
        return super.m_49635_(state, params);
    }

    public Item m_5456_() {
        return Items.f_41962_;
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        IEnchantable blockEntity;
        ItemStack originalStack = new ItemStack((ItemLike)Blocks.f_50094_);
        BlockEntity blockEntity2 = level.m_7702_(pos);
        if (blockEntity2 instanceof IEnchantable && (blockEntity = (IEnchantable)blockEntity2).getEnchantmentsTag() != null) {
            originalStack.m_41784_().m_128365_("Enchantments", (Tag)blockEntity.getEnchantmentsTag());
        }
        return originalStack;
    }

    protected void m_7137_(Level level, BlockPos pos, Player player) {
        BlockEntity blockentity = level.m_7702_(pos);
        if (blockentity instanceof AbstractEnchantedFurnaceBlockEntity) {
            player.m_5893_((MenuProvider)blockentity);
            player.m_36220_(Stats.f_12966_);
        }
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource prandom) {
        IEnchantable enchantable;
        BlockEntity blockentity = level.m_7702_(pos);
        if (blockentity instanceof IEnchantable && !(enchantable = (IEnchantable)blockentity).hasEnchantment((Enchantment)ModEnchantments.CONCEALED.get())) {
            super.m_214162_(state, level, pos, prandom);
        }
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        BlockEntity blockentity = level.m_7702_(pos);
        if (blockentity instanceof IEnchantable) {
            IEnchantable enchantable = (IEnchantable)blockentity;
            enchantable.setEnchantments(stack.m_41785_());
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return EnchantedFurnaceBlock.createEnchantedFurnaceTicker(level, blockEntityType, (BlockEntityType<? extends AbstractEnchantedFurnaceBlockEntity>)((BlockEntityType)ModRegistry.ENCHANTED_FURNACE_BLOCK_ENTITY.get()));
    }

    @Nullable
    protected static <T extends BlockEntity> BlockEntityTicker<T> createEnchantedFurnaceTicker(Level level, BlockEntityType<T> serverType, BlockEntityType<? extends AbstractEnchantedFurnaceBlockEntity> clientType) {
        return level.f_46443_ ? null : EnchantedFurnaceBlock.m_152132_(serverType, clientType, AbstractEnchantedFurnaceBlockEntity::serverTick);
    }
}

