/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enchantableblocks.block;

import com.mrbysco.enchantableblocks.block.blockentity.EnchantedBlockEntity;
import com.mrbysco.enchantableblocks.block.blockentity.IEnchantable;
import com.mrbysco.enchantableblocks.registry.ModEnchantments;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RespawnAnchorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class EnchantedRespawnAnchorBlock
extends RespawnAnchorBlock
implements EntityBlock {
    public EnchantedRespawnAnchorBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new EnchantedBlockEntity(pos, state);
    }

    public Item m_5456_() {
        return Items.f_42767_;
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        IEnchantable blockEntity;
        ItemStack originalStack = new ItemStack((ItemLike)Blocks.f_50724_);
        BlockEntity blockEntity2 = level.m_7702_(pos);
        if (blockEntity2 instanceof IEnchantable && (blockEntity = (IEnchantable)blockEntity2).getEnchantmentsTag() != null) {
            originalStack.m_41784_().m_128365_("Enchantments", (Tag)blockEntity.getEnchantmentsTag());
        }
        return originalStack;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ServerPlayer serverplayer;
        ItemStack itemstack = player.m_21120_(hand);
        boolean explodes = false;
        int efficiency = 1;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof IEnchantable) {
            IEnchantable enchantable = (IEnchantable)blockEntity;
            explodes = enchantable.hasEnchantment((Enchantment)ModEnchantments.INTENTIONAL_GAME_DESIGN.get());
            if (enchantable.hasEnchantment(Enchantments.f_44984_)) {
                efficiency = enchantable.getEnchantmentLevel(Enchantments.f_44984_);
            }
        }
        if (hand == InteractionHand.MAIN_HAND && !EnchantedRespawnAnchorBlock.m_55848_(itemstack) && EnchantedRespawnAnchorBlock.m_55848_(player.m_21120_(InteractionHand.OFF_HAND))) {
            return InteractionResult.PASS;
        }
        if (EnchantedRespawnAnchorBlock.m_55848_(itemstack) && EnchantedRespawnAnchorBlock.m_55894_(state)) {
            EnchantedRespawnAnchorBlock.charge((Entity)player, level, pos, state, efficiency);
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if ((Integer)state.m_61143_((Property)f_55833_) == 0) {
            return InteractionResult.PASS;
        }
        if (!EnchantedRespawnAnchorBlock.m_55850_((Level)level) || explodes) {
            if (!level.f_46443_) {
                this.m_55890_(state, level, pos);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (!(level.f_46443_ || (serverplayer = (ServerPlayer)player).m_8963_() == level.m_46472_() && pos.equals((Object)serverplayer.m_8961_()))) {
            serverplayer.m_9158_(level.m_46472_(), pos, 0.0f, false, true);
            level.m_6263_((Player)null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_12326_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }

    public static void charge(@Nullable Entity entity, Level level, BlockPos pos, BlockState state, int efficiency) {
        int currentCharge = (Integer)state.m_61143_((Property)f_55833_);
        int newCharge = Mth.m_14045_((int)(currentCharge + efficiency), (int)0, (int)4);
        BlockState blockstate = (BlockState)state.m_61124_((Property)f_55833_, (Comparable)Integer.valueOf(newCharge));
        level.m_7731_(pos, blockstate, 3);
        level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223719_((Entity)entity, (BlockState)blockstate));
        level.m_6263_((Player)null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_12376_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    private static boolean m_55848_(ItemStack stack) {
        return stack.m_150930_(Items.f_42054_);
    }

    private static boolean m_55894_(BlockState state) {
        return (Integer)state.m_61143_((Property)f_55833_) < 4;
    }

    private static boolean m_55887_(BlockPos pos, Level level) {
        FluidState fluidstate = level.m_6425_(pos);
        if (!fluidstate.m_205070_(FluidTags.f_13131_)) {
            return false;
        }
        if (fluidstate.m_76170_()) {
            return true;
        }
        float f = fluidstate.m_76186_();
        if (f < 2.0f) {
            return false;
        }
        FluidState fluidstate1 = level.m_6425_(pos.m_7495_());
        return !fluidstate1.m_205070_(FluidTags.f_13131_);
    }

    private void m_55890_(BlockState state, Level level, final BlockPos pos) {
        level.m_7471_(pos, false);
        boolean flag = Direction.Plane.HORIZONTAL.m_122557_().map(arg_0 -> ((BlockPos)pos).m_121945_(arg_0)).anyMatch(p_55854_ -> EnchantedRespawnAnchorBlock.m_55887_(p_55854_, level));
        final boolean flag1 = flag || level.m_6425_(pos.m_7494_()).m_205070_(FluidTags.f_13131_);
        ExplosionDamageCalculator explosionDamageCalculator = new ExplosionDamageCalculator(){

            public Optional<Float> m_6617_(Explosion p_55904_, BlockGetter p_55905_, BlockPos p_55906_, BlockState p_55907_, FluidState p_55908_) {
                return p_55906_.equals((Object)pos) && flag1 ? Optional.of(Float.valueOf(Blocks.f_49990_.m_7325_())) : super.m_6617_(p_55904_, p_55905_, p_55906_, p_55907_, p_55908_);
            }
        };
        Vec3 vec3 = pos.m_252807_();
        level.m_254951_((Entity)null, level.m_269111_().m_269488_(vec3), explosionDamageCalculator, vec3, 5.0f, true, Level.ExplosionInteraction.BLOCK);
    }

    public float getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        IEnchantable enchantable;
        float explosionResistance = super.getExplosionResistance(state, level, pos, explosion);
        BlockEntity blockentity = level.m_7702_(pos);
        if (blockentity instanceof IEnchantable && (enchantable = (IEnchantable)blockentity).hasEnchantment(Enchantments.f_44968_)) {
            int enchantmentLevel = enchantable.getEnchantmentLevel(Enchantments.f_44968_);
            explosionResistance *= (float)((enchantmentLevel + 1) * 30);
        }
        return explosionResistance;
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder params) {
        IEnchantable enchantable;
        BlockEntity blockentity = (BlockEntity)params.m_287261_(LootContextParams.f_81462_);
        if (blockentity instanceof IEnchantable && (enchantable = (IEnchantable)blockentity).hasEnchantment(Enchantments.f_44963_)) {
            return List.of();
        }
        return super.m_49635_(state, params);
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource prandom) {
        IEnchantable enchantable;
        BlockEntity blockentity = level.m_7702_(pos);
        if (blockentity instanceof IEnchantable && !(enchantable = (IEnchantable)blockentity).hasEnchantment((Enchantment)ModEnchantments.CONCEALED.get())) {
            super.m_214162_(state, level, pos, prandom);
        }
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        BlockEntity blockentity = level.m_7702_(pos);
        if (blockentity instanceof IEnchantable) {
            IEnchantable enchantable = (IEnchantable)blockentity;
            enchantable.setEnchantments(stack.m_41785_());
        }
    }
}

