/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enchantableblocks.block.blockentity;

import com.mrbysco.enchantableblocks.block.blockentity.IEnchantable;
import com.mrbysco.enchantableblocks.registry.ModEnchantments;
import com.mrbysco.enchantableblocks.util.TagHelper;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class AbstractEnchantedBlockEntity
extends BlockEntity
implements IEnchantable {
    protected boolean hideGlint = false;
    protected ListTag enchantmentTag = null;
    protected final Object2IntMap<Enchantment> enchantments = new Object2IntOpenHashMap();

    public AbstractEnchantedBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
    }

    @Override
    public Map<Enchantment, Integer> getEnchantments() {
        return this.enchantments;
    }

    @Override
    public boolean hasEnchantment(Enchantment enchantment) {
        return this.enchantments.containsKey((Object)enchantment);
    }

    @Override
    public int getEnchantmentLevel(Enchantment enchantment) {
        if (this.hasEnchantment(enchantment)) {
            return this.enchantments.get((Object)enchantment);
        }
        return -1;
    }

    @Override
    public boolean hasEnchantment(TagKey<Enchantment> enchantmentTag) {
        for (Enchantment enchantment : this.enchantments.keySet()) {
            if (!TagHelper.matchesTag(enchantment, enchantmentTag)) continue;
            return true;
        }
        return this.enchantments.containsKey(enchantmentTag);
    }

    @Override
    public int getEnchantmentLevel(TagKey<Enchantment> enchantmentTag) {
        for (Enchantment enchantment : this.enchantments.keySet()) {
            if (!TagHelper.matchesTag(enchantment, enchantmentTag)) continue;
            return this.enchantments.get((Object)enchantment);
        }
        return -1;
    }

    @Override
    public void setEnchantments(ListTag enchantmentTags) {
        this.enchantmentTag = enchantmentTags;
        this.updateEnchantmentMap();
    }

    @Override
    public ListTag getEnchantmentsTag() {
        return this.enchantmentTag;
    }

    @Override
    public void updateEnchantmentMap() {
        this.enchantments.clear();
        if (this.enchantmentTag != null) {
            EnchantmentHelper.m_44882_((ListTag)this.enchantmentTag).forEach((enchantment, integer) -> {
                if (enchantment != null) {
                    this.enchantments.put(enchantment, integer);
                }
            });
            this.hideGlint = this.hasEnchantment((Enchantment)ModEnchantments.GLINTLESS.get());
        }
    }

    @Override
    public boolean hideGlint() {
        return this.hideGlint;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("Enchantments")) {
            this.enchantmentTag = tag.m_128437_("Enchantments", 10);
            this.updateEnchantmentMap();
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.enchantmentTag != null) {
            tag.m_128365_("Enchantments", (Tag)this.enchantmentTag);
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        CompoundTag tag = packet.m_131708_();
        if (tag != null) {
            this.handleUpdateTag(tag);
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            this.f_58857_.m_7260_(this.f_58858_, state, state, 3);
        }
    }

    public void onLoad() {
        super.onLoad();
        if (this.f_58857_ != null) {
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            this.f_58857_.m_7260_(this.f_58858_, state, state, 3);
        }
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public CompoundTag getPersistentData() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }
}

