/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enchantableblocks.block.blockentity;

import com.google.common.collect.Lists;
import com.mrbysco.enchantableblocks.block.blockentity.IEnchantable;
import com.mrbysco.enchantableblocks.menu.EnchantedBeaconMenu;
import com.mrbysco.enchantableblocks.mixin.BeaconBeamSectionAccessor;
import com.mrbysco.enchantableblocks.registry.ModEnchantments;
import com.mrbysco.enchantableblocks.registry.ModRegistry;
import com.mrbysco.enchantableblocks.util.TagHelper;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.LockCode;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class EnchantedBeaconBlockEntity
extends BeaconBlockEntity
implements IEnchantable {
    protected boolean hideGlint;
    protected ListTag enchantmentTag = null;
    protected final Object2IntMap<Enchantment> enchantments = new Object2IntOpenHashMap();

    public EnchantedBeaconBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    public BlockEntityType<?> m_58903_() {
        return (BlockEntityType)ModRegistry.ENCHANTED_BEACON_BLOCK_ENTITY.get();
    }

    public static void tick(Level level, BlockPos pos, BlockState state, EnchantedBeaconBlockEntity blockEntity) {
        BlockPos blockpos;
        int xPos = pos.m_123341_();
        int yPos = pos.m_123342_();
        int zPos = pos.m_123343_();
        if (blockEntity.f_58651_ < yPos) {
            blockpos = pos;
            blockEntity.f_58649_ = Lists.newArrayList();
            blockEntity.f_58651_ = pos.m_123342_() - 1;
        } else {
            blockpos = new BlockPos(xPos, blockEntity.f_58651_ + 1, zPos);
        }
        BeaconBlockEntity.BeaconBeamSection beamSection = blockEntity.f_58649_.isEmpty() ? null : (BeaconBlockEntity.BeaconBeamSection)blockEntity.f_58649_.get(blockEntity.f_58649_.size() - 1);
        int height = level.m_6924_(Heightmap.Types.WORLD_SURFACE, xPos, zPos);
        for (int i1 = 0; i1 < 10 && blockpos.m_123342_() <= height; ++i1) {
            BlockState blockstate = level.m_8055_(blockpos);
            float[] colorMultiplier = blockstate.getBeaconColorMultiplier((LevelReader)level, blockpos, pos);
            if (colorMultiplier != null) {
                if (blockEntity.f_58649_.size() <= 1) {
                    beamSection = new BeaconBlockEntity.BeaconBeamSection(colorMultiplier);
                    blockEntity.f_58649_.add(beamSection);
                } else if (beamSection != null) {
                    if (Arrays.equals(colorMultiplier, beamSection.m_58722_())) {
                        ((BeaconBeamSectionAccessor)beamSection).invokeIncreaseHeight();
                    } else {
                        beamSection = new BeaconBlockEntity.BeaconBeamSection(new float[]{(beamSection.m_58722_()[0] + colorMultiplier[0]) / 2.0f, (beamSection.m_58722_()[1] + colorMultiplier[1]) / 2.0f, (beamSection.m_58722_()[2] + colorMultiplier[2]) / 2.0f});
                        blockEntity.f_58649_.add(beamSection);
                    }
                }
            } else {
                if (beamSection == null || blockstate.m_60739_((BlockGetter)level, blockpos) >= 15 && !blockstate.m_60713_(Blocks.f_50752_)) {
                    blockEntity.f_58649_.clear();
                    blockEntity.f_58651_ = height;
                    break;
                }
                ((BeaconBeamSectionAccessor)beamSection).invokeIncreaseHeight();
            }
            blockpos = blockpos.m_7494_();
            ++blockEntity.f_58651_;
        }
        int levels = blockEntity.f_58650_;
        if (level.m_46467_() % 80L == 0L) {
            if (!blockEntity.f_58648_.isEmpty()) {
                blockEntity.f_58650_ = EnchantedBeaconBlockEntity.m_155092_(level, xPos, yPos, zPos);
            }
            if (blockEntity.f_58650_ > 0 && !blockEntity.f_58648_.isEmpty()) {
                EnchantedBeaconBlockEntity.applyEffects(blockEntity, level, pos, blockEntity.f_58650_, blockEntity.f_58652_, blockEntity.f_58653_);
                EnchantedBeaconBlockEntity.m_155103_((Level)level, (BlockPos)pos, (SoundEvent)SoundEvents.f_11737_);
            }
        }
        if (blockEntity.f_58651_ >= height) {
            blockEntity.f_58651_ = level.m_141937_() - 1;
            boolean flag = levels > 0;
            blockEntity.f_58648_ = blockEntity.f_58649_;
            if (!level.f_46443_) {
                boolean flag1;
                boolean bl = flag1 = blockEntity.f_58650_ > 0;
                if (!flag && flag1) {
                    EnchantedBeaconBlockEntity.m_155103_((Level)level, (BlockPos)pos, (SoundEvent)SoundEvents.f_11736_);
                    for (ServerPlayer serverplayer : level.m_45976_(ServerPlayer.class, new AABB((double)xPos, (double)yPos, (double)zPos, (double)xPos, (double)(yPos - 4), (double)zPos).m_82377_(10.0, 5.0, 10.0))) {
                        CriteriaTriggers.f_10578_.m_148029_(serverplayer, blockEntity.f_58650_);
                    }
                } else if (flag && !flag1) {
                    EnchantedBeaconBlockEntity.m_155103_((Level)level, (BlockPos)pos, (SoundEvent)SoundEvents.f_11738_);
                }
            }
        }
    }

    private static int m_155092_(Level pLevel, int pX, int pY, int pZ) {
        int k;
        int i = 0;
        int j = 1;
        while (j <= 4 && (k = pY - j) >= pLevel.m_141937_()) {
            boolean flag = true;
            block1: for (int l = pX - j; l <= pX + j && flag; ++l) {
                for (int i1 = pZ - j; i1 <= pZ + j; ++i1) {
                    if (pLevel.m_8055_(new BlockPos(l, k, i1)).m_204336_(BlockTags.f_13079_)) continue;
                    flag = false;
                    continue block1;
                }
            }
            if (!flag) break;
            i = j++;
        }
        return i;
    }

    private static void applyEffects(EnchantedBeaconBlockEntity blockEntity, Level level, BlockPos pos, int levels, @Nullable MobEffect primary, @Nullable MobEffect secondary) {
        if (!level.f_46443_ && primary != null) {
            boolean visible = !blockEntity.hasEnchantment((Enchantment)ModEnchantments.CONCEALED.get());
            double range = levels * 10 + 10;
            if (blockEntity.hasEnchantment((Enchantment)ModEnchantments.RANGED.get())) {
                int enchantmentLevel = blockEntity.getEnchantmentLevel((Enchantment)ModEnchantments.RANGED.get());
                range *= 1.0 + (double)enchantmentLevel * 0.5;
            }
            int amplifier = 0;
            if (levels >= 4 && primary == secondary) {
                amplifier = 1;
            }
            int duration = (9 + levels * 2) * 20;
            AABB aabb = new AABB(pos).m_82400_(range).m_82363_(0.0, (double)level.m_141928_(), 0.0);
            List players = level.m_45976_(Player.class, aabb);
            for (Player player : players) {
                player.m_7292_(new MobEffectInstance(primary, duration, amplifier, true, visible));
            }
            if (levels >= 4 && primary != secondary && secondary != null) {
                for (Player player : players) {
                    player.m_7292_(new MobEffectInstance(secondary, duration, 0, true, visible));
                }
            }
        }
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory inventory, Player player) {
        return BaseContainerBlockEntity.m_58629_((Player)player, (LockCode)this.f_58655_, (Component)this.m_5446_()) ? new EnchantedBeaconMenu(containerId, (Container)inventory, this.f_58656_, ContainerLevelAccess.m_39289_((Level)this.f_58857_, (BlockPos)this.m_58899_())) : null;
    }

    @Override
    public Map<Enchantment, Integer> getEnchantments() {
        return this.enchantments;
    }

    @Override
    public boolean hasEnchantment(Enchantment enchantment) {
        return this.enchantments.containsKey((Object)enchantment);
    }

    @Override
    public int getEnchantmentLevel(Enchantment enchantment) {
        if (this.hasEnchantment(enchantment)) {
            return this.enchantments.get((Object)enchantment);
        }
        return -1;
    }

    @Override
    public boolean hasEnchantment(TagKey<Enchantment> enchantmentTag) {
        for (Enchantment enchantment : this.enchantments.keySet()) {
            if (!TagHelper.matchesTag(enchantment, enchantmentTag)) continue;
            return true;
        }
        return this.enchantments.containsKey(enchantmentTag);
    }

    @Override
    public int getEnchantmentLevel(TagKey<Enchantment> enchantmentTag) {
        for (Enchantment enchantment : this.enchantments.keySet()) {
            if (!TagHelper.matchesTag(enchantment, enchantmentTag)) continue;
            return this.enchantments.get((Object)enchantment);
        }
        return -1;
    }

    @Override
    public void setEnchantments(ListTag enchantmentTags) {
        this.enchantmentTag = enchantmentTags;
        this.updateEnchantmentMap();
    }

    @Override
    public ListTag getEnchantmentsTag() {
        return this.enchantmentTag;
    }

    @Override
    public void updateEnchantmentMap() {
        this.enchantments.clear();
        if (this.enchantmentTag != null) {
            EnchantmentHelper.m_44882_((ListTag)this.enchantmentTag).forEach((enchantment, integer) -> {
                if (enchantment != null) {
                    this.enchantments.put(enchantment, integer);
                }
            });
            this.hideGlint = this.hasEnchantment((Enchantment)ModEnchantments.GLINTLESS.get());
        }
    }

    @Override
    public boolean hideGlint() {
        return this.hideGlint;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("Enchantments")) {
            this.enchantmentTag = tag.m_128437_("Enchantments", 10);
            this.updateEnchantmentMap();
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.enchantmentTag != null) {
            tag.m_128365_("Enchantments", (Tag)this.enchantmentTag);
        }
    }

    public ClientboundBlockEntityDataPacket m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        CompoundTag tag = packet.m_131708_();
        if (tag != null) {
            this.handleUpdateTag(tag);
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            this.f_58857_.m_7260_(this.f_58858_, state, state, 3);
        }
    }

    public void onLoad() {
        super.onLoad();
        if (this.f_58857_ != null) {
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            this.f_58857_.m_7260_(this.f_58858_, state, state, 3);
        }
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public CompoundTag getPersistentData() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }
}

