/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enchantableblocks.block.blockentity;

import com.mrbysco.enchantableblocks.block.blockentity.AbstractEnchantedBlockEntity;
import com.mrbysco.enchantableblocks.block.blockentity.IEnchantable;
import com.mrbysco.enchantableblocks.registry.ModEnchantments;
import com.mrbysco.enchantableblocks.registry.ModRegistry;
import com.mrbysco.enchantableblocks.registry.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestLidController;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnchantedChestBlockEntity
extends AbstractEnchantedBlockEntity
implements LidBlockEntity,
Container,
MenuProvider,
Nameable,
IEnchantable {
    @Nullable
    private Component name;
    public final ItemStackHandler handler = new ItemStackHandler(54){

        protected void onContentsChanged(int slot) {
            EnchantedChestBlockEntity.this.m_6596_();
        }

        public void setStackInSlot(int slot, @NotNull ItemStack stack) {
            if (!EnchantedChestBlockEntity.this.isWithinRange(slot)) {
                return;
            }
            super.setStackInSlot(slot, stack);
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (!EnchantedChestBlockEntity.this.isWithinRange(slot)) {
                return ItemStack.f_41583_;
            }
            return super.extractItem(slot, amount, simulate);
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            if (!EnchantedChestBlockEntity.this.isWithinRange(slot)) {
                return ItemStack.f_41583_;
            }
            return super.getStackInSlot(slot);
        }

        public int getSlots() {
            int storingLevel = EnchantedChestBlockEntity.this.getEnchantmentLevel(ModTags.General.STORAGE_UPGRADE);
            if (storingLevel < 1) {
                return 27;
            }
            if (storingLevel == 1) {
                return 36;
            }
            if (storingLevel == 2) {
                return 45;
            }
            return super.getSlots();
        }
    };
    private final LazyOptional<IItemHandler> handlerHolder = LazyOptional.of(() -> this.handler);
    private final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void m_142292_(Level level, BlockPos pos, BlockState state) {
            EnchantedChestBlockEntity.playSound(level, pos, state, SoundEvents.f_11749_);
        }

        protected void m_142289_(Level level, BlockPos pos, BlockState state) {
            EnchantedChestBlockEntity.playSound(level, pos, state, SoundEvents.f_11747_);
        }

        protected void m_142148_(Level level, BlockPos pos, BlockState state, int eventID, int eventParam) {
            EnchantedChestBlockEntity.this.signalOpenCount(level, pos, state, eventID, eventParam);
        }

        protected boolean m_142718_(Player player) {
            if (!(player.f_36096_ instanceof ChestMenu)) {
                return false;
            }
            Container container = ((ChestMenu)player.f_36096_).m_39261_();
            return container == EnchantedChestBlockEntity.this || container instanceof CompoundContainer && ((CompoundContainer)container).m_18927_((Container)EnchantedChestBlockEntity.this);
        }
    };
    private final ChestLidController chestLidController = new ChestLidController();

    public EnchantedChestBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
    }

    public EnchantedChestBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModRegistry.ENCHANTED_CHEST_BLOCK_ENTITY.get(), pos, state);
    }

    public static void lidAnimateTick(Level level, BlockPos pos, BlockState state, EnchantedChestBlockEntity blockEntity) {
        blockEntity.chestLidController.m_155374_();
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128425_("CustomName", 8)) {
            this.name = Component.Serializer.m_130701_((String)tag.m_128461_("CustomName"));
        }
        this.handler.deserializeNBT(tag.m_128469_("Items"));
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.name != null) {
            tag.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.name));
        }
        tag.m_128365_("Items", (Tag)this.handler.serializeNBT());
    }

    public void setCustomName(Component pName) {
        this.name = pName;
    }

    public Component m_7755_() {
        return this.name != null ? this.name : Component.m_237115_((String)"container.chest");
    }

    public Component m_5446_() {
        return this.m_7755_();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerID, Inventory playerInventory, Player player) {
        return null;
    }

    public float m_6683_(float partialTicks) {
        return this.chestLidController.m_155375_(partialTicks);
    }

    public static int getOpenCount(BlockGetter pLevel, BlockPos pPos) {
        BlockEntity blockentity;
        BlockState blockstate = pLevel.m_8055_(pPos);
        if (blockstate.m_155947_() && (blockentity = pLevel.m_7702_(pPos)) instanceof EnchantedChestBlockEntity) {
            return ((EnchantedChestBlockEntity)blockentity).openersCounter.m_155450_();
        }
        return 0;
    }

    private static void playSound(Level level, BlockPos pos, BlockState state, SoundEvent soundEvent) {
        double d0 = (double)pos.m_123341_() + 0.5;
        double d1 = (double)pos.m_123342_() + 0.5;
        double d2 = (double)pos.m_123343_() + 0.5;
        level.m_6263_((Player)null, d0, d1, d2, soundEvent, SoundSource.BLOCKS, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
    }

    public void recheckOpen() {
        if (!this.f_58859_) {
            this.openersCounter.m_155476_(this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    protected void signalOpenCount(Level level, BlockPos pos, BlockState state, int eventID, int eventParam) {
        Block block = state.m_60734_();
        level.m_7696_(pos, block, 1, eventParam);
    }

    public boolean m_7531_(int id, int type) {
        if (id == 1) {
            this.chestLidController.m_155377_(type > 0);
            return true;
        }
        return super.m_7531_(id, type);
    }

    public void m_5856_(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155452_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void m_5785_(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155468_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public int m_6643_() {
        return this.handler.getSlots();
    }

    public boolean m_7983_() {
        for (int i = 0; i < this.handler.getSlots(); ++i) {
            if (this.handler.getStackInSlot(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int slot) {
        if (!this.isWithinRange(slot)) {
            return ItemStack.f_41583_;
        }
        return this.handler.getStackInSlot(slot);
    }

    public ItemStack m_7407_(int slot, int amount) {
        ItemStack stack = this.handler.extractItem(slot, amount, false);
        if (!this.isWithinRange(slot)) {
            return ItemStack.f_41583_;
        }
        if (!stack.m_41619_()) {
            this.m_6596_();
        }
        return stack;
    }

    public ItemStack m_8016_(int slot) {
        if (!this.isWithinRange(slot)) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = this.m_8020_(slot);
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        this.handler.setStackInSlot(slot, stack);
        return stack;
    }

    public void m_6836_(int slot, ItemStack stack) {
        if (!this.isWithinRange(slot)) {
            return;
        }
        this.handler.setStackInSlot(slot, stack);
    }

    private boolean isWithinRange(int slot) {
        int storingLevel = this.getEnchantmentLevel((Enchantment)ModEnchantments.STORING.get());
        if (storingLevel < 1) {
            return slot < 27;
        }
        if (storingLevel == 1) {
            return slot < 36;
        }
        if (storingLevel == 2) {
            return slot < 45;
        }
        return slot < 54;
    }

    public boolean m_6542_(Player player) {
        return Container.m_272074_((BlockEntity)this, (Player)player);
    }

    public void m_6211_() {
        for (int i = 0; i < this.handler.getSlots(); ++i) {
            if (this.handler.getStackInSlot(i).m_41619_()) continue;
            this.handler.setStackInSlot(i, ItemStack.f_41583_);
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (!this.f_58859_ && cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.handlerHolder.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.handlerHolder.invalidate();
    }
}

