/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enchantableblocks.block.blockentity.furnace;

import com.mrbysco.enchantableblocks.block.blockentity.IEnchantable;
import com.mrbysco.enchantableblocks.mixin.AbstractFurnaceBlockEntityAccessor;
import com.mrbysco.enchantableblocks.registry.ModEnchantments;
import com.mrbysco.enchantableblocks.registry.ModTags;
import com.mrbysco.enchantableblocks.util.TagHelper;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractEnchantedFurnaceBlockEntity
extends AbstractFurnaceBlockEntity
implements IEnchantable {
    protected boolean hideGlint = false;
    protected ListTag enchantmentTag = null;
    protected final Object2IntMap<Enchantment> enchantments = new Object2IntOpenHashMap();

    protected AbstractEnchantedFurnaceBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state, RecipeType<? extends AbstractCookingRecipe> recipeType) {
        super(blockEntityType, pos, state, recipeType);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, AbstractEnchantedFurnaceBlockEntity blockEntity) {
        ItemStack fuel;
        boolean hasFuel;
        Recipe recipe;
        boolean solarRequirements;
        AbstractFurnaceBlockEntityAccessor blockEntityAccessor = (AbstractFurnaceBlockEntityAccessor)((Object)blockEntity);
        RecipeManager.CachedCheck<Container, ? extends AbstractCookingRecipe> quickCheck = blockEntityAccessor.getQuickCheck();
        boolean wasLit = blockEntity.m_58425_();
        boolean changed = false;
        boolean hasInput = !((ItemStack)blockEntity.f_58310_.get(0)).m_41619_();
        boolean solar = blockEntity.hasEnchantment((Enchantment)ModEnchantments.SOLAR_RADIANCE.get());
        boolean bl = solarRequirements = (level.m_46461_() || level.m_6042_().m_63967_() && level.m_7445_() < 4) && level.m_45527_(pos.m_7494_());
        if (blockEntity.m_58425_()) {
            int speed = blockEntity.getSpeed();
            if (solar) {
                blockEntity.f_58316_ = solarRequirements ? 200 : (blockEntity.f_58316_ -= speed);
            } else {
                boolean preservation = blockEntity.hasEnchantment((Enchantment)ModEnchantments.PRESERVATION.get());
                if (preservation) {
                    Recipe recipe2 = recipe = hasInput ? (Recipe)quickCheck.m_213657_((Container)blockEntity, level).orElse(null) : null;
                    if (recipe != null) {
                        blockEntity.f_58316_ -= speed;
                    }
                } else {
                    blockEntity.f_58316_ -= speed;
                }
            }
        }
        boolean bl2 = hasFuel = !(fuel = (ItemStack)blockEntity.f_58310_.get(1)).m_41619_();
        if (blockEntity.m_58425_() || (solar && solarRequirements || hasFuel) && hasInput) {
            recipe = hasInput ? (Recipe)quickCheck.m_213657_((Container)blockEntity, level).orElse(null) : null;
            int i = blockEntity.m_6893_();
            if (!blockEntity.m_58425_()) {
                if (solar && solarRequirements) {
                    blockEntity.f_58317_ = blockEntity.f_58316_ = 200;
                } else if (blockEntityAccessor.invokeCanBurn(level.m_9598_(), recipe, (NonNullList<ItemStack>)blockEntity.f_58310_, i)) {
                    blockEntity.f_58317_ = blockEntity.f_58316_ = blockEntity.m_7743_(fuel);
                    if (blockEntity.m_58425_()) {
                        changed = true;
                        if (fuel.hasCraftingRemainingItem()) {
                            blockEntity.f_58310_.set(1, (Object)fuel.getCraftingRemainingItem());
                        } else if (hasFuel) {
                            fuel.m_41774_(1);
                            if (fuel.m_41619_()) {
                                blockEntity.f_58310_.set(1, (Object)fuel.getCraftingRemainingItem());
                            }
                        }
                    }
                }
            }
            if (blockEntity.m_58425_() && blockEntityAccessor.invokeCanBurn(level.m_9598_(), recipe, (NonNullList<ItemStack>)blockEntity.f_58310_, i)) {
                int speed = blockEntity.getSpeed();
                blockEntity.f_58318_ += speed;
                if (blockEntity.f_58318_ >= blockEntity.f_58319_) {
                    blockEntity.f_58318_ = 0;
                    blockEntity.f_58319_ = AbstractEnchantedFurnaceBlockEntity.getTotalCookTime(level, blockEntity);
                    if (blockEntity.enchantedBurn(level.m_9598_(), recipe, (NonNullList<ItemStack>)blockEntity.f_58310_, i)) {
                        blockEntity.m_6029_(recipe);
                    }
                    changed = true;
                }
            } else {
                blockEntity.f_58318_ = 0;
            }
        } else if (!blockEntity.m_58425_() && blockEntity.f_58318_ > 0) {
            blockEntity.f_58318_ = Mth.m_14045_((int)(blockEntity.f_58318_ - 2), (int)0, (int)blockEntity.f_58319_);
        }
        if (wasLit != blockEntity.m_58425_()) {
            changed = true;
            state = (BlockState)state.m_61124_((Property)AbstractFurnaceBlock.f_48684_, (Comparable)Boolean.valueOf(blockEntity.m_58425_()));
            level.m_7731_(pos, state, 3);
        }
        if (changed) {
            AbstractEnchantedFurnaceBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    private int getSpeed() {
        int speed = 1;
        if (this.hasEnchantment((Enchantment)ModEnchantments.SPEED.get())) {
            int enchantmentLevel = this.getEnchantmentLevel((Enchantment)ModEnchantments.SPEED.get());
            speed += enchantmentLevel;
        }
        return speed;
    }

    private boolean enchantedBurn(RegistryAccess pRegistryAccess, @Nullable Recipe<?> pRecipe, NonNullList<ItemStack> inventory, int pMaxStackSize) {
        if (pRecipe != null && ((AbstractFurnaceBlockEntityAccessor)((Object)this)).invokeCanBurn(pRegistryAccess, pRecipe, inventory, pMaxStackSize)) {
            ItemStack inputStack = (ItemStack)inventory.get(0);
            ItemStack craftedStack = pRecipe.m_5874_((Container)this, pRegistryAccess);
            if (this.hasEnchantment((Enchantment)ModEnchantments.YIELD.get()) && craftedStack.m_41613_() < craftedStack.m_41741_() && !craftedStack.m_204117_(ModTags.Items.YIELD_BLACKLIST)) {
                int enchantmentLevel = this.getEnchantmentLevel((Enchantment)ModEnchantments.YIELD.get());
                int count = 1 + enchantmentLevel;
                craftedStack.m_41764_(Mth.m_14045_((int)count, (int)1, (int)craftedStack.m_41741_()));
            }
            ItemStack resultStack = (ItemStack)inventory.get(2);
            if (this.hasEnchantment((Enchantment)ModEnchantments.EXPORTING.get()) && this.m_58900_() != null) {
                IItemHandler itemHandler;
                BlockEntity blockEntity;
                Direction direction = (Direction)this.m_58900_().m_61143_((Property)AbstractFurnaceBlock.f_48683_);
                BlockPos leftPos = this.m_58899_().m_121945_(direction.m_122427_());
                BlockPos rightPos = this.m_58899_().m_121945_(direction.m_122428_());
                if (this.f_58857_.m_46749_(leftPos) && (blockEntity = this.f_58857_.m_7702_(leftPos)) != null && (itemHandler = (IItemHandler)blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, direction.m_122428_()).orElse(null)) != null) {
                    craftedStack = ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)craftedStack, (boolean)false);
                }
                if (this.f_58857_.m_46749_(rightPos) && (blockEntity = this.f_58857_.m_7702_(rightPos)) != null && (itemHandler = (IItemHandler)blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, direction.m_122427_()).orElse(null)) != null) {
                    craftedStack = ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)craftedStack, (boolean)false);
                }
            }
            if (resultStack.m_41619_()) {
                inventory.set(2, (Object)craftedStack.m_41777_());
            } else if (resultStack.m_150930_(craftedStack.m_41720_())) {
                resultStack.m_41764_(Mth.m_14045_((int)(resultStack.m_41613_() + craftedStack.m_41613_()), (int)1, (int)resultStack.m_41741_()));
            }
            if (inputStack.m_150930_(Blocks.f_50057_.m_5456_()) && !((ItemStack)inventory.get(1)).m_41619_() && ((ItemStack)inventory.get(1)).m_150930_(Items.f_42446_)) {
                inventory.set(1, (Object)new ItemStack((ItemLike)Items.f_42447_));
            }
            inputStack.m_41774_(1);
            return true;
        }
        return false;
    }

    private static int getTotalCookTime(Level level, AbstractEnchantedFurnaceBlockEntity blockEntity) {
        AbstractFurnaceBlockEntityAccessor blockEntityAccessor = (AbstractFurnaceBlockEntityAccessor)((Object)blockEntity);
        int cookTime = blockEntityAccessor.getQuickCheck().m_213657_((Container)blockEntity, level).map(AbstractCookingRecipe::m_43753_).orElse(200);
        if (blockEntity.hasEnchantment((Enchantment)ModEnchantments.SPEED.get())) {
            int n = blockEntity.getEnchantmentLevel((Enchantment)ModEnchantments.SPEED.get());
        }
        return cookTime;
    }

    protected int m_7743_(ItemStack fuel) {
        int burnDuration = super.m_7743_(fuel);
        if (burnDuration != 0 && this.hasEnchantment((Enchantment)ModEnchantments.FUEL_EFFICIENCY.get())) {
            int enchantmentLevel = this.getEnchantmentLevel((Enchantment)ModEnchantments.FUEL_EFFICIENCY.get());
            burnDuration = Mth.m_14167_((float)((float)burnDuration * (1.0f + (float)enchantmentLevel * 0.2f)));
        }
        return burnDuration;
    }

    private boolean m_58425_() {
        return this.f_58316_ > 0;
    }

    @Override
    public Map<Enchantment, Integer> getEnchantments() {
        return this.enchantments;
    }

    @Override
    public boolean hasEnchantment(Enchantment enchantment) {
        return this.enchantments.containsKey((Object)enchantment);
    }

    @Override
    public int getEnchantmentLevel(Enchantment enchantment) {
        if (this.hasEnchantment(enchantment)) {
            return this.enchantments.get((Object)enchantment);
        }
        return -1;
    }

    @Override
    public boolean hasEnchantment(TagKey<Enchantment> enchantmentTag) {
        for (Enchantment enchantment : this.enchantments.keySet()) {
            if (!TagHelper.matchesTag(enchantment, enchantmentTag)) continue;
            return true;
        }
        return this.enchantments.containsKey(enchantmentTag);
    }

    @Override
    public int getEnchantmentLevel(TagKey<Enchantment> enchantmentTag) {
        for (Enchantment enchantment : this.enchantments.keySet()) {
            if (!TagHelper.matchesTag(enchantment, enchantmentTag)) continue;
            return this.enchantments.get((Object)enchantment);
        }
        return -1;
    }

    @Override
    public void setEnchantments(ListTag enchantmentTags) {
        this.enchantmentTag = enchantmentTags;
        this.updateEnchantmentMap();
    }

    @Override
    public ListTag getEnchantmentsTag() {
        return this.enchantmentTag;
    }

    @Override
    public void updateEnchantmentMap() {
        this.enchantments.clear();
        if (this.enchantmentTag != null) {
            EnchantmentHelper.m_44882_((ListTag)this.enchantmentTag).forEach((enchantment, integer) -> {
                if (enchantment != null) {
                    this.enchantments.put(enchantment, integer);
                }
            });
            this.hideGlint = this.hasEnchantment((Enchantment)ModEnchantments.GLINTLESS.get());
        }
    }

    @Override
    public boolean hideGlint() {
        return this.hideGlint;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("Enchantments")) {
            this.enchantmentTag = tag.m_128437_("Enchantments", 10);
            this.updateEnchantmentMap();
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.enchantmentTag != null) {
            tag.m_128365_("Enchantments", (Tag)this.enchantmentTag);
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        CompoundTag tag = packet.m_131708_();
        if (tag != null) {
            this.handleUpdateTag(tag);
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            this.f_58857_.m_7260_(this.f_58858_, state, state, 3);
        }
    }

    public void onLoad() {
        super.onLoad();
        if (this.f_58857_ != null) {
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            this.f_58857_.m_7260_(this.f_58858_, state, state, 3);
        }
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public CompoundTag getPersistentData() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }
}

