/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enchantableblocks.menu.crafting;

import java.util.stream.IntStream;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class EnchantedCraftingContainer
extends TransientCraftingContainer {
    boolean pauseUpdates;
    final ItemStackHandler inventory;

    public EnchantedCraftingContainer(AbstractContainerMenu menu, ItemStackHandler itemHandler) {
        super(menu, 3, 3);
        this.inventory = itemHandler;
    }

    public ItemStack m_8020_(int slot) {
        this.validateSlot(slot);
        return this.inventory.getStackInSlot(slot);
    }

    public ItemStack m_7407_(int slot, int amount) {
        this.validateSlot(slot);
        ItemStack stack = this.inventory.extractItem(slot, amount, false);
        if (!stack.m_41619_()) {
            this.onCraftMatrixChanged();
        }
        return stack;
    }

    public void m_6836_(int slot, @NotNull ItemStack stack) {
        this.validateSlot(slot);
        this.inventory.setStackInSlot(slot, stack);
        this.onCraftMatrixChanged();
    }

    public ItemStack m_8016_(int slot) {
        this.validateSlot(slot);
        ItemStack s = this.m_8020_(slot);
        if (s.m_41619_()) {
            return ItemStack.f_41583_;
        }
        this.onCraftMatrixChanged();
        this.m_6836_(slot, ItemStack.f_41583_);
        return s;
    }

    public boolean m_7983_() {
        return IntStream.range(0, this.inventory.getSlots()).allMatch(i -> this.inventory.getStackInSlot(i).m_41619_());
    }

    public void m_6211_() {
    }

    public void validateSlot(int slot) {
        if (slot >= 0 && slot < this.m_6643_()) {
            return;
        }
        throw new IndexOutOfBoundsException("Someone attempted to an out of bound stack at slot " + slot);
    }

    public void pauseUpdates(boolean value) {
        this.pauseUpdates = value;
    }

    public void onCraftMatrixChanged() {
        if (!this.pauseUpdates) {
            this.f_286998_.m_6199_((Container)this);
        }
    }
}

