/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enchantableblocks.menu.crafting;

import com.mrbysco.enchantableblocks.block.blockentity.EnchantedCraftingTableBlockEntity;
import com.mrbysco.enchantableblocks.menu.crafting.EnchantedCraftingContainer;
import com.mrbysco.enchantableblocks.registry.ModEnchantments;
import com.mrbysco.enchantableblocks.registry.ModMenus;
import com.mrbysco.enchantableblocks.registry.ModRegistry;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class EnchantedCraftingMenu
extends RecipeBookMenu<CraftingContainer> {
    public final CraftingContainer craftMatrix;
    private final ResultContainer resultSlots = new ResultContainer();
    private final ContainerLevelAccess access;
    private final Player player;

    public EnchantedCraftingMenu(int windowId, Inventory playerInventory, @NotNull FriendlyByteBuf data) {
        this(windowId, playerInventory, EnchantedCraftingMenu.getBlockEntity(playerInventory, data));
    }

    private static EnchantedCraftingTableBlockEntity getBlockEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null!");
        Objects.requireNonNull(data, "data cannot be null!");
        BlockEntity entityAtPos = playerInventory.f_35978_.m_9236_().m_7702_(data.m_130135_());
        if (entityAtPos instanceof EnchantedCraftingTableBlockEntity) {
            EnchantedCraftingTableBlockEntity blockEntity = (EnchantedCraftingTableBlockEntity)entityAtPos;
            return blockEntity;
        }
        throw new IllegalStateException("Block entity is not correct! " + String.valueOf(entityAtPos));
    }

    public EnchantedCraftingMenu(int id, Inventory playerInventory, EnchantedCraftingTableBlockEntity blockEntity) {
        super((MenuType)ModMenus.ENCHANTED_CRAFTING.get(), id);
        this.access = ContainerLevelAccess.m_39289_((Level)blockEntity.m_58904_(), (BlockPos)blockEntity.m_58899_());
        this.player = playerInventory.f_35978_;
        this.craftMatrix = blockEntity.hasEnchantment((Enchantment)ModEnchantments.PRESERVATION.get()) ? new EnchantedCraftingContainer((AbstractContainerMenu)this, blockEntity.handler) : new TransientCraftingContainer((AbstractContainerMenu)this, 3, 3);
        this.m_38897_((Slot)new ResultSlot(playerInventory.f_35978_, this.craftMatrix, (Container)this.resultSlots, 0, 124, 35));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.m_38897_(new Slot((Container)this.craftMatrix, j + i * 3, 30 + j * 18, 17 + i * 18));
            }
        }
        for (int k = 0; k < 3; ++k) {
            for (int i1 = 0; i1 < 9; ++i1) {
                this.m_38897_(new Slot((Container)playerInventory, i1 + k * 9 + 9, 8 + i1 * 18, 84 + k * 18));
            }
        }
        for (int l = 0; l < 9; ++l) {
            this.m_38897_(new Slot((Container)playerInventory, l, 8 + l * 18, 142));
        }
        this.m_6199_((Container)this.craftMatrix);
    }

    protected static void slotChangedCraftingGrid(AbstractContainerMenu pMenu, Level pLevel, Player pPlayer, CraftingContainer pContainer, ResultContainer pResult) {
        if (!pLevel.f_46443_) {
            ItemStack itemstack1;
            CraftingRecipe craftingrecipe;
            ServerPlayer serverplayer = (ServerPlayer)pPlayer;
            ItemStack itemstack = ItemStack.f_41583_;
            Optional optional = pLevel.m_7654_().m_129894_().m_44015_(RecipeType.f_44107_, (Container)pContainer, pLevel);
            if (optional.isPresent() && pResult.m_40135_(pLevel, serverplayer, (Recipe)(craftingrecipe = (CraftingRecipe)optional.get())) && (itemstack1 = craftingrecipe.m_5874_((Container)pContainer, pLevel.m_9598_())).m_246617_(pLevel.m_246046_())) {
                itemstack = itemstack1;
            }
            pResult.m_6836_(0, itemstack);
            pMenu.m_150404_(0, itemstack);
            serverplayer.f_8906_.m_9829_((Packet)new ClientboundContainerSetSlotPacket(pMenu.f_38840_, pMenu.m_182425_(), 0, itemstack));
        }
    }

    public void m_6199_(Container pInventory) {
        this.access.m_39292_((p_39386_, p_39387_) -> EnchantedCraftingMenu.slotChangedCraftingGrid((AbstractContainerMenu)this, p_39386_, this.player, this.craftMatrix, this.resultSlots));
    }

    public void m_5816_(StackedContents itemHelper) {
        this.craftMatrix.m_5809_(itemHelper);
    }

    public void m_6650_() {
        this.craftMatrix.m_6211_();
        this.resultSlots.m_6211_();
    }

    public boolean m_6032_(Recipe<? super CraftingContainer> recipe) {
        return recipe.m_5818_((Container)this.craftMatrix, this.player.m_9236_());
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            itemstack = slotStack.m_41777_();
            if (index == 0) {
                this.access.m_39292_((p_39378_, p_39379_) -> slotStack.m_41720_().m_7836_(slotStack, p_39378_, player));
                if (!this.m_38903_(slotStack, 10, 46, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(slotStack, itemstack);
            } else if (index >= 10 && index < 46 ? !this.m_38903_(slotStack, 1, 10, false) && (index < 37 ? !this.m_38903_(slotStack, 37, 46, false) : !this.m_38903_(slotStack, 10, 37, false)) : !this.m_38903_(slotStack, 10, 46, false)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotStack.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, slotStack);
            if (index == 0) {
                player.m_36176_(slotStack, false);
            }
        }
        return itemstack;
    }

    public boolean m_5882_(ItemStack stack, Slot slot) {
        return slot.f_40218_ != this.resultSlots && super.m_5882_(stack, slot);
    }

    public int m_6636_() {
        return 0;
    }

    public int m_6635_() {
        return this.craftMatrix.m_39347_();
    }

    public int m_6656_() {
        return this.craftMatrix.m_39346_();
    }

    public int m_6653_() {
        return 10;
    }

    public RecipeBookType m_5867_() {
        return RecipeBookType.CRAFTING;
    }

    public boolean m_142157_(int pSlotIndex) {
        return pSlotIndex != this.m_6636_();
    }

    public boolean m_6875_(Player player) {
        return EnchantedCraftingMenu.m_38889_((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)ModRegistry.ENCHANTED_CRAFTING_TABLE.get()));
    }
}

