/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.undeadnights.mixin;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.monster.Zombie;
import net.petemc.undeadnights.attachment.ModAttachmentTypes;
import net.petemc.undeadnights.casts.BlockBreakingZombie;
import net.petemc.undeadnights.config.MainConfig;
import net.petemc.undeadnights.entity.DemolitionZombieEntity;
import net.petemc.undeadnights.entity.EliteZombieEntity;
import net.petemc.undeadnights.entity.HordeZombieEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Zombie.class})
public class ZombieEntityMixin
implements BlockBreakingZombie {
    @Inject(method={"hurtServer"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/monster/Zombie;setTarget(Lnet/minecraft/world/entity/LivingEntity;)V", shift=At.Shift.AFTER)}, cancellable=true)
    public void hurtServer_disableReinforcements(ServerLevel level, DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (this instanceof HordeZombieEntity) {
            cir.setReturnValue((Object)true);
        }
        if (this instanceof DemolitionZombieEntity) {
            cir.setReturnValue((Object)true);
        }
        if (this instanceof EliteZombieEntity) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"isSunSensitive"}, at={@At(value="TAIL")}, cancellable=true)
    public void isSunSensitive(CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)MainConfig.getVanillaZombiesBurnInDaylight());
    }

    @Override
    @Unique
    public boolean isBreakingBlock() {
        return (Integer)((Zombie)this).getData(ModAttachmentTypes.BLOCK_BREAKING) == 1;
    }

    @Override
    @Unique
    public void setBreakingBlock(boolean pBreaking) {
        int blockBreaking = pBreaking ? 1 : 0;
        ((Zombie)this).setData(ModAttachmentTypes.BLOCK_BREAKING, (Object)blockBreaking);
    }
}

