/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.undeadnights.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7157;
import net.petemc.undeadnights.UndeadNights;
import net.petemc.undeadnights.config.HordeConfig;
import net.petemc.undeadnights.config.MainConfig;
import net.petemc.undeadnights.world.spawner.UndeadSpawner;

public class HordeMobsCommand {
    public static boolean hordeZombiesCanBreakBlocks = false;
    public static int hordeZombiesBlockBreakingTier = 1;

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 commandRegistryAccess, class_2170.class_5364 registrationEnvironment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"undeadnights").requires(source -> source.method_9259(2))).then(class_2170.method_9247((String)"horde_mobs").then(class_2170.method_9247((String)"remove_all").executes(HordeMobsCommand::removeMobs))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"undeadnights").requires(source -> source.method_9259(2))).then(class_2170.method_9247((String)"horde_mobs").then(class_2170.method_9247((String)"print_config").executes(HordeMobsCommand::printConfig))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"undeadnights").requires(source -> source.method_9259(2))).then(class_2170.method_9247((String)"horde_mobs").then(class_2170.method_9247((String)"block_breaking").then(class_2170.method_9247((String)"enable").executes(command -> HordeMobsCommand.blockBreaking((class_2168)command.getSource(), true, 0))))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"undeadnights").requires(source -> source.method_9259(2))).then(class_2170.method_9247((String)"horde_mobs").then(class_2170.method_9247((String)"block_breaking").then(class_2170.method_9247((String)"disable").executes(command -> HordeMobsCommand.blockBreaking((class_2168)command.getSource(), false, 0))))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"undeadnights").requires(source -> source.method_9259(2))).then(class_2170.method_9247((String)"horde_mobs").then(class_2170.method_9247((String)"block_breaking").then(class_2170.method_9247((String)"set_tier").then(class_2170.method_9244((String)"tierValue", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(command -> HordeMobsCommand.blockBreaking((class_2168)command.getSource(), false, IntegerArgumentType.getInteger((CommandContext)command, (String)"tierValue"))))))));
    }

    private static int removeMobs(CommandContext<class_2168> context) {
        int count = 0;
        class_1297 class_12972 = ((class_2168)context.getSource()).method_9228();
        if (class_12972 instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_12972;
            serverPlayer.method_64398((class_2561)class_2561.method_43471((String)"message.undeadnights.command_remove_horde_mobs"));
        }
        for (UUID hordeMobUUID : UndeadNights.serverState.spawnedHordeMobs.keySet().stream().toList()) {
            ++count;
            class_1297 entity = ((class_2168)context.getSource()).method_9225().method_66347(hordeMobUUID);
            if (entity != null) {
                entity.method_31472();
                continue;
            }
            UndeadNights.serverState.hordeMobsToRemove.put(hordeMobUUID, hordeMobUUID.toString());
        }
        if (MainConfig.getPrintDebugMessages()) {
            UndeadNights.LOGGER.info("{} horde mobs removed or marked for removal", (Object)count);
        }
        return 1;
    }

    private static int printConfig(CommandContext<class_2168> context) {
        class_3222 serverPlayer;
        class_1297 class_12972;
        if (HordeConfig.getReadingConfigFailed()) {
            class_1297 class_12973 = ((class_2168)context.getSource()).method_9228();
            if (class_12973 instanceof class_3222) {
                class_3222 serverPlayer2 = (class_3222)class_12973;
                serverPlayer2.method_64398((class_2561)class_2561.method_43470((String)"Reading the horde mob config failed!\nSpawning 15 default horde zombies instead.\nPlease check: https://github.com/MC-Mods-Pete/UndeadNights/wiki").method_27692(class_124.field_1054));
            }
            return 0;
        }
        StringBuilder message = new StringBuilder("Variant: " + HordeConfig.getConfigVariant() + "\n");
        if (HordeConfig.getConfigVariant() == 1) {
            message.append("defaultHordeMob: ").append(HordeConfig.getDefaultHordeMob().mobId()).append("\n");
            if (!HordeConfig.getHordeMobs().isEmpty()) {
                for (HordeConfig.MobSpawnData hordeMob : HordeConfig.getHordeMobs()) {
                    message.append(hordeMob.mobId()).append(" chance: ").append(hordeMob.chance()).append("\n");
                }
            }
        } else if (!HordeConfig.getHordes().isEmpty()) {
            for (HordeConfig.HordesData horde : HordeConfig.getHordes()) {
                message.append("hordeId: ").append(horde.hordeId()).append("\n");
                message.append("hordeName: ").append(horde.hordeName()).append("\n");
                if (horde.hordeMobs().isEmpty()) continue;
                for (HordeConfig.MobSpawnData hordeMob : horde.hordeMobs()) {
                    message.append(hordeMob.mobId());
                    if (hordeMob.countMin() >= hordeMob.countMax()) {
                        message.append(" count: ").append(hordeMob.countMin()).append("\n");
                        continue;
                    }
                    message.append(" count: ").append(hordeMob.countMin()).append("-").append(hordeMob.countMax()).append("\n");
                }
            }
        }
        if ((class_12972 = ((class_2168)context.getSource()).method_9228()) instanceof class_3222) {
            serverPlayer = (class_3222)class_12972;
            serverPlayer.method_64398((class_2561)class_2561.method_43470((String)message.toString()));
        }
        if (UndeadSpawner.invalidHordeMobEntry && (class_12972 = ((class_2168)context.getSource()).method_9228()) instanceof class_3222) {
            serverPlayer = (class_3222)class_12972;
            serverPlayer.method_64398((class_2561)class_2561.method_43470((String)"A horde mob entry in the horde mob config could not be read!\nA default horde zombie will be spawned instead.\nPlease check: https://github.com/MC-Mods-Pete/UndeadNights/wiki").method_27692(class_124.field_1054));
        }
        return 1;
    }

    private static int blockBreaking(class_2168 source, boolean value, int tier) {
        if (tier == 0) {
            hordeZombiesCanBreakBlocks = value;
            class_1297 class_12972 = source.method_9228();
            if (class_12972 instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)class_12972;
                serverPlayer.method_64398((class_2561)class_2561.method_43470((String)("Block breaking for Horde and Elite Zombies " + (value ? "enabled" : "disabled"))));
            }
        } else {
            hordeZombiesBlockBreakingTier = tier;
            class_1297 class_12973 = source.method_9228();
            if (class_12973 instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)class_12973;
                serverPlayer.method_64398((class_2561)class_2561.method_43470((String)("Setting block breaking tier " + tier)));
            }
        }
        return 0;
    }
}

