/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.undeadnights.event;

import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1642;
import net.minecraft.class_3218;
import net.petemc.undeadnights.UndeadNights;
import net.petemc.undeadnights.config.MainConfig;
import net.petemc.undeadnights.entity.DemolitionZombieEntity;
import net.petemc.undeadnights.entity.EliteZombieEntity;
import net.petemc.undeadnights.entity.HordeZombieEntity;
import net.petemc.undeadnights.entity.ai.goal.BreakBlockGoal;

public class ModServerEntityEvents {
    private static class_1297 pEntity;
    private static class_3218 pWorld;

    public ModServerEntityEvents() {
        ServerEntityEvents.ENTITY_LOAD.register((entity, world) -> {
            pEntity = entity;
            pWorld = world;
            ModServerEntityEvents.executeLoadEntity();
        });
        ServerEntityEvents.ENTITY_UNLOAD.register((entity, world) -> {
            pEntity = entity;
            pWorld = world;
            ModServerEntityEvents.executeUnloadEntity();
        });
    }

    public static void executeLoadEntity() {
        if (!pWorld.method_8608() && UndeadNights.serverState != null && UndeadNights.serverState.spawnedHordeMobs.containsKey(pEntity.method_5667())) {
            if (UndeadNights.serverState.hordeMobsToRemove.containsKey(pEntity.method_5667())) {
                UndeadNights.serverState.hordeMobsToRemove.remove(pEntity.method_5667());
                pEntity.method_5650(class_1297.class_5529.field_26999);
                UndeadNights.LOGGER.info("LOAD canceled, Entity marked for removal: {}", (Object)pEntity.method_5667());
            } else {
                ++UndeadNights.globalSpawnCounter;
                class_1297 class_12972 = pEntity;
                if (class_12972 instanceof class_1642) {
                    class_1642 zombie = (class_1642)class_12972;
                    if (!(zombie instanceof HordeZombieEntity || zombie instanceof DemolitionZombieEntity || zombie instanceof EliteZombieEntity)) {
                        if (MainConfig.getPrintDebugMessages()) {
                            UndeadNights.LOGGER.info("Vanilla zombie detected, adding float and block breaking goals.");
                        }
                        zombie.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)zombie));
                        zombie.field_6201.method_6277(1, (class_1352)new BreakBlockGoal(zombie));
                    }
                    if (zombie instanceof EliteZombieEntity) {
                        UndeadNights.serverState.setFirstEliteZombieHasSpawned(true);
                    }
                    if (zombie instanceof DemolitionZombieEntity) {
                        UndeadNights.serverState.setFirstDemolitionZombieHasSpawned(true);
                    }
                }
            }
            if (MainConfig.getPrintDebugMessages()) {
                UndeadNights.LOGGER.info("LOAD GlobalSpawnCount: : {} {} {}", new Object[]{UndeadNights.globalSpawnCounter, pEntity.method_5477().getString(), pEntity.method_5667()});
            }
        }
    }

    public static void executeUnloadEntity() {
        if (UndeadNights.serverState != null && UndeadNights.serverState.spawnedHordeMobs.containsKey(pEntity.method_5667()) && pEntity.method_35049() != null && (pEntity.method_35049() == class_1297.class_5529.field_26998 || pEntity.method_35049() == class_1297.class_5529.field_26999)) {
            --UndeadNights.globalSpawnCounter;
            UndeadNights.serverState.spawnedHordeMobs.remove(pEntity.method_5667());
            if (MainConfig.getPrintDebugMessages()) {
                UndeadNights.LOGGER.info("UNLOAD GlobalSpawnCount: {} {} {}", new Object[]{UndeadNights.globalSpawnCounter, pEntity.method_35049().name(), pEntity.method_5667()});
            }
        }
    }

    public static void registerEvents() {
        new ModServerEntityEvents();
    }
}

