/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.undeadnights;

import com.mojang.logging.LogUtils;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.petemc.undeadnights.client.render.DemolitionZombieRenderer;
import net.petemc.undeadnights.client.render.EliteZombieRenderer;
import net.petemc.undeadnights.client.render.HordeZombieRenderer;
import net.petemc.undeadnights.command.HordeMobsCommand;
import net.petemc.undeadnights.config.HordeConfig;
import net.petemc.undeadnights.config.MainConfig;
import net.petemc.undeadnights.effect.ModEffects;
import net.petemc.undeadnights.entity.ModEntities;
import net.petemc.undeadnights.item.ModCreativeModeTabs;
import net.petemc.undeadnights.item.ModItems;
import net.petemc.undeadnights.potion.ModPotions;
import net.petemc.undeadnights.sound.UndeadNightsSounds;
import net.petemc.undeadnights.util.StateSaverAndLoader;
import net.petemc.undeadnights.world.spawner.UndeadSpawner;
import org.slf4j.Logger;

@Mod(value="undeadnights")
public class UndeadNights {
    public static final String MOD_ID = "undeadnights";
    public static final String MOD_NAME = "UndeadNights";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static StateSaverAndLoader serverState = null;
    public static int globalSpawnCounter = 0;

    public UndeadNights(IEventBus modEventBus, ModContainer modContainer) {
        UndeadNightsSounds.register(modEventBus);
        ModEntities.register(modEventBus);
        ModEffects.register(modEventBus);
        ModItems.register(modEventBus);
        ModPotions.register(modEventBus);
        ModCreativeModeTabs.register(modEventBus);
        modEventBus.addListener(this::commonSetup);
        NeoForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::addCreative);
        modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)MainConfig.SPEC_SERVER);
        HordeConfig.loadConfig();
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("Initializing the {} Mod", (Object)MOD_NAME);
        event.enqueueWork(() -> {});
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.SPAWN_EGGS) {
            event.accept((ItemLike)ModItems.HORDE_ZOMBIE_SPAWN_EGG.get());
            event.accept((ItemLike)ModItems.ELITE_ZOMBIE_SPAWN_EGG.get());
            event.accept((ItemLike)ModItems.DEMOLITION_ZOMBIE_SPAWN_EGG.get());
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("Initializing UndeadNights Mod");
        if (serverState == null) {
            serverState = (StateSaverAndLoader)event.getServer().overworld().getDataStorage().computeIfAbsent(StateSaverAndLoader.createStateType());
            if (serverState.getLastMaxDaysCounter() != MainConfig.getDaysBetweenHordeNights()) {
                serverState.setDaysCounter(MainConfig.getDaysBetweenHordeNights());
                serverState.setLastMaxDaysCounter(MainConfig.getDaysBetweenHordeNights());
            }
            if (serverState.getLastMaxGracePeriod() != MainConfig.getGracePeriodBeforeFirstHordeNight()) {
                serverState.setGracePeriod(MainConfig.getGracePeriodBeforeFirstHordeNight());
                serverState.setLastMaxGracePeriod(MainConfig.getGracePeriodBeforeFirstHordeNight());
            }
            if (serverState.getLastMaxHordesCounter() != MainConfig.getMaxHordesPerHordeNight()) {
                if (MainConfig.getMaxHordesPerHordeNight() != 0) {
                    serverState.setHordesCounter(MainConfig.getMaxHordesPerHordeNight() + 1);
                } else {
                    serverState.setHordesCounter(0);
                }
                serverState.setLastMaxHordesCounter(MainConfig.getMaxHordesPerHordeNight());
            }
            if (!MainConfig.getNoNaturalSpawningBeforeFirstHordeNight()) {
                serverState.setIsNaturalSpawningOk(true);
            }
            if (MainConfig.getPrintDebugMessages()) {
                LOGGER.info("INIT DaysCounter: {} LastMaxDaysCounter: {}", (Object)serverState.getDaysCounter(), (Object)serverState.getLastMaxDaysCounter());
                LOGGER.info("INIT HordeNight: {} SpawnZombies: {} RespawnZombies: {}", new Object[]{serverState.getHordeNight(), serverState.getSpawnZombies(), serverState.getRespawnZombies()});
            }
            UndeadSpawner.hordeToSpawn = HordeConfig.getDefaultHorde();
            HordeMobsCommand.hordeZombiesCanBreakBlocks = MainConfig.getHordeZombiesCanBreakBlocks();
            HordeMobsCommand.hordeZombiesBlockBreakingTier = MainConfig.getZombiesBlockBreakTier();
        }
    }

    @EventBusSubscriber(modid="undeadnights", value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            EntityRenderers.register(ModEntities.HORDE_ZOMBIE.get(), HordeZombieRenderer::new);
            EntityRenderers.register(ModEntities.DEMOLITION_ZOMBIE.get(), DemolitionZombieRenderer::new);
            EntityRenderers.register(ModEntities.ELITE_ZOMBIE.get(), EliteZombieRenderer::new);
        }
    }
}

