/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.undeadnights.mixin;

import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Zombie;
import net.petemc.undeadnights.casts.BlockBreakingZombie;
import net.petemc.undeadnights.config.MainConfig;
import net.petemc.undeadnights.entity.DemolitionZombieEntity;
import net.petemc.undeadnights.entity.EliteZombieEntity;
import net.petemc.undeadnights.entity.HordeZombieEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Zombie.class})
public class ZombieEntityMixin
implements BlockBreakingZombie {
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.defineId(Zombie.class, (EntityDataSerializer)EntityDataSerializers.BYTE);

    @Inject(method={"hurtServer"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/monster/Zombie;setTarget(Lnet/minecraft/world/entity/LivingEntity;)V", shift=At.Shift.AFTER)}, cancellable=true)
    public void hurtServer_disableReinforcements(ServerLevel level, DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (this instanceof HordeZombieEntity) {
            cir.setReturnValue((Object)true);
        }
        if (this instanceof DemolitionZombieEntity) {
            cir.setReturnValue((Object)true);
        }
        if (this instanceof EliteZombieEntity) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    public void defineSyncedData(SynchedEntityData.Builder builder, CallbackInfo ci) {
        builder.define(DATA_FLAGS_ID, (Object)0);
    }

    @Inject(method={"isSunSensitive"}, at={@At(value="TAIL")}, cancellable=true)
    public void isSunSensitive(CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)MainConfig.getVanillaZombiesBurnInDaylight());
    }

    @Override
    @Unique
    public boolean isBreakingBlock() {
        return ((Byte)((Entity)this).getEntityData().get(DATA_FLAGS_ID) & 1) != 0;
    }

    @Override
    @Unique
    public void setBreakingBlock(boolean pBreaking) {
        byte b0 = (Byte)((Entity)this).getEntityData().get(DATA_FLAGS_ID);
        b0 = pBreaking ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        ((Entity)this).getEntityData().set(DATA_FLAGS_ID, (Object)b0);
    }
}

