/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.undeadnights.effect;

import java.util.Comparator;
import java.util.List;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.petemc.undeadnights.UndeadNights;
import net.petemc.undeadnights.config.MainConfig;
import org.jetbrains.annotations.NotNull;

public class LureHordeMobsEffect
extends MobEffect {
    public LureHordeMobsEffect(MobEffectCategory statusEffectCategory, int color) {
        super(statusEffectCategory, color);
    }

    public boolean applyEffectTick(@NotNull LivingEntity pLivingEntity, int pAmplifier) {
        if (!pLivingEntity.level().isClientSide() && pLivingEntity instanceof Player) {
            Player pPlayer = (Player)pLivingEntity;
            Level world = pPlayer.level();
            RandomSource randomSource = pPlayer.getRandom();
            if (MainConfig.getLureHordeEffectSpawnsHorde() && !UndeadNights.serverState.entitiesWithReceivedHorde.contains(pPlayer.getUUID())) {
                if (randomSource.nextDouble() < MainConfig.getChanceForLureEffectToSpawnHorde()) {
                    UndeadNights.serverState.entitiesWithPendingHorde.add(pPlayer.getUUID());
                } else {
                    UndeadNights.serverState.entitiesWithReceivedHorde.add(pPlayer.getUUID());
                }
            }
            Vec3 entityPosition = pPlayer.position();
            AABB entitySearchArea = new AABB(entityPosition, entityPosition).inflate(15.0);
            double randomValue = Math.random();
            if (randomValue < 0.03) {
                List<Entity> sortedEntityList = world.getEntitiesOfClass(Entity.class, entitySearchArea, entityUUIDCheck -> UndeadNights.serverState.spawnedHordeMobs.contains(entityUUIDCheck.getUUID())).stream().sorted(Comparator.comparingDouble(entityDistSort -> entityDistSort.distanceToSqr(entityPosition))).toList();
                for (Entity hordeMobIterator : sortedEntityList) {
                    if (!(hordeMobIterator instanceof Mob)) continue;
                    Mob mob = (Mob)hordeMobIterator;
                    mob.setTarget((LivingEntity)pPlayer);
                }
            }
        }
        return super.applyEffectTick(pLivingEntity, pAmplifier);
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }
}

