/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.undeadnights.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Objects;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.petemc.undeadnights.UndeadNights;
import net.petemc.undeadnights.config.HordeConfig;
import net.petemc.undeadnights.config.MainConfig;
import net.petemc.undeadnights.world.spawner.HordeSpawner;

public class SetDefaultHordeCommand {
    public SetDefaultHordeCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"undeadnights").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"default_horde").then(Commands.m_82129_((String)"hordeId", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(command -> this.defaultHorde((CommandSourceStack)command.getSource(), IntegerArgumentType.getInteger((CommandContext)command, (String)"hordeId"))))));
    }

    private int defaultHorde(CommandSourceStack source, int defaultHordeId) throws CommandSyntaxException {
        Object message = null;
        if (HordeConfig.getConfigVariant() == 2) {
            if (defaultHordeId > HordeConfig.getHordes().size() || defaultHordeId < 0) {
                HordeSpawner.hordeIdFromHordesConfig = 1;
                message = "Not a valid hordeId, value set to 1";
            } else {
                HordeSpawner.hordeIdFromHordesConfig = defaultHordeId;
                message = "Set default horde to " + defaultHordeId + "\nPlease note: after a server restart this will be reverted to the value in the config file.";
            }
        } else {
            HordeSpawner.hordeIdFromHordesConfig = 1;
            message = "Please note: Horde config variant 1 does not support multiple horde configs, value is always 1";
        }
        Objects.requireNonNull(source.m_81373_()).m_213846_((Component)Component.m_237113_((String)message));
        if (MainConfig.getPrintDebugMessages()) {
            UndeadNights.LOGGER.info((String)message);
        }
        return 0;
    }
}

