/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.undeadnights.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.petemc.undeadnights.UndeadNights;
import net.petemc.undeadnights.config.MainConfig;

public class SpawnHordeCommand {
    public static boolean spawnHordeByCommand = false;
    public static Collection<? extends Entity> entities = null;

    public SpawnHordeCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"undeadnights").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"spawn_horde").executes(command -> this.spawnHorde((CommandSourceStack)command.getSource()))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"undeadnights").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"spawn_horde").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).executes(command -> this.spawnHorde((CommandSourceStack)command.getSource(), EntityArgument.m_91461_((CommandContext)command, (String)"targets"))))));
    }

    private int spawnHorde(CommandSourceStack source) throws CommandSyntaxException {
        if (UndeadNights.globalSpawnCounter < MainConfig.getHordeMobsSpawnCap()) {
            Objects.requireNonNull(source.m_81373_()).m_213846_((Component)Component.m_237115_((String)"message.undeadnights.command_spawn_horde_all"));
            if (MainConfig.getPrintDebugMessages()) {
                UndeadNights.LOGGER.info("Command to spawn hordes for all players issued.");
                if (MainConfig.getHordeWavesCanSpawnInCaves()) {
                    Objects.requireNonNull(source.m_81373_()).m_213846_((Component)Component.m_237113_((String)"Note: Cave spawning is ENABLED for hordes. Finding a spawn location may take longer."));
                }
            }
            spawnHordeByCommand = true;
            for (Entity entity : source.m_81372_().m_6907_()) {
                if (!(entity instanceof Player)) continue;
                UndeadNights.serverState.entitiesWithPendingHorde.add(entity.m_20148_());
            }
        } else {
            Objects.requireNonNull(source.m_81373_()).m_213846_((Component)Component.m_237115_((String)"message.undeadnights.spawn_cap_reached"));
        }
        return 0;
    }

    private int spawnHorde(CommandSourceStack source, Collection<? extends Entity> pTargets) throws CommandSyntaxException {
        if (UndeadNights.globalSpawnCounter < MainConfig.getHordeMobsSpawnCap()) {
            spawnHordeByCommand = true;
            if (!pTargets.isEmpty()) {
                for (Entity entity : pTargets) {
                    if (!(entity instanceof Player)) continue;
                    UndeadNights.serverState.entitiesWithPendingHorde.add(entity.m_20148_());
                }
            }
            Objects.requireNonNull(source.m_81373_()).m_213846_((Component)Component.m_237115_((String)"message.undeadnights.command_spawn_horde"));
            if (MainConfig.getPrintDebugMessages()) {
                UndeadNights.LOGGER.info("Command to spawn hordes for certain players issued.");
            }
        } else {
            Objects.requireNonNull(source.m_81373_()).m_213846_((Component)Component.m_237115_((String)"message.undeadnights.spawn_cap_reached"));
        }
        return 0;
    }
}

