/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.handmagicrenewed.network;

import java.util.function.Supplier;
import net.mcreator.handmagicrenewed.HandMagicRenewedMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class HandMagicRenewedModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        HandMagicRenewedMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.first_gesture = message.data.first_gesture;
                    variables.second_gesture = message.data.second_gesture;
                    variables.third_gesture = message.data.third_gesture;
                    variables.show_gestures = message.data.show_gestures;
                    variables.Gesture_Timer = message.data.Gesture_Timer;
                    variables.Wand_Level = message.data.Wand_Level;
                    variables.Wand_Element = message.data.Wand_Element;
                    variables.SpellCooldown = message.data.SpellCooldown;
                    variables.previous_spell_name = message.data.previous_spell_name;
                    variables.show_wand_element = message.data.show_wand_element;
                    variables.cooldownspeed = message.data.cooldownspeed;
                    variables.mana_amethysts_consumed = message.data.mana_amethysts_consumed;
                    variables.mana_amount = message.data.mana_amount;
                    variables.max_mana_amount = message.data.max_mana_amount;
                    variables.mana_overlay_placement = message.data.mana_overlay_placement;
                    variables.show_mana_overlay = message.data.show_mana_overlay;
                    variables.wind_unlocked = message.data.wind_unlocked;
                    variables.fire_unlocked = message.data.fire_unlocked;
                    variables.earth_unlocked = message.data.earth_unlocked;
                    variables.end_unlocked = message.data.end_unlocked;
                    variables.life_unlocked = message.data.life_unlocked;
                    variables.lightning_unlocked = message.data.lightning_unlocked;
                    variables.light_unlocked = message.data.light_unlocked;
                    variables.darkness_unlocked = message.data.darkness_unlocked;
                    variables.water_unlocked = message.data.water_unlocked;
                    variables.previous_spell_name_2 = message.data.previous_spell_name_2;
                    variables.previous_spell_name_3 = message.data.previous_spell_name_3;
                    variables.memory_sigils_number = message.data.memory_sigils_number;
                    variables.spells_researched = message.data.spells_researched;
                    variables.SpellNameInScroll = message.data.SpellNameInScroll;
                    variables.ScrollSpellGestureFirst = message.data.ScrollSpellGestureFirst;
                    variables.ScrollSpellGestureSecond = message.data.ScrollSpellGestureSecond;
                    variables.ScrollSpellGestureThird = message.data.ScrollSpellGestureThird;
                    variables.SpellScrollPage = message.data.SpellScrollPage;
                    variables.ScrollSpellElement = message.data.ScrollSpellElement;
                    variables.text_tip_spell_scroll = message.data.text_tip_spell_scroll;
                    variables.destroying_tag = message.data.destroying_tag;
                    variables.ritual_name = message.data.ritual_name;
                    variables.ritual_info = message.data.ritual_info;
                    variables.ritual_page = message.data.ritual_page;
                    variables.ritual_block_1 = message.data.ritual_block_1;
                    variables.ritual_block_2 = message.data.ritual_block_2;
                    variables.ritual_block_3 = message.data.ritual_block_3;
                    variables.ritual_block_4 = message.data.ritual_block_4;
                    variables.ritual_block_5 = message.data.ritual_block_5;
                    variables.ritual_block_6 = message.data.ritual_block_6;
                    variables.ritual_block_7 = message.data.ritual_block_7;
                    variables.ritual_block_8 = message.data.ritual_block_8;
                    variables.ritual_item_result = message.data.ritual_item_result;
                    variables.max_ritual_pages = message.data.max_ritual_pages;
                    variables.researched_rituals = message.data.researched_rituals;
                    variables.ritual_main_hand = message.data.ritual_main_hand;
                    variables.ritual_left_hand = message.data.ritual_left_hand;
                    variables.researched_preparations = message.data.researched_preparations;
                    variables.max_spell_scroll_pages = message.data.max_spell_scroll_pages;
                    variables.preparations_tip_spell_scrol = message.data.preparations_tip_spell_scrol;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double first_gesture = 0.0;
        public double second_gesture = 0.0;
        public double third_gesture = 0.0;
        public boolean show_gestures = true;
        public double Gesture_Timer = 0.0;
        public double Wand_Level = 0.0;
        public double Wand_Element = 0.0;
        public double SpellCooldown = 0.0;
        public String previous_spell_name = "\"\"";
        public boolean show_wand_element = true;
        public double cooldownspeed = 20.0;
        public double mana_amethysts_consumed = 0.0;
        public double mana_amount = 0.0;
        public double max_mana_amount = 500.0;
        public double mana_overlay_placement = 0.0;
        public boolean show_mana_overlay = true;
        public boolean wind_unlocked = false;
        public boolean fire_unlocked = false;
        public boolean earth_unlocked = false;
        public boolean end_unlocked = false;
        public boolean life_unlocked = false;
        public boolean lightning_unlocked = false;
        public boolean light_unlocked = false;
        public boolean darkness_unlocked = false;
        public boolean water_unlocked = false;
        public String previous_spell_name_2 = "\"\"";
        public String previous_spell_name_3 = "\"\"";
        public double memory_sigils_number = 0.0;
        public String spells_researched = "\"\"";
        public String SpellNameInScroll = "\"\"";
        public double ScrollSpellGestureFirst = 0.0;
        public double ScrollSpellGestureSecond = 0.0;
        public double ScrollSpellGestureThird = 0.0;
        public double SpellScrollPage = 0.0;
        public double ScrollSpellElement = 0.0;
        public String text_tip_spell_scroll = "\"\"";
        public String destroying_tag = "\"\"";
        public String ritual_name = "\"\"";
        public String ritual_info = "\"\"";
        public double ritual_page = 0.0;
        public String ritual_block_1 = "\"\"";
        public String ritual_block_2 = "\"\"";
        public String ritual_block_3 = "\"\"";
        public String ritual_block_4 = "\"\"";
        public String ritual_block_5 = "\"\"";
        public String ritual_block_6 = "\"\"";
        public String ritual_block_7 = "\"\"";
        public String ritual_block_8 = "\"\"";
        public String ritual_item_result = "\"\"";
        public double max_ritual_pages = 0.0;
        public String researched_rituals = "\"\"";
        public String ritual_main_hand = "\"\"";
        public String ritual_left_hand = "\"\"";
        public String researched_preparations = "\"\"";
        public double max_spell_scroll_pages = 0.0;
        public String preparations_tip_spell_scrol = "\"\"";

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                HandMagicRenewedMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("first_gesture", this.first_gesture);
            nbt.m_128347_("second_gesture", this.second_gesture);
            nbt.m_128347_("third_gesture", this.third_gesture);
            nbt.m_128379_("show_gestures", this.show_gestures);
            nbt.m_128347_("Gesture_Timer", this.Gesture_Timer);
            nbt.m_128347_("Wand_Level", this.Wand_Level);
            nbt.m_128347_("Wand_Element", this.Wand_Element);
            nbt.m_128347_("SpellCooldown", this.SpellCooldown);
            nbt.m_128359_("previous_spell_name", this.previous_spell_name);
            nbt.m_128379_("show_wand_element", this.show_wand_element);
            nbt.m_128347_("cooldownspeed", this.cooldownspeed);
            nbt.m_128347_("mana_amethysts_consumed", this.mana_amethysts_consumed);
            nbt.m_128347_("mana_amount", this.mana_amount);
            nbt.m_128347_("max_mana_amount", this.max_mana_amount);
            nbt.m_128347_("mana_overlay_placement", this.mana_overlay_placement);
            nbt.m_128379_("show_mana_overlay", this.show_mana_overlay);
            nbt.m_128379_("wind_unlocked", this.wind_unlocked);
            nbt.m_128379_("fire_unlocked", this.fire_unlocked);
            nbt.m_128379_("earth_unlocked", this.earth_unlocked);
            nbt.m_128379_("end_unlocked", this.end_unlocked);
            nbt.m_128379_("life_unlocked", this.life_unlocked);
            nbt.m_128379_("lightning_unlocked", this.lightning_unlocked);
            nbt.m_128379_("light_unlocked", this.light_unlocked);
            nbt.m_128379_("darkness_unlocked", this.darkness_unlocked);
            nbt.m_128379_("water_unlocked", this.water_unlocked);
            nbt.m_128359_("previous_spell_name_2", this.previous_spell_name_2);
            nbt.m_128359_("previous_spell_name_3", this.previous_spell_name_3);
            nbt.m_128347_("memory_sigils_number", this.memory_sigils_number);
            nbt.m_128359_("spells_researched", this.spells_researched);
            nbt.m_128359_("SpellNameInScroll", this.SpellNameInScroll);
            nbt.m_128347_("ScrollSpellGestureFirst", this.ScrollSpellGestureFirst);
            nbt.m_128347_("ScrollSpellGestureSecond", this.ScrollSpellGestureSecond);
            nbt.m_128347_("ScrollSpellGestureThird", this.ScrollSpellGestureThird);
            nbt.m_128347_("SpellScrollPage", this.SpellScrollPage);
            nbt.m_128347_("ScrollSpellElement", this.ScrollSpellElement);
            nbt.m_128359_("text_tip_spell_scroll", this.text_tip_spell_scroll);
            nbt.m_128359_("destroying_tag", this.destroying_tag);
            nbt.m_128359_("ritual_name", this.ritual_name);
            nbt.m_128359_("ritual_info", this.ritual_info);
            nbt.m_128347_("ritual_page", this.ritual_page);
            nbt.m_128359_("ritual_block_1", this.ritual_block_1);
            nbt.m_128359_("ritual_block_2", this.ritual_block_2);
            nbt.m_128359_("ritual_block_3", this.ritual_block_3);
            nbt.m_128359_("ritual_block_4", this.ritual_block_4);
            nbt.m_128359_("ritual_block_5", this.ritual_block_5);
            nbt.m_128359_("ritual_block_6", this.ritual_block_6);
            nbt.m_128359_("ritual_block_7", this.ritual_block_7);
            nbt.m_128359_("ritual_block_8", this.ritual_block_8);
            nbt.m_128359_("ritual_item_result", this.ritual_item_result);
            nbt.m_128347_("max_ritual_pages", this.max_ritual_pages);
            nbt.m_128359_("researched_rituals", this.researched_rituals);
            nbt.m_128359_("ritual_main_hand", this.ritual_main_hand);
            nbt.m_128359_("ritual_left_hand", this.ritual_left_hand);
            nbt.m_128359_("researched_preparations", this.researched_preparations);
            nbt.m_128347_("max_spell_scroll_pages", this.max_spell_scroll_pages);
            nbt.m_128359_("preparations_tip_spell_scrol", this.preparations_tip_spell_scrol);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.first_gesture = nbt.m_128459_("first_gesture");
            this.second_gesture = nbt.m_128459_("second_gesture");
            this.third_gesture = nbt.m_128459_("third_gesture");
            this.show_gestures = nbt.m_128471_("show_gestures");
            this.Gesture_Timer = nbt.m_128459_("Gesture_Timer");
            this.Wand_Level = nbt.m_128459_("Wand_Level");
            this.Wand_Element = nbt.m_128459_("Wand_Element");
            this.SpellCooldown = nbt.m_128459_("SpellCooldown");
            this.previous_spell_name = nbt.m_128461_("previous_spell_name");
            this.show_wand_element = nbt.m_128471_("show_wand_element");
            this.cooldownspeed = nbt.m_128459_("cooldownspeed");
            this.mana_amethysts_consumed = nbt.m_128459_("mana_amethysts_consumed");
            this.mana_amount = nbt.m_128459_("mana_amount");
            this.max_mana_amount = nbt.m_128459_("max_mana_amount");
            this.mana_overlay_placement = nbt.m_128459_("mana_overlay_placement");
            this.show_mana_overlay = nbt.m_128471_("show_mana_overlay");
            this.wind_unlocked = nbt.m_128471_("wind_unlocked");
            this.fire_unlocked = nbt.m_128471_("fire_unlocked");
            this.earth_unlocked = nbt.m_128471_("earth_unlocked");
            this.end_unlocked = nbt.m_128471_("end_unlocked");
            this.life_unlocked = nbt.m_128471_("life_unlocked");
            this.lightning_unlocked = nbt.m_128471_("lightning_unlocked");
            this.light_unlocked = nbt.m_128471_("light_unlocked");
            this.darkness_unlocked = nbt.m_128471_("darkness_unlocked");
            this.water_unlocked = nbt.m_128471_("water_unlocked");
            this.previous_spell_name_2 = nbt.m_128461_("previous_spell_name_2");
            this.previous_spell_name_3 = nbt.m_128461_("previous_spell_name_3");
            this.memory_sigils_number = nbt.m_128459_("memory_sigils_number");
            this.spells_researched = nbt.m_128461_("spells_researched");
            this.SpellNameInScroll = nbt.m_128461_("SpellNameInScroll");
            this.ScrollSpellGestureFirst = nbt.m_128459_("ScrollSpellGestureFirst");
            this.ScrollSpellGestureSecond = nbt.m_128459_("ScrollSpellGestureSecond");
            this.ScrollSpellGestureThird = nbt.m_128459_("ScrollSpellGestureThird");
            this.SpellScrollPage = nbt.m_128459_("SpellScrollPage");
            this.ScrollSpellElement = nbt.m_128459_("ScrollSpellElement");
            this.text_tip_spell_scroll = nbt.m_128461_("text_tip_spell_scroll");
            this.destroying_tag = nbt.m_128461_("destroying_tag");
            this.ritual_name = nbt.m_128461_("ritual_name");
            this.ritual_info = nbt.m_128461_("ritual_info");
            this.ritual_page = nbt.m_128459_("ritual_page");
            this.ritual_block_1 = nbt.m_128461_("ritual_block_1");
            this.ritual_block_2 = nbt.m_128461_("ritual_block_2");
            this.ritual_block_3 = nbt.m_128461_("ritual_block_3");
            this.ritual_block_4 = nbt.m_128461_("ritual_block_4");
            this.ritual_block_5 = nbt.m_128461_("ritual_block_5");
            this.ritual_block_6 = nbt.m_128461_("ritual_block_6");
            this.ritual_block_7 = nbt.m_128461_("ritual_block_7");
            this.ritual_block_8 = nbt.m_128461_("ritual_block_8");
            this.ritual_item_result = nbt.m_128461_("ritual_item_result");
            this.max_ritual_pages = nbt.m_128459_("max_ritual_pages");
            this.researched_rituals = nbt.m_128461_("researched_rituals");
            this.ritual_main_hand = nbt.m_128461_("ritual_main_hand");
            this.ritual_left_hand = nbt.m_128461_("ritual_left_hand");
            this.researched_preparations = nbt.m_128461_("researched_preparations");
            this.max_spell_scroll_pages = nbt.m_128459_("max_spell_scroll_pages");
            this.preparations_tip_spell_scrol = nbt.m_128461_("preparations_tip_spell_scrol");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("hand_magic_renewed", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.first_gesture = original.first_gesture;
            clone.second_gesture = original.second_gesture;
            clone.third_gesture = original.third_gesture;
            clone.show_gestures = original.show_gestures;
            clone.Gesture_Timer = original.Gesture_Timer;
            clone.Wand_Level = original.Wand_Level;
            clone.Wand_Element = original.Wand_Element;
            clone.SpellCooldown = original.SpellCooldown;
            clone.previous_spell_name = original.previous_spell_name;
            clone.show_wand_element = original.show_wand_element;
            clone.cooldownspeed = original.cooldownspeed;
            clone.mana_amethysts_consumed = original.mana_amethysts_consumed;
            clone.mana_amount = original.mana_amount;
            clone.max_mana_amount = original.max_mana_amount;
            clone.mana_overlay_placement = original.mana_overlay_placement;
            clone.show_mana_overlay = original.show_mana_overlay;
            clone.wind_unlocked = original.wind_unlocked;
            clone.fire_unlocked = original.fire_unlocked;
            clone.earth_unlocked = original.earth_unlocked;
            clone.end_unlocked = original.end_unlocked;
            clone.life_unlocked = original.life_unlocked;
            clone.lightning_unlocked = original.lightning_unlocked;
            clone.light_unlocked = original.light_unlocked;
            clone.darkness_unlocked = original.darkness_unlocked;
            clone.water_unlocked = original.water_unlocked;
            clone.previous_spell_name_2 = original.previous_spell_name_2;
            clone.previous_spell_name_3 = original.previous_spell_name_3;
            clone.memory_sigils_number = original.memory_sigils_number;
            clone.spells_researched = original.spells_researched;
            clone.SpellNameInScroll = original.SpellNameInScroll;
            clone.ScrollSpellGestureFirst = original.ScrollSpellGestureFirst;
            clone.ScrollSpellGestureSecond = original.ScrollSpellGestureSecond;
            clone.ScrollSpellGestureThird = original.ScrollSpellGestureThird;
            clone.SpellScrollPage = original.SpellScrollPage;
            clone.ScrollSpellElement = original.ScrollSpellElement;
            clone.text_tip_spell_scroll = original.text_tip_spell_scroll;
            clone.destroying_tag = original.destroying_tag;
            clone.ritual_name = original.ritual_name;
            clone.ritual_info = original.ritual_info;
            clone.ritual_page = original.ritual_page;
            clone.ritual_block_1 = original.ritual_block_1;
            clone.ritual_block_2 = original.ritual_block_2;
            clone.ritual_block_3 = original.ritual_block_3;
            clone.ritual_block_4 = original.ritual_block_4;
            clone.ritual_block_5 = original.ritual_block_5;
            clone.ritual_block_6 = original.ritual_block_6;
            clone.ritual_block_7 = original.ritual_block_7;
            clone.ritual_block_8 = original.ritual_block_8;
            clone.ritual_item_result = original.ritual_item_result;
            clone.max_ritual_pages = original.max_ritual_pages;
            clone.researched_rituals = original.researched_rituals;
            clone.ritual_main_hand = original.ritual_main_hand;
            clone.ritual_left_hand = original.ritual_left_hand;
            clone.researched_preparations = original.researched_preparations;
            clone.max_spell_scroll_pages = original.max_spell_scroll_pages;
            clone.preparations_tip_spell_scrol = original.preparations_tip_spell_scrol;
            if (!event.isWasDeath()) {
                // empty if block
            }
        }
    }
}

