/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.relocate.network;

import net.mcreator.relocate.RelocateMod;
import net.mcreator.relocate.procedures.RedstoneTickerAdd10TicksProcedure;
import net.mcreator.relocate.procedures.RedstoneTickerAdd1TickProcedure;
import net.mcreator.relocate.procedures.RedstoneTickerRemove10TicksProcedure;
import net.mcreator.relocate.procedures.RedstoneTickerRemove1TickProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber
public record RedstoneTickerGUIButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<RedstoneTickerGUIButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"relocate", (String)"redstone_ticker_gui_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, RedstoneTickerGUIButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new RedstoneTickerGUIButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<RedstoneTickerGUIButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(RedstoneTickerGUIButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> RedstoneTickerGUIButtonMessage.handleButtonAction(context.player(), message.buttonID, message.x, message.y, message.z)).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            RedstoneTickerRemove10TicksProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 1) {
            RedstoneTickerAdd10TicksProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 2) {
            RedstoneTickerAdd1TickProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 3) {
            RedstoneTickerRemove1TickProcedure.execute((LevelAccessor)world, x, y, z);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        RelocateMod.addNetworkMessage(TYPE, STREAM_CODEC, RedstoneTickerGUIButtonMessage::handleData);
    }
}

