/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.relocate.init;

import java.util.Map;
import net.mcreator.relocate.RelocateMod;
import net.mcreator.relocate.init.RelocateModScreens;
import net.mcreator.relocate.network.MenuStateUpdateMessage;
import net.mcreator.relocate.world.inventory.BlocksDetectorGUIMenu;
import net.mcreator.relocate.world.inventory.BlocksPlacerGUIMenu;
import net.mcreator.relocate.world.inventory.RedstoneTickerGUIMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class RelocateModMenus {
    public static final DeferredRegister<MenuType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"relocate");
    public static final RegistryObject<MenuType<BlocksPlacerGUIMenu>> BLOCKS_PLACER_GUI = REGISTRY.register("blocks_placer_gui", () -> IForgeMenuType.create(BlocksPlacerGUIMenu::new));
    public static final RegistryObject<MenuType<BlocksDetectorGUIMenu>> BLOCKS_DETECTOR_GUI = REGISTRY.register("blocks_detector_gui", () -> IForgeMenuType.create(BlocksDetectorGUIMenu::new));
    public static final RegistryObject<MenuType<RedstoneTickerGUIMenu>> REDSTONE_TICKER_GUI = REGISTRY.register("redstone_ticker_gui", () -> IForgeMenuType.create(RedstoneTickerGUIMenu::new));

    public static interface MenuAccessor {
        public Map<String, Object> getMenuState();

        public Map<Integer, Slot> getSlots();

        default public void sendMenuStateUpdate(Player player, int elementType, String name, Object elementState, boolean needClientUpdate) {
            this.getMenuState().put(elementType + ":" + name, elementState);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                RelocateMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new MenuStateUpdateMessage(elementType, name, elementState));
            } else if (player.m_9236_().f_46443_) {
                Screen screen = Minecraft.m_91087_().f_91080_;
                if (screen instanceof RelocateModScreens.ScreenAccessor) {
                    RelocateModScreens.ScreenAccessor accessor = (RelocateModScreens.ScreenAccessor)screen;
                    if (needClientUpdate) {
                        accessor.updateMenuState(elementType, name, elementState);
                    }
                }
                RelocateMod.PACKET_HANDLER.sendToServer((Object)new MenuStateUpdateMessage(elementType, name, elementState));
            }
        }

        default public <T> T getMenuState(int elementType, String name, T defaultValue) {
            try {
                return (T)this.getMenuState().getOrDefault(elementType + ":" + name, defaultValue);
            }
            catch (ClassCastException e) {
                return defaultValue;
            }
        }
    }
}

