/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.stirdrem.overgeared.item.ModItems;
import net.stirdrem.overgeared.util.CastingConfigHelper;

public class ModCommands {
    private static final String[] QUALITIES = new String[]{"poor", "well", "expert", "perfect", "master"};

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"setforgingquality").then(Commands.m_82129_((String)"quality", (ArgumentType)StringArgumentType.string()).suggests((c, b) -> {
            for (String q : QUALITIES) {
                b.suggest(q);
            }
            return b.buildFuture();
        }).executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_230896_();
            String quality = StringArgumentType.getString((CommandContext)ctx, (String)"quality").toLowerCase();
            ItemStack inHand = player.m_21205_();
            if (inHand.m_41619_()) {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"You must hold an item"));
                return 0;
            }
            CompoundTag tag = inHand.m_41784_();
            tag.m_128359_("ForgingQuality", quality);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Set ForgingQuality to " + quality)), false);
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"givecast").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"toolType", (ArgumentType)StringArgumentType.string()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"quality", (ArgumentType)StringArgumentType.string()).suggests((c, b) -> {
            b.suggest("none");
            for (String q : QUALITIES) {
                b.suggest(q);
            }
            return b.buildFuture();
        }).then(Commands.m_82129_((String)"material", (ArgumentType)StringArgumentType.string()).suggests((c, b) -> {
            b.suggest("clay");
            b.suggest("nether");
            return b.buildFuture();
        }).executes(ctx -> ModCommands.giveCast((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"toolType"), StringArgumentType.getString((CommandContext)ctx, (String)"quality"), StringArgumentType.getString((CommandContext)ctx, (String)"material"))))).executes(ctx -> ModCommands.giveCast((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"toolType"), StringArgumentType.getString((CommandContext)ctx, (String)"quality"), "clay")))).executes(ctx -> ModCommands.giveCast((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"toolType"), "none", "clay"))));
    }

    private static int giveCast(CommandSourceStack source, String toolType, String quality, String material) {
        ServerPlayer player = source.m_230896_();
        ItemStack stack = material.equalsIgnoreCase("nether") ? new ItemStack((ItemLike)ModItems.NETHER_TOOL_CAST.get()) : new ItemStack((ItemLike)ModItems.CLAY_TOOL_CAST.get());
        CompoundTag tag = stack.m_41784_();
        tag.m_128359_("ToolType", toolType.toLowerCase());
        tag.m_128405_("Amount", 0);
        tag.m_128405_("MaxAmount", CastingConfigHelper.getMaxMaterialAmount(toolType));
        tag.m_128365_("Materials", (Tag)new CompoundTag());
        if (!quality.equalsIgnoreCase("none")) {
            tag.m_128359_("Quality", quality.toLowerCase());
        }
        player.m_36356_(stack);
        source.m_288197_(() -> Component.m_237113_((String)("Gave cast: " + toolType + (String)(quality.equals("none") ? "" : " (" + quality + ")") + " [" + material + "]")), false);
        return 1;
    }
}

