/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.loot;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.LootModifier;
import net.stirdrem.overgeared.ForgingQuality;
import net.stirdrem.overgeared.config.ServerConfig;
import org.jetbrains.annotations.NotNull;

public class QualityLootModifier
extends LootModifier {
    public static final Codec<QualityLootModifier> CODEC = RecordCodecBuilder.create(inst -> QualityLootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, QualityLootModifier::new));

    public QualityLootModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (!((Boolean)ServerConfig.ENABLE_LOOT_QUALITY.get()).booleanValue()) {
            return generatedLoot;
        }
        int wPoor = (Integer)ServerConfig.QUALITY_WEIGHT_POOR.get();
        int wWell = (Integer)ServerConfig.QUALITY_WEIGHT_WELL.get();
        int wExpert = (Integer)ServerConfig.QUALITY_WEIGHT_EXPERT.get();
        int wPerfect = (Integer)ServerConfig.QUALITY_WEIGHT_PERFECT.get();
        int wMaster = (Integer)ServerConfig.QUALITY_WEIGHT_MASTER.get();
        int total = 0;
        if (wPoor > 0) {
            total += wPoor;
        }
        if (wWell > 0) {
            total += wWell;
        }
        if (wExpert > 0) {
            total += wExpert;
        }
        if (wPerfect > 0) {
            total += wPerfect;
        }
        if (wMaster > 0) {
            total += wMaster;
        }
        if (total == 0) {
            for (ItemStack stack : generatedLoot) {
                if (!QualityLootModifier.isEligibleItem(stack)) continue;
                stack.m_41784_().m_128359_("ForgingQuality", ForgingQuality.POOR.getDisplayName());
            }
            return generatedLoot;
        }
        for (ItemStack stack : generatedLoot) {
            if (!QualityLootModifier.isEligibleItem(stack)) continue;
            int r = context.m_230907_().m_188503_(total);
            int accum = 0;
            ForgingQuality chosen = r < (accum += wPoor) ? ForgingQuality.POOR : (r < (accum += wWell) ? ForgingQuality.WELL : (r < (accum += wExpert) ? ForgingQuality.EXPERT : (r < (accum += wPerfect) ? ForgingQuality.PERFECT : ForgingQuality.MASTER)));
            stack.m_41784_().m_128359_("ForgingQuality", chosen.getDisplayName());
        }
        return generatedLoot;
    }

    private static boolean isEligibleItem(ItemStack stack) {
        TieredItem tiered;
        Item item = stack.m_41720_();
        if (!(item instanceof TieredItem) && !(item instanceof ArmorItem)) {
            return false;
        }
        return !(item instanceof TieredItem) || (tiered = (TieredItem)item).m_43314_() != Tiers.WOOD;
    }

    public Codec<? extends LootModifier> codec() {
        return CODEC;
    }
}

