/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.networking.packet;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import net.stirdrem.overgeared.block.entity.AbstractSmithingAnvilBlockEntity;
import net.stirdrem.overgeared.event.AnvilMinigameEvents;
import net.stirdrem.overgeared.event.ModItemInteractEvents;
import net.stirdrem.overgeared.networking.ModMessages;
import net.stirdrem.overgeared.networking.packet.MinigameSetStartedS2CPacket;

public class MinigameSetStartedC2SPacket {
    private final BlockPos pos;

    public MinigameSetStartedC2SPacket(BlockPos pos) {
        this.pos = pos;
    }

    public static void encode(MinigameSetStartedC2SPacket pkt, FriendlyByteBuf buf) {
        buf.m_130064_(pkt.pos);
    }

    public static MinigameSetStartedC2SPacket decode(FriendlyByteBuf buf) {
        return new MinigameSetStartedC2SPacket(buf.m_130135_());
    }

    public static void handle(MinigameSetStartedC2SPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            BlockEntity be;
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            if (sender != null && (be = sender.m_9236_().m_7702_(msg.pos)) instanceof AbstractSmithingAnvilBlockEntity) {
                AbstractSmithingAnvilBlockEntity anvilEntity = (AbstractSmithingAnvilBlockEntity)be;
                AnvilMinigameEvents.setMinigameStarted(msg.pos, true);
                ModMessages.sendToPlayer(new MinigameSetStartedS2CPacket(msg.pos), sender);
                ModItemInteractEvents.playerAnvilPositions.put(sender.m_20148_(), msg.pos);
                ModItemInteractEvents.playerMinigameVisibility.put(sender.m_20148_(), true);
                anvilEntity.setPlayer((Player)sender);
                anvilEntity.setMinigameOn(true);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

