/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.screen;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.stirdrem.overgeared.config.ServerConfig;
import net.stirdrem.overgeared.item.ModItems;
import net.stirdrem.overgeared.recipe.FletchingRecipe;
import net.stirdrem.overgeared.recipe.ModRecipeTypes;
import net.stirdrem.overgeared.screen.ModMenuTypes;

public class FletchingStationMenu
extends AbstractContainerMenu {
    private static final int INPUT_SLOT_TIP = 0;
    private static final int INPUT_SLOT_SHAFT = 1;
    private static final int INPUT_SLOT_FEATHER = 2;
    private static final int INPUT_SLOT_POTION = 3;
    private static final int OUTPUT_SLOT = 4;
    private static final int PLAYER_INVENTORY_START = 5;
    private static final int PLAYER_INVENTORY_END = 32;
    private static final int PLAYER_HOTBAR_START = 33;
    private static final int PLAYER_HOTBAR_END = 40;
    private final Level level;
    private final ContainerLevelAccess access;
    private final Container input;
    private final ResultContainer result = new ResultContainer();
    private final RecipeManager recipeManager;
    private final Player player;

    public FletchingStationMenu(int id, Inventory playerInv) {
        this(id, playerInv, ContainerLevelAccess.f_39287_);
    }

    public FletchingStationMenu(int id, Inventory playerInv, ContainerLevelAccess access) {
        super((MenuType)ModMenuTypes.FLETCHING_STATION_MENU.get(), id);
        this.access = access;
        this.recipeManager = playerInv.f_35978_.m_9236_().m_7465_();
        this.player = playerInv.f_35978_;
        this.level = playerInv.f_35978_.m_9236_();
        this.input = new SimpleContainer(4){

            public void m_6836_(int i, ItemStack stack) {
                super.m_6836_(i, stack);
                FletchingStationMenu.this.m_6199_((Container)this);
            }

            public void m_6596_() {
                super.m_6596_();
                FletchingStationMenu.this.m_6199_((Container)this);
            }
        };
        this.m_38897_(new Slot(this.input, 0, 66, 17){

            public void m_142406_(Player pPlayer, ItemStack pStack) {
                FletchingStationMenu.this.updateResultSlot();
                super.m_142406_(pPlayer, pStack);
            }

            public boolean m_8010_(Player player) {
                return true;
            }
        });
        this.m_38897_(new Slot(this.input, 1, 48, 35){

            public void m_142406_(Player pPlayer, ItemStack pStack) {
                FletchingStationMenu.this.updateResultSlot();
                super.m_142406_(pPlayer, pStack);
            }

            public boolean m_8010_(Player player) {
                return true;
            }
        });
        this.m_38897_(new Slot(this.input, 2, 30, 53){

            public void m_142406_(Player pPlayer, ItemStack pStack) {
                FletchingStationMenu.this.updateResultSlot();
                super.m_142406_(pPlayer, pStack);
            }

            public boolean m_8010_(Player player) {
                return true;
            }
        });
        this.m_38897_(new Slot(this.input, 3, 92, 53){

            public boolean m_5857_(ItemStack stack) {
                return FletchingStationMenu.this.isPotion(stack);
            }

            public boolean m_8010_(Player player) {
                return true;
            }

            public int m_6641_() {
                return 1;
            }

            public int m_5866_(ItemStack stack) {
                return 1;
            }
        });
        this.m_38897_(new Slot((Container)this.result, 4, 124, 35){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }

            public boolean m_8010_(Player player) {
                return true;
            }

            public void m_142406_(Player player, ItemStack stack) {
                FletchingStationMenu.this.consumeInputs(stack);
                super.m_142406_(player, stack);
            }
        });
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInv, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInv, col, 8 + col * 18, 142));
        }
    }

    private boolean isPotion(ItemStack stack) {
        return stack.m_150930_(Items.f_42589_) || stack.m_150930_(Items.f_42736_) || stack.m_150930_(Items.f_42739_);
    }

    public boolean m_6875_(Player player) {
        return FletchingStationMenu.m_38889_((ContainerLevelAccess)this.access, (Player)player, (Block)Blocks.f_50622_);
    }

    public void m_6199_(Container container) {
        this.updateResultSlot();
        super.m_6199_(container);
    }

    private boolean isUpgradeableArrow(ItemStack stack) {
        return stack.m_150930_((Item)ModItems.IRON_UPGRADE_ARROW.get()) || stack.m_150930_((Item)ModItems.STEEL_UPGRADE_ARROW.get()) || stack.m_150930_((Item)ModItems.DIAMOND_UPGRADE_ARROW.get());
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateResultSlot() {
        ItemStack resultStack;
        block25: {
            ItemStack baseResult;
            int craftCount;
            block24: {
                block26: {
                    if (this.level.m_5776_()) {
                        return;
                    }
                    boolean hasInput = false;
                    for (int i = 0; i < 3; ++i) {
                        if (this.input.m_8020_(i).m_41619_()) continue;
                        hasInput = true;
                        break;
                    }
                    if (!hasInput) {
                        this.result.m_6836_(4, ItemStack.f_41583_);
                        this.m_38946_();
                        return;
                    }
                    Optional opt = this.recipeManager.m_44015_((RecipeType)ModRecipeTypes.FLETCHING.get(), this.input, this.level);
                    resultStack = ItemStack.f_41583_;
                    ItemStack potion = this.input.m_8020_(3);
                    boolean allowUpgradeableArrowConversion = (Boolean)ServerConfig.UPGRADE_ARROW_POTION_TOGGLE.get();
                    if (!potion.m_41619_()) {
                        int arrowSlots = 0;
                        int arrowCount = 0;
                        int slotNumber = -1;
                        for (int i = 0; i < 3; ++i) {
                            ItemStack slotStack = this.input.m_8020_(i);
                            if (!slotStack.m_150930_(Items.f_42412_) && (!allowUpgradeableArrowConversion || !this.isUpgradeableArrow(slotStack))) continue;
                            ++arrowSlots;
                            arrowCount = slotStack.m_41613_();
                            slotNumber = i;
                        }
                        if (arrowSlots == 1) {
                            ItemStack arrowStack = this.input.m_8020_(slotNumber);
                            boolean isUpgradeable = this.isUpgradeableArrow(arrowStack);
                            if (isUpgradeable && !allowUpgradeableArrowConversion) {
                                this.result.m_6836_(4, ItemStack.f_41583_);
                                this.m_38946_();
                                return;
                            }
                            if (potion.m_150930_(Items.f_42589_)) {
                                ItemStack tippedArrows = this.isUpgradeableArrow(this.input.m_8020_(slotNumber)) ? this.input.m_8020_(slotNumber).m_41777_() : new ItemStack((ItemLike)Items.f_42738_, arrowCount);
                                PotionUtils.m_43549_((ItemStack)tippedArrows, (Potion)PotionUtils.m_43579_((ItemStack)potion));
                                if (potion.m_41782_()) {
                                    tippedArrows.m_41751_(potion.m_41783_().m_6426_());
                                }
                                resultStack = tippedArrows;
                            } else if (potion.m_150930_(Items.f_42739_)) {
                                ItemStack lingeringArrows = this.isUpgradeableArrow(this.input.m_8020_(slotNumber)) ? this.input.m_8020_(slotNumber).m_41777_() : new ItemStack((ItemLike)ModItems.LINGERING_ARROW.get(), arrowCount);
                                PotionUtils.m_43549_((ItemStack)lingeringArrows, (Potion)PotionUtils.m_43579_((ItemStack)potion));
                                if (potion.m_41782_()) {
                                    lingeringArrows.m_41751_(potion.m_41783_().m_6426_());
                                }
                                if (this.isUpgradeableArrow(this.input.m_8020_(slotNumber))) {
                                    lingeringArrows.m_41784_().m_128379_("LingeringPotion", true);
                                }
                                resultStack = lingeringArrows;
                            }
                        }
                    }
                    if (!opt.isPresent()) break block25;
                    FletchingRecipe recipe = (FletchingRecipe)opt.get();
                    int tipCount = this.input.m_8020_(0).m_41613_();
                    int shaftCount = this.input.m_8020_(1).m_41613_();
                    int featherCount = this.input.m_8020_(2).m_41613_();
                    craftCount = Math.max(Math.min(Math.min(tipCount, shaftCount), featherCount), 1);
                    baseResult = recipe.m_5874_(this.input, this.level.m_9598_());
                    if (potion.m_41619_()) break block26;
                    boolean isUpgradeable = this.isUpgradeableArrow(baseResult);
                    if (isUpgradeable && !allowUpgradeableArrowConversion) {
                        this.result.m_6836_(4, ItemStack.f_41583_);
                        this.m_38946_();
                        return;
                    }
                    String potionEffect = PotionUtils.m_43579_((ItemStack)potion).m_43492_("");
                    if ((potion.m_150930_(Items.f_42589_) || potion.m_150930_(Items.f_42736_)) && !recipe.getTippedResult().m_41619_()) {
                        resultStack = recipe.getTippedResult().m_41777_();
                        resultTag = resultStack.m_41784_();
                        if (potion.m_41782_()) {
                            resultTag.m_128391_(potion.m_41783_().m_6426_());
                        }
                        resultStack.m_41751_(potion.m_41783_().m_6426_());
                        break block24;
                    } else if (potion.m_150930_(Items.f_42739_) && !recipe.getLingeringResult().m_41619_()) {
                        resultStack = recipe.getLingeringResult().m_41777_();
                        resultTag = resultStack.m_41784_();
                        if (this.isUpgradeableArrow(resultStack)) {
                            resultTag.m_128379_("LingeringPotion", true);
                        } else if (recipe.getLingeringTag() != null) {
                            resultTag.m_128359_(recipe.getLingeringTag(), potionEffect);
                        }
                        if (potion.m_41782_()) {
                            resultTag.m_128391_(potion.m_41783_().m_6426_());
                        }
                        resultStack.m_41751_(resultTag);
                        break block24;
                    } else {
                        this.result.m_6836_(4, ItemStack.f_41583_);
                        this.m_38946_();
                        return;
                    }
                }
                resultStack = baseResult.m_41777_();
            }
            if (!resultStack.m_41619_()) {
                int outPer = baseResult.m_41613_();
                int maxStack = resultStack.m_41741_();
                int maxCraftCount = Math.min(maxStack / outPer, craftCount);
                resultStack.m_41764_(outPer * maxCraftCount);
            }
        }
        this.result.m_6836_(4, resultStack);
        this.m_38946_();
    }

    private void consumeInputs(ItemStack result) {
        ItemStack potionStack;
        if (result.m_41619_()) {
            return;
        }
        Optional opt = this.recipeManager.m_44015_((RecipeType)ModRecipeTypes.FLETCHING.get(), this.input, this.level);
        if (opt.isPresent()) {
            FletchingRecipe recipe = (FletchingRecipe)opt.get();
            ItemStack baseResult = recipe.m_5874_(this.input, this.level.m_9598_());
            int baseCount = baseResult.m_41613_();
            int tookCount = result.m_41613_();
            int batchesTaken = Math.max(1, tookCount / baseCount);
            for (int i = 0; i < 3; ++i) {
                ItemStack stack = this.input.m_8020_(i);
                if (stack.m_41619_()) continue;
                stack.m_41774_(batchesTaken);
                this.input.m_6836_(i, stack.m_41619_() ? ItemStack.f_41583_ : stack);
            }
        } else {
            int tookCount = result.m_41613_();
            for (int i = 0; i < 3; ++i) {
                ItemStack stack = this.input.m_8020_(i);
                if (stack.m_41619_()) continue;
                stack.m_41774_(tookCount);
                this.input.m_6836_(i, stack.m_41619_() ? ItemStack.f_41583_ : stack);
            }
        }
        if (!(potionStack = this.input.m_8020_(3)).m_41619_()) {
            potionStack.m_41774_(1);
            this.input.m_6836_(3, potionStack.m_41619_() ? new ItemStack((ItemLike)Items.f_42590_) : potionStack);
        }
        this.updateResultSlot();
    }

    private ItemStack applyPotionEffects(ItemStack result, ItemStack potion) {
        if (result.m_150930_(Items.f_42412_)) {
            ItemStack tippedArrow = new ItemStack((ItemLike)Items.f_42738_, result.m_41613_());
            PotionUtils.m_43549_((ItemStack)tippedArrow, (Potion)PotionUtils.m_43579_((ItemStack)potion));
            tippedArrow.m_41751_(potion.m_41783_());
            return tippedArrow;
        }
        if (result.m_150930_((Item)ModItems.LINGERING_ARROW.get())) {
            PotionUtils.m_43549_((ItemStack)result, (Potion)PotionUtils.m_43579_((ItemStack)potion));
            result.m_41751_(potion.m_41783_());
            return result;
        }
        return result;
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack copiedStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            copiedStack = slotStack.m_41777_();
            if (index == 4) {
                while (this.canStillCraft()) {
                    ItemStack result = slot.m_7993_().m_41777_();
                    int maxTransfer = result.m_41741_();
                    int craftCount = Math.min(result.m_41613_(), maxTransfer);
                    result.m_41764_(craftCount);
                    if (!this.m_38903_(result, 5, 41, true)) break;
                    slot.m_40234_(result, copiedStack);
                    this.consumeInputs(copiedStack);
                    if (!slot.m_7993_().m_41619_()) continue;
                    break;
                }
                slot.m_6654_();
            } else if (index >= 5 && index <= 40 ? (this.isPotion(slotStack) ? !this.m_38903_(slotStack, 3, 4, false) : !this.m_38903_(slotStack, 0, 3, false)) : index >= 0 && index <= 3 && !this.m_38903_(slotStack, 5, 41, false)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotStack.m_41613_() == copiedStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, slotStack);
        }
        return copiedStack;
    }

    private boolean canStillCraft() {
        Optional opt = this.recipeManager.m_44015_((RecipeType)ModRecipeTypes.FLETCHING.get(), this.input, this.level);
        return opt.isPresent();
    }

    private boolean simulateInsertIntoPlayerInventory(ItemStack stack) {
        for (int i = 5; i <= 40; ++i) {
            Slot slot = (Slot)this.f_38839_.get(i);
            ItemStack existing = slot.m_7993_();
            if (existing.m_41619_()) {
                return true;
            }
            if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)existing) || existing.m_41613_() >= existing.m_41741_()) continue;
            return true;
        }
        return false;
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        if (this.access != ContainerLevelAccess.f_39287_) {
            for (int i = 0; i < this.input.m_6643_(); ++i) {
                ItemStack stack = this.input.m_8016_(i);
                if (stack.m_41619_() || player.m_150109_().m_36054_(stack)) continue;
                player.m_36176_(stack, false);
            }
        }
    }

    public static Potion getPotion(@Nullable CompoundTag tag) {
        if (tag == null) {
            return Potions.f_43598_;
        }
        if (tag.m_128425_("Potion", 8)) {
            return Potion.m_43489_((String)tag.m_128461_("Potion"));
        }
        return Potions.f_43598_;
    }

    public static List<MobEffectInstance> getAllEffects(@Nullable CompoundTag pCompoundTag) {
        ArrayList list = Lists.newArrayList();
        list.addAll(FletchingStationMenu.getPotion(pCompoundTag).m_43488_());
        FletchingStationMenu.getCustomEffects(pCompoundTag, list);
        return list;
    }

    public static void getCustomEffects(@Nullable CompoundTag pCompoundTag, List<MobEffectInstance> pEffectList) {
        if (pCompoundTag != null && pCompoundTag.m_128425_("CustomPotionEffects", 9)) {
            ListTag listtag = pCompoundTag.m_128437_("CustomPotionEffects", 10);
            for (int i = 0; i < listtag.size(); ++i) {
                CompoundTag compoundtag = listtag.m_128728_(i);
                MobEffectInstance mobeffectinstance = MobEffectInstance.m_19560_((CompoundTag)compoundtag);
                if (mobeffectinstance == null) continue;
                pEffectList.add(mobeffectinstance);
            }
        }
    }
}

