/*
 * Decompiled with CFR 0.152.
 */
package com.sopze.mc.ironrust;

import com.sopze.mc.ironrust.Constants;
import com.sopze.mc.ironrust.Logger;
import com.sopze.mc.ironrust.Main;
import com.sopze.mc.ironrust.Network;
import com.sopze.mc.ironrust.block.ModBlocks;
import com.sopze.mc.ironrust.item.ModItems;
import com.sopze.mc.ironrust.wrapper.I_LoaderWrapper;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

@Mod(value="ironrust")
public class IronRust
implements I_LoaderWrapper {
    public IronRust(IEventBus bus) {
        Main.initialize(this);
        bus.addListener(IronRust::register);
        bus.addListener(IronRust::onCommonSetup);
        NeoForge.EVENT_BUS.addListener(IronRust::onUserConnected);
        ModBlocks.initialize();
        ModItems.initialize(bus);
    }

    @SubscribeEvent
    public static void onCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(ModItems::initializeAfter);
    }

    @SubscribeEvent
    public static void register(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1");
        registrar.playBidirectional(Network.GreetPayload.PAYLOAD_ID, Network.GreetPayload.CODEC, (a, b) -> {});
    }

    @SubscribeEvent
    public static void onUserConnected(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (player2.level().isClientSide()) {
            return;
        }
        Logger.slog(Constants.CHECKING_CLIENT_MOD, player2.getName().getString());
        player2.connection.send((CustomPacketPayload)new Network.GreetPayload(Main.getLocalVersion()));
    }

    @Override
    public boolean isModLoaded(String modid) {
        return ModList.get().isLoaded(modid);
    }

    @Override
    public String computeVersionString() {
        return ModList.get().getModContainerById(Constants.MOD_ID).map(mod -> mod.getModInfo().getVersion().toString()).orElse("0.0.0X-MissingVersion");
    }
}

