/*
 * Decompiled with CFR 0.152.
 */
package com.sopze.mc.ironrust;

import com.sopze.mc.ironrust.Constants;
import com.sopze.mc.ironrust.Logger;
import com.sopze.mc.ironrust.Main;
import com.sopze.mc.ironrust.Network;
import com.sopze.mc.ironrust.Util;
import com.sopze.mc.ironrust.item.ModItems;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.network.event.RegisterClientPayloadHandlersEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@Mod(value="ironrust", dist={Dist.CLIENT})
public class IronRustClient {
    private static boolean _SERVER_HAS_MOD = false;
    private static byte[] _SERVER_VERSION;

    public IronRustClient(IEventBus bus) {
        bus.addListener(IronRustClient::onBuildCreativeTabContents);
        bus.addListener(IronRustClient::onRegisterPayloadHandlers);
        NeoForge.EVENT_BUS.addListener(IronRustClient::onUserConnected);
        NeoForge.EVENT_BUS.addListener(IronRustClient::onUserDisconnected);
    }

    @SubscribeEvent
    public static void onBuildCreativeTabContents(BuildCreativeModeTabContentsEvent event) {
        ModItems.onBuildCreativeTabContents(event);
    }

    @SubscribeEvent
    public static void onRegisterPayloadHandlers(RegisterClientPayloadHandlersEvent event) {
        event.register(Network.GreetPayload.PAYLOAD_ID, IronRustClient::_onReceivedGreetPayload_Client);
    }

    @SubscribeEvent
    public static void onUserConnected(PlayerEvent.PlayerLoggedInEvent event) {
        byte[] byArray;
        boolean local;
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        _SERVER_HAS_MOD = local = player2.level().isClientSide();
        if (local) {
            byArray = Main.getLocalVersion();
        } else {
            byte[] byArray2 = new byte[3];
            byArray2[0] = 0;
            byArray2[1] = 0;
            byArray = byArray2;
            byArray2[2] = 0;
        }
        _SERVER_VERSION = byArray;
        Main.setEnabledLocally(local);
    }

    @SubscribeEvent
    public static void onUserDisconnected(PlayerEvent.PlayerLoggedOutEvent event) {
        _SERVER_HAS_MOD = false;
        _SERVER_VERSION = new byte[]{0, 0, 0};
    }

    public static void _onReceivedGreetPayload_Client(Network.GreetPayload payload, IPayloadContext context) {
        _SERVER_HAS_MOD = true;
        _SERVER_VERSION = payload.read();
        byte[] localVersion = Main.getLocalVersion();
        boolean valid = Util.isCompatibleVersion(_SERVER_VERSION);
        Main.setEnabledLocally(valid);
        Logger.slog(Constants.VERSION_CHECK_INFO, String.format("%d.%d.%d%s", _SERVER_VERSION[0], _SERVER_VERSION[1], _SERVER_VERSION[2], Character.valueOf("FBAX".charAt(_SERVER_VERSION[3]))), String.format("%d.%d.%d%s", localVersion[0], localVersion[1], localVersion[2], Character.valueOf("FBAX".charAt(localVersion[3]))));
        Logger.slog(Constants.VERSION_CHECK_MESSAGE, valid ? Constants.VERSION_CHECK_SUCCEED : Constants.VERSION_CHECK_FAIL);
    }

    public static boolean getServerHasMod() {
        return _SERVER_HAS_MOD;
    }

    public static byte[] getServerVersion() {
        return _SERVER_VERSION;
    }
}

