/*
 * Decompiled with CFR 0.152.
 */
package com.sopze.mc.ironrust.block;

import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.mojang.serialization.Codec;
import com.sopze.mc.ironrust.block.ModBlocks;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChangeOverTimeBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.WaterFluid;

public interface I_Rustable
extends ChangeOverTimeBlock<RustLevel> {
    public static final Supplier<BiMap<Block, Block>> RUST_LEVEL_INCREASES = Suppliers.memoize(() -> ImmutableBiMap.builder().put((Object)Blocks.IRON_BLOCK, (Object)ModBlocks.EXPOSED_IRON).put((Object)ModBlocks.EXPOSED_IRON, (Object)ModBlocks.WEATHERED_IRON).put((Object)ModBlocks.WEATHERED_IRON, (Object)ModBlocks.OXIDIZED_IRON).put((Object)Blocks.IRON_DOOR, (Object)ModBlocks.EXPOSED_IRON_DOOR).put((Object)ModBlocks.EXPOSED_IRON_DOOR, (Object)ModBlocks.WEATHERED_IRON_DOOR).put((Object)ModBlocks.WEATHERED_IRON_DOOR, (Object)ModBlocks.OXIDIZED_IRON_DOOR).put((Object)Blocks.IRON_TRAPDOOR, (Object)ModBlocks.EXPOSED_IRON_TRAPDOOR).put((Object)ModBlocks.EXPOSED_IRON_TRAPDOOR, (Object)ModBlocks.WEATHERED_IRON_TRAPDOOR).put((Object)ModBlocks.WEATHERED_IRON_TRAPDOOR, (Object)ModBlocks.OXIDIZED_IRON_TRAPDOOR).put((Object)Blocks.IRON_BARS, (Object)ModBlocks.EXPOSED_IRON_BARS).put((Object)ModBlocks.EXPOSED_IRON_BARS, (Object)ModBlocks.WEATHERED_IRON_BARS).put((Object)ModBlocks.WEATHERED_IRON_BARS, (Object)ModBlocks.OXIDIZED_IRON_BARS).put((Object)ModBlocks.IRON_GRATE, (Object)ModBlocks.EXPOSED_IRON_GRATE).put((Object)ModBlocks.EXPOSED_IRON_GRATE, (Object)ModBlocks.WEATHERED_IRON_GRATE).put((Object)ModBlocks.WEATHERED_IRON_GRATE, (Object)ModBlocks.OXIDIZED_IRON_GRATE).put((Object)Blocks.IRON_CHAIN, (Object)ModBlocks.EXPOSED_IRON_CHAIN).put((Object)ModBlocks.EXPOSED_IRON_CHAIN, (Object)ModBlocks.WEATHERED_IRON_CHAIN).put((Object)ModBlocks.WEATHERED_IRON_CHAIN, (Object)ModBlocks.OXIDIZED_IRON_CHAIN).build());
    public static final Supplier<BiMap<Block, Block>> RUST_LEVEL_DECREASES = Suppliers.memoize(() -> RUST_LEVEL_INCREASES.get().inverse());
    public static final float[] CHANCE_MULTIPLIER_BY_DEGRADATION = new float[]{0.85f, 1.0f, 1.02f, 1.06f};
    public static final float[] CHANCE_ADDER_BY_WATER_DISTANCE = new float[]{0.17f, 0.09f, 0.04f, 0.0f};
    public static final float[] CHANCE_ADDER_BY_WATER_AMOUNT = new float[]{0.0f, 0.015f, 0.04f, 0.075f, 0.13f, 0.19f, 0.265f, 0.325f, 0.365f, 0.385f, 0.4f};

    default public void changeOverTime(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        float[] baseChances = this.getChanceModifierWorld(state, world, pos);
        float passChance = 0.04988889f + baseChances[0] * 0.013774f;
        if (random.nextFloat() < passChance) {
            this.getNextState(state, world, pos, random, baseChances[1]).ifPresent(degraded -> world.setBlockAndUpdate(pos, degraded));
        }
    }

    default public Optional<BlockState> getNextState(BlockState state, ServerLevel world, BlockPos pos, RandomSource random, float waterFactor) {
        int levelCurrent = ((RustLevel)this.getAge()).ordinal();
        int surroundingEquals = 0;
        int surroundingHighers = 0;
        for (BlockPos blockPos : BlockPos.withinManhattan((BlockPos)pos, (int)4, (int)4, (int)4)) {
            Block blockTest;
            if (blockPos.equals((Object)pos) || blockPos.distManhattan((Vec3i)pos) > 4 || !((blockTest = world.getBlockState(blockPos).getBlock()) instanceof ChangeOverTimeBlock)) continue;
            ChangeOverTimeBlock degradable = (ChangeOverTimeBlock)blockTest;
            Enum degradationLevelTest = degradable.getAge();
            if (((Object)((Object)((RustLevel)this.getAge()))).getClass() != degradationLevelTest.getClass()) continue;
            int levelCurrentTest = degradationLevelTest.ordinal();
            if (levelCurrentTest == levelCurrent) {
                ++surroundingEquals;
                continue;
            }
            if (levelCurrentTest <= levelCurrent) continue;
            ++surroundingHighers;
        }
        float ratio = (float)(surroundingHighers + 1) / (float)(surroundingHighers + surroundingEquals + 1) + waterFactor;
        float finalFactor = ratio * ratio * (this.getChanceModifier() + waterFactor);
        return random.nextFloat() < finalFactor ? this.getNext(state) : Optional.empty();
    }

    public static Optional<Block> getDecreasedRustBlock(Block block) {
        return Optional.ofNullable((Block)RUST_LEVEL_DECREASES.get().get((Object)block));
    }

    public static Block getUnaffectedRustBlock(Block block) {
        Block block2 = block;
        Block block3 = (Block)RUST_LEVEL_DECREASES.get().get((Object)block);
        while (block3 != null) {
            block2 = block3;
            block3 = (Block)RUST_LEVEL_DECREASES.get().get((Object)block3);
        }
        return block2;
    }

    public static Optional<BlockState> getPrevious(BlockState state) {
        return I_Rustable.getDecreasedRustBlock(state.getBlock()).map(block -> block.withPropertiesOf(state));
    }

    public static Optional<Block> getNext(Block block) {
        return Optional.ofNullable((Block)RUST_LEVEL_INCREASES.get().get((Object)block));
    }

    public static BlockState getFirst(BlockState state) {
        return I_Rustable.getUnaffectedRustBlock(state.getBlock()).withPropertiesOf(state);
    }

    default public Optional<BlockState> getNext(BlockState state) {
        return I_Rustable.getNext(state.getBlock()).map(block -> block.withPropertiesOf(state));
    }

    default public float getChanceModifier() {
        return CHANCE_MULTIPLIER_BY_DEGRADATION[((RustLevel)this.getAge()).ordinal()];
    }

    default public float[] getChanceModifierWorld(BlockState state, ServerLevel world, BlockPos pos) {
        int areaX = 6;
        int areaY = 3;
        int waterNeighborCountMax = CHANCE_ADDER_BY_WATER_AMOUNT.length - 1;
        float waterNeighborFactor = 0.0f;
        int waterNeighborsCount = 0;
        int waterClosestDistance = 8;
        BlockPos lookupPos = pos.below();
        for (BlockPos blockPos : BlockPos.withinManhattan((BlockPos)lookupPos, (int)6, (int)3, (int)6)) {
            FluidState checkFluidState;
            BlockState checkBlockState;
            int distance;
            if (blockPos.equals((Object)pos) || (distance = blockPos.distManhattan((Vec3i)lookupPos)) > 6 || !((checkBlockState = world.getBlockState(blockPos)).getBlock() instanceof LiquidBlock) || !((checkFluidState = checkBlockState.getFluidState()).getType() instanceof WaterFluid)) continue;
            if (distance < waterClosestDistance) {
                waterClosestDistance = distance;
            }
            waterNeighborFactor += 0.125f * checkFluidState.getOwnHeight();
            if (++waterNeighborsCount != waterNeighborCountMax) continue;
            break;
        }
        int waterFactor = Math.clamp((long)(waterClosestDistance / 2 - 1), 0, 3);
        float amountFactor = 1.0f + CHANCE_ADDER_BY_WATER_AMOUNT[Math.clamp((long)((int)Math.floor(waterNeighborFactor)), 0, waterNeighborCountMax)];
        return new float[]{(float)waterFactor * amountFactor, CHANCE_ADDER_BY_WATER_DISTANCE[waterFactor] * amountFactor};
    }

    public static enum RustLevel implements StringRepresentable
    {
        UNAFFECTED("unaffected"),
        EXPOSED("exposed"),
        WEATHERED("weathered"),
        OXIDIZED("oxidized");

        public static final IntFunction<RustLevel> indexMapper;
        public static final Codec<RustLevel> CODEC;
        public static final StreamCodec<ByteBuf, RustLevel> PACKET_CODEC;
        private final String id;

        private RustLevel(String id) {
            this.id = id;
        }

        public String getSerializedName() {
            return this.id;
        }

        public RustLevel next() {
            return indexMapper.apply(this.ordinal() + 1);
        }

        public RustLevel previous() {
            return indexMapper.apply(this.ordinal() - 1);
        }

        static {
            indexMapper = ByIdMap.continuous(Enum::ordinal, (Object[])RustLevel.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.CLAMP);
            CODEC = StringRepresentable.fromEnum(RustLevel::values);
            PACKET_CODEC = ByteBufCodecs.idMapper(indexMapper, Enum::ordinal);
        }
    }
}

