/*
 * Decompiled with CFR 0.152.
 */
package com.sopze.mc.ironrust.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.sopze.mc.ironrust.block.I_Rustable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;

public class RustableDoorBlock
extends DoorBlock
implements I_Rustable {
    public static final MapCodec<RustableDoorBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockSetType.CODEC.fieldOf("block_set_type").forGetter(DoorBlock::type), (App)I_Rustable.RustLevel.CODEC.fieldOf("weathering_state").forGetter(RustableDoorBlock::getAge), (App)RustableDoorBlock.propertiesCodec()).apply((Applicative)instance, RustableDoorBlock::new));
    private final I_Rustable.RustLevel rustLevel;

    public MapCodec<RustableDoorBlock> getCodec() {
        return CODEC;
    }

    public RustableDoorBlock(BlockSetType type, I_Rustable.RustLevel rustLevel, BlockBehaviour.Properties settings) {
        super(type, settings);
        this.rustLevel = rustLevel;
    }

    protected void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (state.getValue((Property)DoorBlock.HALF) == DoubleBlockHalf.LOWER) {
            this.changeOverTime(state, world, pos, random);
        }
    }

    protected boolean isRandomlyTicking(BlockState state) {
        return I_Rustable.getNext(state.getBlock()).isPresent();
    }

    public I_Rustable.RustLevel getAge() {
        return this.rustLevel;
    }
}

