/*
 * Decompiled with CFR 0.152.
 */
package com.sopze.mc.ironrust.item;

import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.sopze.mc.ironrust.block.ModBlocks;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;

public class ActiveHoneycombItem
extends Item {
    public static final Supplier<BiMap<Block, Block>> UNCOATED_TO_COATED_BLOCKS = Suppliers.memoize(() -> ImmutableBiMap.builder().put((Object)Blocks.IRON_BLOCK, (Object)ModBlocks.COATED_IRON_BLOCK).put((Object)ModBlocks.EXPOSED_IRON, (Object)ModBlocks.COATED_EXPOSED_IRON).put((Object)ModBlocks.WEATHERED_IRON, (Object)ModBlocks.COATED_WEATHERED_IRON).put((Object)Blocks.IRON_DOOR, (Object)ModBlocks.COATED_IRON_DOOR).put((Object)ModBlocks.EXPOSED_IRON_DOOR, (Object)ModBlocks.COATED_EXPOSED_IRON_DOOR).put((Object)ModBlocks.WEATHERED_IRON_DOOR, (Object)ModBlocks.COATED_WEATHERED_IRON_DOOR).put((Object)Blocks.IRON_TRAPDOOR, (Object)ModBlocks.COATED_IRON_TRAPDOOR).put((Object)ModBlocks.EXPOSED_IRON_TRAPDOOR, (Object)ModBlocks.COATED_EXPOSED_IRON_TRAPDOOR).put((Object)ModBlocks.WEATHERED_IRON_TRAPDOOR, (Object)ModBlocks.COATED_WEATHERED_IRON_TRAPDOOR).put((Object)Blocks.IRON_BARS, (Object)ModBlocks.COATED_IRON_BARS).put((Object)ModBlocks.EXPOSED_IRON_BARS, (Object)ModBlocks.COATED_EXPOSED_IRON_BARS).put((Object)ModBlocks.WEATHERED_IRON_BARS, (Object)ModBlocks.COATED_WEATHERED_IRON_BARS).put((Object)ModBlocks.IRON_GRATE, (Object)ModBlocks.COATED_IRON_GRATE).put((Object)ModBlocks.EXPOSED_IRON_GRATE, (Object)ModBlocks.COATED_EXPOSED_IRON_GRATE).put((Object)ModBlocks.WEATHERED_IRON_GRATE, (Object)ModBlocks.COATED_WEATHERED_IRON_GRATE).put((Object)Blocks.IRON_CHAIN, (Object)ModBlocks.COATED_IRON_CHAIN).put((Object)ModBlocks.EXPOSED_IRON_CHAIN, (Object)ModBlocks.COATED_EXPOSED_IRON_CHAIN).put((Object)ModBlocks.WEATHERED_IRON_CHAIN, (Object)ModBlocks.COATED_WEATHERED_IRON_CHAIN).build());
    public static final Supplier<BiMap<Block, Block>> COATED_TO_UNCOATED_BLOCKS = Suppliers.memoize(() -> UNCOATED_TO_COATED_BLOCKS.get().inverse());

    public ActiveHoneycombItem(Item.Properties settings) {
        super(settings);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level world = context.getLevel();
        BlockPos blockPos = context.getClickedPos();
        BlockState blockState = world.getBlockState(blockPos);
        return ActiveHoneycombItem.getCoatedState(blockState).map(blockState2 -> {
            Player playerEntity = context.getPlayer();
            ItemStack itemStack = context.getItemInHand();
            if (playerEntity instanceof ServerPlayer) {
                ServerPlayer serverPlayerEntity = (ServerPlayer)playerEntity;
                CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(serverPlayerEntity, blockPos, itemStack);
            }
            itemStack.shrink(1);
            world.setBlock(blockPos, blockState2, 11);
            world.gameEvent((Holder)GameEvent.BLOCK_CHANGE, blockPos, GameEvent.Context.of((Entity)playerEntity, (BlockState)blockState2));
            world.levelEvent((Entity)playerEntity, 3003, blockPos, 0);
            return InteractionResult.SUCCESS;
        }).orElse((InteractionResult)InteractionResult.PASS);
    }

    public static Optional<BlockState> getCoatedState(BlockState state) {
        return Optional.ofNullable((Block)UNCOATED_TO_COATED_BLOCKS.get().get((Object)state.getBlock())).map(block -> block.withPropertiesOf(state));
    }
}

