/*
 * Decompiled with CFR 0.152.
 */
package com.sopze.mc.ironrust.item;

import com.sopze.mc.ironrust.Constants;
import com.sopze.mc.ironrust.Main;
import com.sopze.mc.ironrust.block.ModBlocks;
import com.sopze.mc.ironrust.item.ActiveHoneycombItem;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModItems {
    private static DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)Constants.MOD_ID);
    private static final DeferredHolder<Item, ? extends Item> ACTIVE_HONEYCOMB = ModItems._register("active_honeycomb", ActiveHoneycombItem::new);
    private static final DeferredHolder<Item, ? extends Item> ACTIVE_HONEYCOMB_BLOCK = ModItems._register(ModBlocks.ACTIVE_HONEYCOMB_BLOCK);
    private static final DeferredHolder<Item, ? extends Item> EXPOSED_IRON = ModItems._register(ModBlocks.EXPOSED_IRON);
    private static final DeferredHolder<Item, ? extends Item> WEATHERED_IRON = ModItems._register(ModBlocks.WEATHERED_IRON);
    private static final DeferredHolder<Item, ? extends Item> OXIDIZED_IRON = ModItems._register(ModBlocks.OXIDIZED_IRON);
    private static final DeferredHolder<Item, ? extends Item> COATED_IRON_BLOCK = ModItems._register(ModBlocks.COATED_IRON_BLOCK);
    private static final DeferredHolder<Item, ? extends Item> COATED_WEATHERED_IRON = ModItems._register(ModBlocks.COATED_WEATHERED_IRON);
    private static final DeferredHolder<Item, ? extends Item> COATED_EXPOSED_IRON = ModItems._register(ModBlocks.COATED_EXPOSED_IRON);
    private static final DeferredHolder<Item, ? extends Item> COATED_OXIDIZED_IRON = ModItems._register(ModBlocks.COATED_OXIDIZED_IRON);
    private static final DeferredHolder<Item, ? extends Item> EXPOSED_IRON_DOOR = ModItems._register(ModBlocks.EXPOSED_IRON_DOOR);
    private static final DeferredHolder<Item, ? extends Item> OXIDIZED_IRON_DOOR = ModItems._register(ModBlocks.OXIDIZED_IRON_DOOR);
    private static final DeferredHolder<Item, ? extends Item> WEATHERED_IRON_DOOR = ModItems._register(ModBlocks.WEATHERED_IRON_DOOR);
    private static final DeferredHolder<Item, ? extends Item> COATED_IRON_DOOR = ModItems._register(ModBlocks.COATED_IRON_DOOR);
    private static final DeferredHolder<Item, ? extends Item> COATED_EXPOSED_IRON_DOOR = ModItems._register(ModBlocks.COATED_EXPOSED_IRON_DOOR);
    private static final DeferredHolder<Item, ? extends Item> COATED_OXIDIZED_IRON_DOOR = ModItems._register(ModBlocks.COATED_OXIDIZED_IRON_DOOR);
    private static final DeferredHolder<Item, ? extends Item> COATED_WEATHERED_IRON_DOOR = ModItems._register(ModBlocks.COATED_WEATHERED_IRON_DOOR);
    private static final DeferredHolder<Item, ? extends Item> EXPOSED_IRON_TRAPDOOR = ModItems._register(ModBlocks.EXPOSED_IRON_TRAPDOOR);
    private static final DeferredHolder<Item, ? extends Item> OXIDIZED_IRON_TRAPDOOR = ModItems._register(ModBlocks.OXIDIZED_IRON_TRAPDOOR);
    private static final DeferredHolder<Item, ? extends Item> WEATHERED_IRON_TRAPDOOR = ModItems._register(ModBlocks.WEATHERED_IRON_TRAPDOOR);
    private static final DeferredHolder<Item, ? extends Item> COATED_IRON_TRAPDOOR = ModItems._register(ModBlocks.COATED_IRON_TRAPDOOR);
    private static final DeferredHolder<Item, ? extends Item> COATED_EXPOSED_IRON_TRAPDOOR = ModItems._register(ModBlocks.COATED_EXPOSED_IRON_TRAPDOOR);
    private static final DeferredHolder<Item, ? extends Item> COATED_OXIDIZED_IRON_TRAPDOOR = ModItems._register(ModBlocks.COATED_OXIDIZED_IRON_TRAPDOOR);
    private static final DeferredHolder<Item, ? extends Item> COATED_WEATHERED_IRON_TRAPDOOR = ModItems._register(ModBlocks.COATED_WEATHERED_IRON_TRAPDOOR);
    private static final DeferredHolder<Item, ? extends Item> IRON_GRATE = ModItems._register(ModBlocks.IRON_GRATE);
    private static final DeferredHolder<Item, ? extends Item> EXPOSED_IRON_GRATE = ModItems._register(ModBlocks.EXPOSED_IRON_GRATE);
    private static final DeferredHolder<Item, ? extends Item> WEATHERED_IRON_GRATE = ModItems._register(ModBlocks.WEATHERED_IRON_GRATE);
    private static final DeferredHolder<Item, ? extends Item> OXIDIZED_IRON_GRATE = ModItems._register(ModBlocks.OXIDIZED_IRON_GRATE);
    private static final DeferredHolder<Item, ? extends Item> COATED_IRON_GRATE = ModItems._register(ModBlocks.COATED_IRON_GRATE);
    private static final DeferredHolder<Item, ? extends Item> COATED_EXPOSED_IRON_GRATE = ModItems._register(ModBlocks.COATED_EXPOSED_IRON_GRATE);
    private static final DeferredHolder<Item, ? extends Item> COATED_WEATHERED_IRON_GRATE = ModItems._register(ModBlocks.COATED_WEATHERED_IRON_GRATE);
    private static final DeferredHolder<Item, ? extends Item> COATED_OXIDIZED_IRON_GRATE = ModItems._register(ModBlocks.COATED_OXIDIZED_IRON_GRATE);
    private static final DeferredHolder<Item, ? extends Item> EXPOSED_IRON_BARS = ModItems._register(ModBlocks.EXPOSED_IRON_BARS);
    private static final DeferredHolder<Item, ? extends Item> WEATHERED_IRON_BARS = ModItems._register(ModBlocks.WEATHERED_IRON_BARS);
    private static final DeferredHolder<Item, ? extends Item> OXIDIZED_IRON_BARS = ModItems._register(ModBlocks.OXIDIZED_IRON_BARS);
    private static final DeferredHolder<Item, ? extends Item> COATED_IRON_BARS = ModItems._register(ModBlocks.COATED_IRON_BARS);
    private static final DeferredHolder<Item, ? extends Item> COATED_EXPOSED_IRON_BARS = ModItems._register(ModBlocks.COATED_EXPOSED_IRON_BARS);
    private static final DeferredHolder<Item, ? extends Item> COATED_WEATHERED_IRON_BARS = ModItems._register(ModBlocks.COATED_WEATHERED_IRON_BARS);
    private static final DeferredHolder<Item, ? extends Item> COATED_OXIDIZED_IRON_BARS = ModItems._register(ModBlocks.COATED_OXIDIZED_IRON_BARS);
    private static final DeferredHolder<Item, ? extends Item> EXPOSED_IRON_CHAIN = ModItems._register(ModBlocks.EXPOSED_IRON_CHAIN);
    private static final DeferredHolder<Item, ? extends Item> WEATHERED_IRON_CHAIN = ModItems._register(ModBlocks.WEATHERED_IRON_CHAIN);
    private static final DeferredHolder<Item, ? extends Item> OXIDIZED_IRON_CHAIN = ModItems._register(ModBlocks.OXIDIZED_IRON_CHAIN);
    private static final DeferredHolder<Item, ? extends Item> COATED_IRON_CHAIN = ModItems._register(ModBlocks.COATED_IRON_CHAIN);
    private static final DeferredHolder<Item, ? extends Item> COATED_EXPOSED_IRON_CHAIN = ModItems._register(ModBlocks.COATED_EXPOSED_IRON_CHAIN);
    private static final DeferredHolder<Item, ? extends Item> COATED_WEATHERED_IRON_CHAIN = ModItems._register(ModBlocks.COATED_WEATHERED_IRON_CHAIN);
    private static final DeferredHolder<Item, ? extends Item> COATED_OXIDIZED_IRON_CHAIN = ModItems._register(ModBlocks.COATED_OXIDIZED_IRON_CHAIN);

    private static DeferredHolder<Item, ? extends Item> _register(String id, Function<Item.Properties, Item> factory) {
        return ITEMS.register(id, resLoc -> (Item)factory.apply(new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)resLoc))));
    }

    private static DeferredHolder<Item, ? extends Item> _register(Block block) {
        ResourceLocation resLoc = BuiltInRegistries.BLOCK.getKey((Object)block);
        return ITEMS.registerItem(resLoc.getPath(), props -> new BlockItem(block, props), () -> new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)resLoc)).useBlockDescriptionPrefix());
    }

    public static void initialize(IEventBus bus) {
        ITEMS.register(bus);
    }

    public static void initializeAfter() {
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)ACTIVE_HONEYCOMB.get()), (DispenseItemBehavior)new OptionalDispenseItemBehavior(){

            public ItemStack execute(BlockSource b, ItemStack i) {
                BlockPos blockpos = b.pos().relative((Direction)b.state().getValue((Property)DispenserBlock.FACING));
                ServerLevel level = b.level();
                BlockState blockstate = level.getBlockState(blockpos);
                Optional<BlockState> optional = ActiveHoneycombItem.getCoatedState(blockstate);
                if (optional.isPresent()) {
                    level.setBlockAndUpdate(blockpos, optional.get());
                    level.levelEvent(3003, blockpos, 0);
                    i.shrink(1);
                    this.setSuccess(true);
                    return i;
                }
                return super.execute(b, i);
            }
        });
    }

    private static void _insertAfter(BuildCreativeModeTabContentsEvent event, ItemLike target, DeferredHolder item, CreativeModeTab.TabVisibility visibility) {
        event.insertAfter(target.asItem().getDefaultInstance(), ((Item)item.get()).getDefaultInstance(), visibility);
    }

    private static void _insertAllAfter(BuildCreativeModeTabContentsEvent event, ItemLike target, Collection<DeferredHolder> items, CreativeModeTab.TabVisibility visibility) {
        for (DeferredHolder i : items) {
            event.insertAfter(target.asItem().getDefaultInstance(), ((Item)i.get()).getDefaultInstance(), visibility);
        }
    }

    public static void onBuildCreativeTabContents(BuildCreativeModeTabContentsEvent event) {
        if (!Main.isEnabledLocally()) {
            return;
        }
        ResourceKey groupKey = event.getTabKey();
        if (groupKey == CreativeModeTabs.INGREDIENTS) {
            ModItems._insertAfter(event, (ItemLike)Items.HONEYCOMB, ACTIVE_HONEYCOMB, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        } else if (groupKey == CreativeModeTabs.NATURAL_BLOCKS) {
            ModItems._insertAfter(event, (ItemLike)Blocks.HONEYCOMB_BLOCK, ACTIVE_HONEYCOMB_BLOCK, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        } else if (groupKey == CreativeModeTabs.BUILDING_BLOCKS) {
            ModItems._insertAfter(event, (ItemLike)Blocks.IRON_BLOCK, IRON_GRATE, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            ModItems._insertAllAfter(event, (ItemLike)Blocks.IRON_CHAIN, Arrays.stream(new DeferredHolder[]{EXPOSED_IRON, EXPOSED_IRON_GRATE, EXPOSED_IRON_BARS, EXPOSED_IRON_DOOR, EXPOSED_IRON_TRAPDOOR, EXPOSED_IRON_CHAIN, WEATHERED_IRON, WEATHERED_IRON_GRATE, WEATHERED_IRON_BARS, WEATHERED_IRON_DOOR, WEATHERED_IRON_TRAPDOOR, WEATHERED_IRON_CHAIN, OXIDIZED_IRON, OXIDIZED_IRON_GRATE, OXIDIZED_IRON_BARS, OXIDIZED_IRON_DOOR, OXIDIZED_IRON_TRAPDOOR, OXIDIZED_IRON_CHAIN, COATED_IRON_BLOCK, COATED_IRON_GRATE, COATED_IRON_BARS, COATED_IRON_DOOR, COATED_IRON_TRAPDOOR, COATED_IRON_CHAIN, COATED_EXPOSED_IRON, COATED_EXPOSED_IRON_GRATE, COATED_EXPOSED_IRON_BARS, COATED_EXPOSED_IRON_DOOR, COATED_EXPOSED_IRON_TRAPDOOR, COATED_EXPOSED_IRON_CHAIN, COATED_WEATHERED_IRON, COATED_WEATHERED_IRON_GRATE, COATED_WEATHERED_IRON_BARS, COATED_WEATHERED_IRON_DOOR, COATED_WEATHERED_IRON_TRAPDOOR, COATED_WEATHERED_IRON_CHAIN, COATED_OXIDIZED_IRON, COATED_OXIDIZED_IRON_GRATE, COATED_OXIDIZED_IRON_BARS, COATED_OXIDIZED_IRON_DOOR, COATED_OXIDIZED_IRON_TRAPDOOR, COATED_OXIDIZED_IRON_CHAIN}).toList().reversed(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        } else if (groupKey == CreativeModeTabs.REDSTONE_BLOCKS) {
            ModItems._insertAllAfter(event, (ItemLike)Blocks.IRON_DOOR, Arrays.stream(new DeferredHolder[]{EXPOSED_IRON_DOOR, WEATHERED_IRON_DOOR, OXIDIZED_IRON_DOOR, COATED_IRON_DOOR, COATED_EXPOSED_IRON_DOOR, COATED_WEATHERED_IRON_DOOR, COATED_OXIDIZED_IRON_DOOR}).toList().reversed(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            ModItems._insertAllAfter(event, (ItemLike)Blocks.IRON_TRAPDOOR, Arrays.stream(new DeferredHolder[]{EXPOSED_IRON_TRAPDOOR, WEATHERED_IRON_TRAPDOOR, OXIDIZED_IRON_TRAPDOOR, COATED_IRON_TRAPDOOR, COATED_EXPOSED_IRON_TRAPDOOR, COATED_WEATHERED_IRON_TRAPDOOR, COATED_OXIDIZED_IRON_TRAPDOOR}).toList().reversed(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        } else if (groupKey == CreativeModeTabs.FUNCTIONAL_BLOCKS) {
            ModItems._insertAllAfter(event, (ItemLike)Blocks.IRON_CHAIN, Arrays.stream(new DeferredHolder[]{EXPOSED_IRON_CHAIN, WEATHERED_IRON_CHAIN, OXIDIZED_IRON_CHAIN, COATED_IRON_CHAIN, COATED_EXPOSED_IRON_CHAIN, COATED_WEATHERED_IRON_CHAIN, COATED_OXIDIZED_IRON_CHAIN}).toList().reversed(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
    }
}

