/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import net.bivrik.fancytoasts.Debug;
import net.bivrik.fancytoasts.client.ui.ResourceLocationFilter;
import net.bivrik.fancytoasts.client.ui.SettingType;
import net.bivrik.fancytoasts.platform.utility.Colors;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.navigation.CommonInputs;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.NotNull;

public class ResourceLocationList
extends ObjectSelectionList<Entry> {
    private ResourceLocation[] resourceLocations;
    private SettingType settingType;
    private Consumer<ResourceLocation> acceptResponder;
    private Consumer<ResourceLocation> selectResponder;

    public ResourceLocationList(Minecraft minecraft, int width, int height, int x, int y, int itemHeight, SettingType settingType) {
        super(minecraft, width, height, y, itemHeight);
        this.setX(x);
        this.setResourceLocations(settingType);
    }

    public void setAcceptResponder(Consumer<ResourceLocation> acceptResponder) {
        this.acceptResponder = acceptResponder;
    }

    public void setSelectResponder(Consumer<ResourceLocation> selectResponder) {
        this.selectResponder = selectResponder;
    }

    public int getRowWidth() {
        return this.width - 6 - 16;
    }

    public int getRowLeft() {
        return this.getX() + this.width / 2 - this.getRowWidth() / 2 - 3;
    }

    protected int getScrollbarPosition() {
        return this.getX() + this.width - 8;
    }

    public void onSearchUpdate(String search) {
        this.clear();
        search = search.toLowerCase(Locale.ROOT);
        for (ResourceLocation location : this.resourceLocations) {
            if (!this.settingType.getDisplayData(location).getName().getString().toLowerCase(Locale.ROOT).contains(search)) continue;
            this.addEntry((AbstractSelectionList.Entry)new ResourceLocationListEntry(this, location, this.settingType.getDisplayData(location).getName()));
        }
    }

    public void onFilterUpdate(ResourceLocationFilter filter) {
        switch (filter) {
            case A_Z: {
                this.sortAZ();
                break;
            }
            case Z_A: {
                Arrays.sort(this.resourceLocations, (loc1, loc2) -> {
                    String name1 = this.settingType.getDisplayData((ResourceLocation)loc1).getName().getString();
                    String name2 = this.settingType.getDisplayData((ResourceLocation)loc2).getName().getString();
                    return name2.compareTo(name1);
                });
                break;
            }
            case BUILT_IN: {
                this.resourceLocations = this.typeSort(this.resourceLocations, true);
                break;
            }
            case CUSTOM: {
                this.resourceLocations = this.typeSort(this.resourceLocations, false);
            }
        }
        this.refillList();
    }

    private void sortAZ() {
        Arrays.sort(this.resourceLocations, (loc1, loc2) -> {
            String name1 = this.settingType.getDisplayData((ResourceLocation)loc1).getName().getString();
            String name2 = this.settingType.getDisplayData((ResourceLocation)loc2).getName().getString();
            return name1.compareTo(name2);
        });
    }

    private ResourceLocation[] typeSort(ResourceLocation[] locations, boolean isBuiltInSortType) {
        this.sortAZ();
        ArrayList<Object> sorted = new ArrayList<Object>(locations.length / 2);
        ArrayList<ResourceLocation> leftovers = new ArrayList<ResourceLocation>();
        for (ResourceLocation location : locations) {
            boolean isCustom;
            boolean isBuiltIn = location.getNamespace().equals("fancytoasts") || location.getNamespace().equals("minecraft");
            boolean isConfig = location.toLanguageKey().contains("config");
            boolean bl = isCustom = !isBuiltIn || isConfig;
            if (isBuiltInSortType != isCustom) {
                sorted.add(location);
                continue;
            }
            leftovers.add(location);
        }
        sorted.addAll(leftovers);
        return sorted.toArray(new ResourceLocation[0]);
    }

    public void setResourceLocations(SettingType settingType) {
        this.settingType = settingType;
        this.resourceLocations = this.settingType.getKeySet();
        Arrays.sort(this.resourceLocations);
        this.refillList();
    }

    private void refillList() {
        this.clear();
        for (ResourceLocation location : this.resourceLocations) {
            this.addEntry((AbstractSelectionList.Entry)new ResourceLocationListEntry(this, location, this.settingType.getDisplayData(location).getName()));
        }
    }

    private void clear() {
        this.clearEntries();
        this.setScrollAmount(0.0);
    }

    private static final class ResourceLocationListEntry
    extends Entry {
        private final ResourceLocation location;
        private final Minecraft minecraft;
        private final Font font;
        private final ResourceLocationList list;
        private final List<FormattedCharSequence> nameList;
        private final boolean isConfig;
        private long lastClickTime;

        public ResourceLocationListEntry(ResourceLocationList list, ResourceLocation location, Component name) {
            this.list = list;
            this.location = location;
            this.minecraft = this.list.minecraft;
            this.font = this.minecraft.font;
            this.isConfig = location.toLanguageKey().contains("config");
            this.nameList = this.font.split((FormattedText)name, this.list.getRowWidth() - 8 - 2);
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (Util.getMillis() - this.lastClickTime >= 250L) {
                this.lastClickTime = Util.getMillis();
                this.select();
            } else {
                this.accept();
            }
            return super.mouseClicked(mouseX, mouseX, button);
        }

        public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
            if (CommonInputs.selected((int)keyCode)) {
                this.accept();
            }
            return super.keyPressed(keyCode, scanCode, modifiers);
        }

        private void select() {
            if (this.list.selectResponder != null) {
                this.list.selectResponder.accept(this.location);
            } else {
                Debug.error("There is no select responder for Resource Location List. Could not select location: " + String.valueOf(this.location));
            }
        }

        private void accept() {
            if (this.list.acceptResponder != null) {
                this.list.acceptResponder.accept(this.location);
                this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            } else {
                Debug.error("There is no accept responder for Resource Location List. Could not accept location: " + String.valueOf(this.location));
            }
        }

        public void render(@NotNull GuiGraphics guiGraphics, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean isHovering, float partialTick) {
            int secondColor;
            int mainColor;
            x += 3;
            if (this.isFocused()) {
                mainColor = -256;
                secondColor = -377606;
            } else {
                if (isHovering) {
                    guiGraphics.fill(x, y - 2, x + width, y + height + 2, Colors.alpha(16, -1));
                    guiGraphics.fill(x + 1, y - 1, x + width - 1, y + height + 1, Colors.alpha(128, 0));
                }
                mainColor = -1;
                secondColor = -6250336;
            }
            if (this.nameList.size() == 1) {
                guiGraphics.drawString(this.font, this.nameList.get(0), x + 3, y + 3, mainColor);
            } else {
                guiGraphics.drawString(this.font, this.nameList.get(1), x + 3, y + 6, secondColor);
                guiGraphics.drawString(this.font, this.nameList.get(0), x + 3, y, mainColor);
            }
            if (this.isConfig) {
                guiGraphics.drawString(this.font, (Component)Component.literal((String)"c"), x + width - 10, y + 3, -6250336);
            }
        }
    }

    protected static abstract class Entry
    extends ObjectSelectionList.Entry<Entry> {
        protected Entry() {
        }

        @NotNull
        public Component getNarration() {
            return Component.empty();
        }
    }
}

