/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.platform.utility;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public class GUIs {
    public static void translate(PoseStack stack, float x, float y, float z) {
        stack.translate(x, y, z);
    }

    public static void translate(PoseStack stack, float x, float y) {
        GUIs.translate(stack, x, y, 0.0f);
    }

    public static void scaleAround(PoseStack stack, float sx, float sy, float ox, float oy) {
        stack.translate(ox, oy, 0.0f);
        stack.scale(sx, sy, 1.0f);
        stack.translate(-ox, -oy, 0.0f);
    }

    public static void scaleAround(PoseStack stack, float scale, float ox, float oy) {
        stack.translate(ox, oy, 0.0f);
        stack.scale(scale, scale, 1.0f);
        stack.translate(-ox, -oy, 0.0f);
    }

    public static void rotateAround(PoseStack stack, float rotation, float ox, float oy) {
        stack.rotateAround(Axis.ZP.rotation(rotation), ox, oy, 0.0f);
    }

    public static PoseStack getStack(GuiGraphics guiGraphics) {
        return guiGraphics.pose();
    }

    public static void push(PoseStack stack) {
        stack.pushPose();
    }

    public static void pop(PoseStack stack) {
        stack.popPose();
    }

    public static void drawGUITexture(GuiGraphics graphics, ResourceLocation atlas, int x, int y, int u, int v, int width, int height, float alpha) {
        if (alpha != 1.0f) {
            RenderSystem.enableBlend();
            RenderSystem.disableDepthTest();
            graphics.setColor(1.0f, 1.0f, 1.0f, alpha);
            graphics.blit(atlas, x, y, (float)u, (float)v, width, height, 256, 256);
            graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            RenderSystem.enableDepthTest();
            RenderSystem.disableBlend();
        } else {
            GUIs.drawGUITexture(graphics, atlas, x, y, u, v, width, height);
        }
    }

    public static void drawGUITexture(GuiGraphics graphics, ResourceLocation atlas, int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight) {
        graphics.blit(atlas, x, y, (float)u, (float)v, width, height, textureWidth, textureHeight);
    }

    public static void drawGUITexture(GuiGraphics graphics, ResourceLocation atlas, int x, int y, int u, int v, int width, int height) {
        graphics.blit(atlas, x, y, (float)u, (float)v, width, height, 256, 256);
    }
}

