/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.bivrik.fancytoasts.Debug;
import net.bivrik.fancytoasts.client.KeyBinding;
import net.bivrik.fancytoasts.client.gui.FancyToastConfigScreen;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;

public class KeyBindingManager {
    private final List<KeyBinding> keyBindings = new ArrayList<KeyBinding>();

    public void registerKey(String name, int keyCode, KeyBinding.keyExecutor executor) {
        String finalName = "key.fancytoasts." + name;
        KeyMapping key = new KeyMapping(finalName, keyCode, "key.categories.misc");
        KeyBinding bind = new KeyBinding(key, executor);
        if (this.keyBindings.contains(bind)) {
            Debug.warn("{} already exists, could not add", finalName);
            return;
        }
        this.keyBindings.add(bind);
        Debug.info("Registered {}", finalName);
    }

    public KeyMapping[] getUpdatedKeys(KeyMapping[] builtinKeys) {
        this.registerKey("config_menu", 75, () -> Minecraft.m_91087_().m_91152_((Screen)new FancyToastConfigScreen(null)));
        KeyMapping[] moddedKeys = Arrays.copyOf(builtinKeys, builtinKeys.length + this.keyBindings.size());
        for (int i = 0; i < this.keyBindings.size(); ++i) {
            moddedKeys[builtinKeys.length + i] = this.keyBindings.get(i).key();
        }
        return moddedKeys;
    }

    public void tick() {
        for (KeyBinding keyBinding : this.keyBindings) {
            if (!keyBinding.key().m_90859_()) continue;
            keyBinding.keyExecutor().execute();
        }
    }
}

