/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.config;

import java.io.File;
import java.util.EnumMap;
import java.util.Map;
import net.bivrik.fancytoasts.Debug;
import net.bivrik.fancytoasts.client.config.ConfigData;
import net.bivrik.fancytoasts.client.config.ConfigTextureManager;
import net.bivrik.fancytoasts.client.toast.ToastAnimationRegistry;
import net.bivrik.fancytoasts.client.toast.ToastTextureRegistry;
import net.bivrik.fancytoasts.utility.DefaultLocations;
import net.minecraft.advancements.FrameType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;

public class ToastConfigData
extends ConfigData {
    private ResourceLocation animationId;
    private ResourceLocation textureId;
    private final Map<FrameType, ResourceLocation> soundIds = new EnumMap<FrameType, ResourceLocation>(FrameType.class);

    public ToastConfigData(ResourceLocation animationId, ResourceLocation textureId, Map<FrameType, ResourceLocation> soundIds) {
        super("./config/fancytoasts/toast.json");
        this.animationId = animationId;
        this.textureId = textureId;
        this.soundIds.putAll(soundIds);
    }

    public ToastConfigData() {
        super("./config/fancytoasts/toast.json");
        this.animationId = DefaultLocations.Animations.STANDARD;
        this.textureId = DefaultLocations.Textures.VANILLA;
        this.soundIds.putAll(Map.of(FrameType.TASK, SoundEvents.f_215670_.m_11660_(), FrameType.GOAL, SoundEvents.f_11935_.m_11660_(), FrameType.CHALLENGE, SoundEvents.f_12496_.m_11660_()));
    }

    public ResourceLocation getAnimationId() {
        return this.animationId;
    }

    public void setAnimationId(ResourceLocation id) {
        this.animationId = id;
    }

    public ResourceLocation getTextureId() {
        return this.textureId;
    }

    public void setTextureId(ResourceLocation id) {
        this.textureId = id;
    }

    public ResourceLocation getSoundId(FrameType type) {
        SoundManager soundManager = Minecraft.m_91087_().m_91106_();
        if (!soundManager.m_120354_().contains(this.soundIds.get(type))) {
            Debug.warn("Saved sounds are invalid. Used standard ones");
            switch (type) {
                case TASK: {
                    return SoundEvents.f_215670_.m_11660_();
                }
                case GOAL: {
                    return SoundEvents.f_11935_.m_11660_();
                }
            }
            return SoundEvents.f_12496_.m_11660_();
        }
        return this.soundIds.get(type);
    }

    public void putSound(FrameType type, ResourceLocation location) {
        this.soundIds.put(type, location);
    }

    @Override
    public String getPath() {
        File oldPathConfigFile = new File("./config/fancytoasts/standard.json");
        oldPathConfigFile.delete();
        return super.getPath();
    }

    @Override
    public boolean isValid() {
        if (ToastTextureRegistry.isRegistered(this.textureId)) {
            if (this.textureId.m_214298_().contains("config")) {
                ConfigTextureManager.registerInMinecraft(this.textureId);
            }
        } else {
            return false;
        }
        return ToastAnimationRegistry.isRegistered(this.animationId);
    }

    @Override
    public ToastConfigData get() {
        return new ToastConfigData(this.animationId, this.textureId, this.soundIds);
    }

    @Override
    public String toString() {
        return super.toString().replace("}", ", ") + String.format("animationId='%s', textureId='%s', soundIds='%s'}", this.animationId, this.textureId, this.soundIds);
    }
}

