/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.bivrik.fancytoasts.Common;
import net.bivrik.fancytoasts.client.config.AdvancementToastPosition;
import net.bivrik.fancytoasts.client.config.AdvancementToastScreenBehavior;
import net.bivrik.fancytoasts.client.config.ConfigHandler;
import net.bivrik.fancytoasts.client.config.GeneralConfigData;
import net.bivrik.fancytoasts.client.gui.UniversalScreen;
import net.bivrik.fancytoasts.platform.Services;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class GeneralConfigScreen
extends UniversalScreen {
    private static final Component TITLE = Component.m_237115_((String)"fancytoasts.gui.config.general_title");
    private final GeneralConfigData generalConfigData;
    private Button doneButton;
    private Button backButton;
    private CycleButton<Boolean> jadeCompatCycleButton;
    private CycleButton<Boolean> soundsEnabledCycleButton;
    private VolumeSlider taskVolumeSlider;
    private VolumeSlider goalVolumeSlider;
    private VolumeSlider challengeVolumeSlider;
    private CycleButton<AdvancementToastPosition> positionCycButton;
    private CycleButton<AdvancementToastScreenBehavior> screenBehaviorCycButton;
    private final List<AbstractWidget> widgets = new ArrayList<AbstractWidget>();

    public GeneralConfigScreen(Screen parent) {
        super(TITLE, parent);
        this.generalConfigData = Common.getConfigManager().getGeneralConfig();
    }

    private void addWidget(AbstractWidget aw) {
        this.widgets.add(aw);
    }

    protected void m_7856_() {
        this.doneButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130655_, button -> this.done()).m_252987_(this.f_96543_ / 2 + 100 - 125 + 4, this.f_96544_ - 26, 150, 20).m_253136_());
        this.backButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130660_, button -> this.toParentScreen()).m_252987_(this.f_96543_ / 2 - 125 - 4, this.f_96544_ - 20 - 6, 100, 20).m_253136_());
        if (Services.PLATFORM.isModLoaded("jade")) {
            this.jadeCompatCycleButton = CycleButton.m_168919_().m_168948_((Object)this.generalConfigData.isJadeCompatEnabled()).m_232498_(value -> Tooltip.m_257550_((Component)Component.m_237115_((String)"fancytoasts.gui.tooltip.jade_compatibility"))).m_168936_(0, 0, 150, 20, (Component)Component.m_237115_((String)"fancytoasts.gui.label.jade_compatibility"), (button, value) -> this.generalConfigData.setJadeCompatEnabled((boolean)value));
        }
        this.soundsEnabledCycleButton = CycleButton.m_168919_().m_168948_((Object)this.generalConfigData.areSoundsEnabled()).m_232498_(value -> Tooltip.m_257550_((Component)Component.m_237115_((String)"fancytoasts.gui.tooltip.sounds_enabled"))).m_168936_(0, 0, 150, 20, (Component)Component.m_237115_((String)"fancytoasts.gui.label.sounds_enabled"), (button, value) -> this.generalConfigData.setSoundsEnabled((boolean)value));
        this.positionCycButton = CycleButton.m_168894_(AdvancementToastPosition::getDisplayName).m_168961_((Object[])AdvancementToastPosition.values()).m_168948_((Object)this.generalConfigData.getPosition()).m_232498_(position -> Tooltip.m_257550_((Component)Component.m_237115_((String)"fancytoasts.gui.tooltip.position"))).m_168936_(0, 0, 150, 20, (Component)Component.m_237115_((String)"fancytoasts.gui.label.position"), (button, value) -> this.generalConfigData.setPosition((AdvancementToastPosition)((Object)value)));
        this.screenBehaviorCycButton = CycleButton.m_168894_(AdvancementToastScreenBehavior::getDisplayName).m_168961_((Object[])AdvancementToastScreenBehavior.values()).m_168948_((Object)this.generalConfigData.getScreenBehavior()).m_232498_(position -> Tooltip.m_257550_((Component)Component.m_237115_((String)"fancytoasts.gui.tooltip.screen_behavior"))).m_168936_(0, 0, 150, 20, (Component)Component.m_237115_((String)"fancytoasts.gui.label.screen_behavior"), (button, value) -> this.generalConfigData.setScreenBehavior((AdvancementToastScreenBehavior)((Object)value)));
        this.taskVolumeSlider = new VolumeSlider(0, 0, 150, 20, (Component)Component.m_237115_((String)"fancytoasts.gui.label.task_volume"), this.generalConfigData.getTaskVolume());
        this.taskVolumeSlider.setResponder(this.generalConfigData::setTaskVolume);
        this.goalVolumeSlider = new VolumeSlider(0, 0, 150, 20, (Component)Component.m_237115_((String)"fancytoasts.gui.label.goal_volume"), this.generalConfigData.getGoalVolume());
        this.goalVolumeSlider.setResponder(this.generalConfigData::setGoalVolume);
        this.challengeVolumeSlider = new VolumeSlider(0, 0, 150, 20, (Component)Component.m_237115_((String)"fancytoasts.gui.label.challenge_volume"), this.generalConfigData.getChallengeVolume());
        this.challengeVolumeSlider.setResponder(this.generalConfigData::setChallengeVolume);
        if (Services.PLATFORM.isModLoaded("jade")) {
            this.addWidget((AbstractWidget)this.jadeCompatCycleButton);
        }
        this.addWidget((AbstractWidget)this.soundsEnabledCycleButton);
        this.addWidget((AbstractWidget)this.positionCycButton);
        this.addWidget((AbstractWidget)this.screenBehaviorCycButton);
        this.addWidget((AbstractWidget)this.taskVolumeSlider);
        this.addWidget((AbstractWidget)this.goalVolumeSlider);
        this.addWidget((AbstractWidget)this.challengeVolumeSlider);
        int y = 40;
        for (int i = 0; i < this.widgets.size(); ++i) {
            AbstractWidget widget;
            int x = this.f_96543_ / 2 - 150 - 4;
            if ((i & 1) == 0) {
                if (i != 0) {
                    y += 28;
                }
            } else {
                x += 158;
            }
            if ((widget = this.widgets.get(i)) == null) continue;
            widget.m_252865_(x);
            widget.m_253211_(y);
            this.m_142416_((GuiEventListener)widget);
        }
        this.addWidget((AbstractWidget)this.doneButton);
        this.addWidget((AbstractWidget)this.backButton);
    }

    protected void m_232761_() {
        this.widgets.clear();
        super.m_232761_();
    }

    private void done() {
        ConfigHandler.save(this.generalConfigData);
        this.toParentScreen();
    }

    @Override
    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.m_280039_(graphics);
        this.RenderListBackground(graphics);
        super.renderForeground(graphics, mouseX, mouseY, partialTick);
    }

    private void RenderListBackground(@NotNull GuiGraphics guiGraphics) {
        int x0 = 0;
        int x1 = this.f_96543_;
        int y0 = 32;
        int y1 = this.f_96544_ - 32;
        guiGraphics.m_280509_(x0, y0, x1, y1, 0x77000000);
        guiGraphics.m_285978_(RenderType.m_286086_(), x0, y0, x1, y0 + 4, -16777216, 0, 0);
        guiGraphics.m_285978_(RenderType.m_286086_(), x0, y1 - 4, x1, y1, 0, -16777216, 0);
    }

    private static class VolumeSlider
    extends AbstractSliderButton {
        private Consumer<Float> responder;
        private Component message;

        public VolumeSlider(int x, int y, int width, int height, Component message, double value) {
            super(x, y, width, height, (Component)Component.m_237119_(), value / 2.0);
            this.message = message;
            this.m_5695_();
        }

        public void setResponder(Consumer<Float> responder) {
            this.responder = responder;
        }

        protected void m_5695_() {
            this.m_93666_((Component)CommonComponents.m_178393_((Component)this.message, (Component)Component.m_237113_((String)(Math.round(this.getVolume() * 100.0f) + "%"))));
        }

        private float getVolume() {
            return (float)Math.round(Mth.m_14139_((double)this.f_93577_, (double)0.0, (double)2.0) * 100.0) / 100.0f;
        }

        protected void m_5697_() {
            this.responder.accept(Float.valueOf(this.getVolume()));
        }
    }
}

