/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.toast.animation;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.bivrik.fancytoasts.client.toast.FancyAdvancementToast;
import net.bivrik.fancytoasts.client.toast.animation.Appearance;
import net.bivrik.fancytoasts.client.toast.animation.FancyAdvancementSetup;
import net.bivrik.fancytoasts.client.toast.animation.FancyAdvancementToastAnimation;
import net.bivrik.fancytoasts.platform.utility.Colors;
import net.bivrik.fancytoasts.platform.utility.GUIs;
import net.bivrik.fancytoasts.utility.MathEasing;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;

public class QuirkyAnimation
extends FancyAdvancementToastAnimation {
    private final Appearance ICON_APPEARANCE = new Appearance(2000, 0);
    private final Appearance ICON_SCALE = new Appearance(3500, 0);
    private final Appearance BANNER_APPEARANCE = new Appearance(900, 1200);
    private final Appearance BACKGROUND_APPEARANCE = new Appearance(1000, 1000);
    private final Appearance TEXT_APPEARANCE = new Appearance(1000, 1800);
    private final int FADE_OUT_DURATION = 1500;
    private final int DURATION = 6500;
    private static final Random random = new Random();
    private static float randomRotation;
    private List<FormattedCharSequence> DESCRIPTION = new ArrayList<FormattedCharSequence>();

    @Override
    public void setup(FancyAdvancementSetup setup, FancyAdvancementToast toast) {
        super.setup(setup, toast);
        randomRotation = random.nextFloat(-0.4f, 0.4f);
        this.DESCRIPTION = toast.getMinecraft().f_91062_.m_92923_((FormattedText)setup.display().m_14985_(), this.toast.getWidth() - 16);
    }

    @Override
    public void draw(GuiGraphics guiGraphics, Minecraft minecraft, long time) {
        super.draw(guiGraphics, minecraft, time);
        float iconAppearProgress = this.ICON_APPEARANCE.getProgress(time);
        float iconScaleProgress = this.ICON_SCALE.getProgress(time);
        float bannerAppearProgress = this.BANNER_APPEARANCE.getProgress(time);
        float backgroundAppearProgress = this.BACKGROUND_APPEARANCE.getProgress(time);
        float textAppearProgress = this.TEXT_APPEARANCE.getProgress(time);
        float fadeOutProgress = Appearance.getProgress(time, 1500, 5000);
        PoseStack stack = GUIs.getStack(guiGraphics);
        float sinX = (float)(Math.sin((double)time / 800.0) * 7.0);
        float sinY = (float)(Math.sin((double)time / 400.0) * 5.0);
        GUIs.push(stack);
        GUIs.translate(stack, sinX, sinY);
        if (fadeOutProgress > 0.0f) {
            float fadeOutScaleX = MathEasing.easeInLerp(1.0f, 0.0f, fadeOutProgress);
            float fadeOutRotation = MathEasing.easeInLerp(0.0f, randomRotation, fadeOutProgress);
            float toastCenterX = (float)this.toast.getWidth() / 2.0f;
            float toastCenterY = (float)this.toast.getHeight() / 2.0f;
            GUIs.push(stack);
            GUIs.scaleAround(stack, fadeOutScaleX, toastCenterX, toastCenterY);
            GUIs.rotateAround(stack, fadeOutRotation, toastCenterX, toastCenterY);
        }
        if (bannerAppearProgress > 0.0f) {
            GUIs.push(stack);
            float y = 32.0f;
            if (bannerAppearProgress != 1.0f) {
                y = MathEasing.easeOutLerp(-40.0f, 32.0f, bannerAppearProgress);
            }
            GUIs.translate(stack, 0.0f, y);
            this.drawBanner(guiGraphics);
            GUIs.pop(stack);
        }
        if (backgroundAppearProgress > 0.0f) {
            GUIs.push(stack);
            int y = -25;
            if (backgroundAppearProgress != 1.0f) {
                y = MathEasing.easeOutLerp(-120, -25, backgroundAppearProgress);
            }
            GUIs.translate(stack, 0.0f, y);
            this.drawBackground(guiGraphics);
            GUIs.pop(stack);
        }
        if (iconAppearProgress > 0.0f) {
            GUIs.push(stack);
            float posY = 29.0f;
            if (iconAppearProgress != 1.0f) {
                posY = MathEasing.easeOutLerp(-120, 29, iconAppearProgress);
            }
            if (iconScaleProgress != 1.0f && iconScaleProgress > 0.0f) {
                float scale = MathEasing.easeOutLerp(3.0f, 1.0f, iconScaleProgress);
                GUIs.scaleAround(stack, scale, 81.0f, 17.0f);
            }
            GUIs.translate(stack, 0.0f, (float)(Math.sin((double)time / 400.0) * -1.2) + posY);
            this.drawIcon(guiGraphics);
            GUIs.pop(stack);
        }
        if (textAppearProgress > 0.05f) {
            int a = Mth.m_14143_((float)(textAppearProgress * 255.0f));
            int titleColor = Colors.alpha(a, this.setup.titleColor());
            int toastColor = Colors.alpha(a, this.setup.toastColor());
            Font font = minecraft.f_91062_;
            DisplayInfo display = this.setup.display();
            int toastCenterX = this.toast.getWidth() / 2;
            guiGraphics.m_280653_(font, display.m_14992_().m_15553_(), toastCenterX, 0, titleColor);
            if (!this.DESCRIPTION.isEmpty()) {
                guiGraphics.m_280364_(font, this.DESCRIPTION.get(0), toastCenterX, 12, toastColor);
                if (this.DESCRIPTION.size() > 1) {
                    FormattedCharSequence descriptionSecondLine = this.DESCRIPTION.get(1);
                    if (this.DESCRIPTION.size() > 2) {
                        guiGraphics.m_280364_(font, descriptionSecondLine, toastCenterX - font.m_92895_("...") / 2, 21, toastColor);
                        guiGraphics.m_280137_(font, "...", toastCenterX + font.m_92724_(descriptionSecondLine) / 2, 21, toastColor);
                    } else {
                        guiGraphics.m_280364_(font, descriptionSecondLine, toastCenterX, 21, toastColor);
                    }
                }
            }
        }
        if (fadeOutProgress > 0.0f) {
            GUIs.pop(stack);
        }
        GUIs.pop(stack);
    }

    @Override
    public int getDuration() {
        return 6500;
    }

    @Override
    public int getToastSoundTiming() {
        return 1000;
    }
}

