/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.ui;

import java.util.ArrayList;
import java.util.List;
import net.bivrik.fancytoasts.client.ui.CreditsManager;
import net.bivrik.fancytoasts.platform.utility.Components;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import org.jetbrains.annotations.NotNull;

public class CreditsList
extends AbstractSelectionList<Entry> {
    private final List<CreditsListEntry> lines = new ArrayList<CreditsListEntry>(10);
    private float autoScrollSpeed = 0.4f;

    public CreditsList(Minecraft minecraft, int width, int height, int x, int y, CreditsManager.CreditsData data) {
        super(minecraft, width, height, y, y + height, 18);
        this.f_93393_ = x;
        this.f_93392_ = x + width;
        this.m_93471_(false);
        this.m_93496_(false);
        this.updateList(data);
    }

    private void updateList(CreditsManager.CreditsData data) {
        for (int i = 0; i < this.f_93389_ / this.f_93387_ + 2; ++i) {
            this.addSpace();
        }
        for (String category : data.categories().keySet()) {
            this.addCategory(category);
            for (CreditsManager.CreditsData.User user : data.categories().get(category)) {
                this.addLine(user);
            }
            this.addSpace();
        }
        for (int i = 0; i < this.f_93389_ / this.f_93387_; ++i) {
            this.addSpace();
        }
        this.acceptLines();
    }

    private void acceptLines() {
        for (CreditsListEntry line : this.lines) {
            this.m_7085_(line);
        }
    }

    protected int m_5756_() {
        return this.f_93388_ * 2;
    }

    private void addSpace() {
        this.lines.add(new CreditsListEntry(this, "", null, false));
    }

    private void addCategory(String category) {
        this.lines.add(new CreditsListEntry(this, category, null, true));
    }

    private void addLine(CreditsManager.CreditsData.User user) {
        this.lines.add(new CreditsListEntry(this, user.name(), user.annotation(), false));
    }

    public void scroll() {
        this.m_93410_(this.m_93517_() + (double)this.autoScrollSpeed);
        if (this.m_93517_() == (double)this.m_93518_()) {
            this.m_93410_(0.0);
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 32) {
            this.autoScrollSpeed = 1.2f;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 32) {
            this.autoScrollSpeed = 0.4f;
        }
        return super.m_7920_(keyCode, scanCode, modifiers);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        return false;
    }

    public void m_142291_(NarrationElementOutput narrationElementOutput) {
    }

    private static class CreditsListEntry
    extends Entry {
        private final CreditsList list;
        private final String content;
        private final String annotation;
        private final Font font;
        private final int color;
        private final boolean isCategory;
        private final boolean isSpace;

        public CreditsListEntry(CreditsList list, String content, String annotation, boolean isCategory) {
            this.list = list;
            this.content = content.compareTo("{user.name}") == 0 ? this.list.f_93386_.m_91094_().m_92546_() : content;
            this.annotation = annotation;
            this.font = ((CreditsList)this.list).f_93386_.f_91062_;
            this.color = !isCategory ? -1 : -256;
            this.isCategory = isCategory;
            this.isSpace = content.isEmpty();
        }

        public void m_6311_(@NotNull GuiGraphics guiGraphics, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean isHovering, float partialTick) {
            if (this.isSpace) {
                return;
            }
            if (this.isCategory) {
                guiGraphics.m_280653_(this.font, Components.of("gui.label." + this.content), this.list.f_93388_ / 2, y, this.color);
            } else {
                guiGraphics.m_280488_(this.font, this.content, x, y, this.color);
                if (this.annotation != null && !this.annotation.isEmpty()) {
                    guiGraphics.m_280488_(this.font, this.annotation, x + this.font.m_92895_(this.content) + 8, y, -6250336);
                }
            }
        }
    }

    protected static abstract class Entry
    extends AbstractSelectionList.Entry<Entry> {
        protected Entry() {
        }
    }
}

