/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.platform.utility;

import net.minecraft.network.chat.Component;

public class Components {
    private static final String DEFAULT_ID = "fancytoasts";

    private static Component getTranslatableComponent(String modId, String name, TranslatableType type) {
        StringBuilder translationKey = new StringBuilder(DEFAULT_ID);
        if (modId != null && modId.compareTo(DEFAULT_ID) != 0) {
            translationKey.append(".").append(modId);
        }
        translationKey.append(".").append(type.getName()).append(".toast.").append(name);
        return Component.m_237115_((String)translationKey.toString());
    }

    public static Component of(String path) {
        return Component.m_237115_((String)("fancytoasts." + path));
    }

    public static Component translatableTexture(String modId, String name) {
        return Components.getTranslatableComponent(modId, name, TranslatableType.TEXTURE);
    }

    public static Component translatableAnimation(String modId, String name) {
        return Components.getTranslatableComponent(modId, name, TranslatableType.ANIMATION);
    }

    private static enum TranslatableType {
        ANIMATION("animations"),
        TEXTURE("textures");

        private final String name;

        private TranslatableType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

