/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.block.misc;

import com.github.ysbbbbbb.kaleidoscopecookery.init.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class ChiliRistraBlock
extends Block {
    public static final BooleanProperty IS_HEAD = BooleanProperty.create((String)"is_head");
    public static final BooleanProperty SHEARED = BooleanProperty.create((String)"sheared");
    private static final VoxelShape AABB_HEAD = Block.box((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final VoxelShape AABB_BODY = Block.box((double)3.5, (double)0.0, (double)3.5, (double)12.5, (double)16.0, (double)12.5);

    public ChiliRistraBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_RED).noCollission().instabreak().sound(SoundType.GRASS).pushReaction(PushReaction.DESTROY));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)IS_HEAD, (Comparable)Boolean.valueOf(true))).setValue((Property)SHEARED, (Comparable)Boolean.valueOf(false)));
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (hand != InteractionHand.MAIN_HAND) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        ItemStack mainHandItem = player.getMainHandItem();
        if (!mainHandItem.isEmpty() && !mainHandItem.is((Item)ModItems.RED_CHILI.get())) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (((Boolean)state.getValue((Property)SHEARED)).booleanValue()) {
            level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
        } else {
            level.setBlock(pos, (BlockState)state.setValue((Property)SHEARED, (Comparable)Boolean.valueOf(true)), 3);
        }
        ItemStack redChili = new ItemStack((ItemLike)ModItems.RED_CHILI.get(), 3);
        if (mainHandItem.isEmpty()) {
            player.setItemInHand(InteractionHand.MAIN_HAND, redChili);
        } else {
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)redChili);
        }
        level.playSound(null, pos, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, 0.8f + level.random.nextFloat() * 0.4f);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, state), (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 20, 0.25, 0.25, 0.25, 0.05);
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        Mob mob;
        if (!level.isClientSide && entity instanceof Mob && (mob = (Mob)entity).getType().is(EntityTypeTags.UNDEAD)) {
            mob.hurt(level.damageSources().magic(), 2.0f);
        }
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor levelAccessor, BlockPos currentPos, BlockPos neighborPos) {
        if (direction == Direction.DOWN.getOpposite() && !state.canSurvive((LevelReader)levelAccessor, currentPos)) {
            levelAccessor.scheduleTick(currentPos, (Block)this, 1);
        }
        if (direction == Direction.DOWN) {
            return (BlockState)state.setValue((Property)IS_HEAD, (Comparable)Boolean.valueOf(!neighborState.is((Block)this)));
        }
        return super.updateShape(state, direction, neighborState, levelAccessor, currentPos, neighborPos);
    }

    public boolean canSurvive(BlockState state, LevelReader levelReader, BlockPos pos) {
        BlockPos belowPos = pos.relative(Direction.DOWN.getOpposite());
        BlockState belowState = levelReader.getBlockState(belowPos);
        return belowState.is((Block)this) || belowState.isFaceSturdy((BlockGetter)levelReader, belowPos, Direction.DOWN);
    }

    public void tick(BlockState state, ServerLevel serverLevel, BlockPos pos, RandomSource random) {
        if (!state.canSurvive((LevelReader)serverLevel, pos)) {
            serverLevel.destroyBlock(pos, true);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{IS_HEAD, SHEARED});
    }

    public VoxelShape getShape(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext collisionContext) {
        return (Boolean)state.getValue((Property)IS_HEAD) != false ? AABB_HEAD : AABB_BODY;
    }
}

