/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.block.misc;

import com.github.ysbbbbbb.kaleidoscopecookery.init.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;

public class StrawBlocks
extends RotatedPillarBlock {
    public StrawBlocks() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW).instrument(NoteBlockInstrument.BANJO).strength(0.5f).sound(SoundType.GRASS));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AXIS, (Comparable)Direction.Axis.Y));
    }

    public void fallOn(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if (level.isClientSide()) {
            return;
        }
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        level.playSound(null, pos, SoundEvents.GRASS_FALL, entity.getSoundSource(), 1.0f, 1.0f);
        if (fallDistance < 3.0f) {
            return;
        }
        float possibility = Mth.clamp((float)(fallDistance / 30.0f), (float)0.0f, (float)1.0f);
        if (level.random.nextFloat() < possibility) {
            level.destroyBlock(pos, false);
            StrawBlocks.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)ModItems.RICE_PANICLE.get(), 5));
            StrawBlocks.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)ModItems.RICE_SEED.get(), 4));
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 10, 0.1, 0.1, 0.1, 0.05);
            }
        }
    }
}

