/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.blockentity.kitchen;

import com.github.ysbbbbbb.kaleidoscopecookery.advancements.critereon.ModEventTrigger;
import com.github.ysbbbbbb.kaleidoscopecookery.api.blockentity.IStockpot;
import com.github.ysbbbbbb.kaleidoscopecookery.api.event.StockpotMatchRecipeEvent;
import com.github.ysbbbbbb.kaleidoscopecookery.api.recipe.soupbase.ISoupBase;
import com.github.ysbbbbbb.kaleidoscopecookery.block.kitchen.StockpotBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.blockentity.BaseBlockEntity;
import com.github.ysbbbbbb.kaleidoscopecookery.client.particle.StockpotParticleOptions;
import com.github.ysbbbbbb.kaleidoscopecookery.crafting.container.StockpotInput;
import com.github.ysbbbbbb.kaleidoscopecookery.crafting.recipe.StockpotRecipe;
import com.github.ysbbbbbb.kaleidoscopecookery.crafting.serializer.StockpotRecipeSerializer;
import com.github.ysbbbbbb.kaleidoscopecookery.crafting.soupbase.FluidSoupBase;
import com.github.ysbbbbbb.kaleidoscopecookery.crafting.soupbase.SoupBaseManager;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModBlocks;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModItems;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModParticles;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModRecipes;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModSounds;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModSoupBases;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModTrigger;
import com.github.ysbbbbbb.kaleidoscopecookery.init.tag.TagMod;
import com.github.ysbbbbbb.kaleidoscopecookery.util.BlockDrop;
import com.github.ysbbbbbb.kaleidoscopecookery.util.ItemUtils;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public class StockpotBlockEntity
extends BaseBlockEntity
implements IStockpot {
    public static final int MAX_TAKEOUT_COUNT = 9;
    private static final String INPUTS = "Inputs";
    private static final String RECIPE_ID = "RecipeId";
    private static final String SOUP_BASE_ID = "SoupBaseId";
    private static final String RESULT = "Result";
    private static final String STATUS = "Status";
    private static final String CURRENT_TICK = "CurrentTick";
    private static final String TAKEOUT_COUNT = "TakeoutCount";
    private static final String LID_ITEM = "LidItem";
    private final RecipeManager.CachedCheck<StockpotInput, StockpotRecipe> quickCheck = RecipeManager.createCheck(ModRecipes.STOCKPOT_RECIPE);
    private NonNullList<ItemStack> inputs = NonNullList.withSize((int)9, (Object)ItemStack.EMPTY);
    private ResourceLocation recipeId = StockpotRecipeSerializer.EMPTY_ID;
    private ResourceLocation soupBaseId = ModSoupBases.WATER;
    private ItemStack result = ItemStack.EMPTY;
    private int status = 0;
    private int currentTick = -1;
    private int takeoutCount = 0;
    private ItemStack lidItem = ItemStack.EMPTY;
    public RecipeHolder<StockpotRecipe> recipe = StockpotRecipeSerializer.getEmptyRecipe();
    @Nullable
    public Entity renderEntity = null;

    public StockpotBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(ModBlocks.STOCKPOT_BE.get(), pPos, pBlockState);
    }

    public void clientTick() {
        if (this.renderEntity != null) {
            ++this.renderEntity.tickCount;
        }
    }

    @Override
    public boolean hasHeatSource(Level level) {
        BlockState belowState = level.getBlockState(this.worldPosition.below());
        if (belowState.hasProperty((Property)BlockStateProperties.LIT) && ((Boolean)belowState.getValue((Property)BlockStateProperties.LIT)).booleanValue()) {
            return true;
        }
        return belowState.is(TagMod.HEAT_SOURCE_BLOCKS_WITHOUT_LIT);
    }

    @Override
    public boolean hasLid() {
        if (this.level == null) {
            return false;
        }
        BlockState blockState = this.level.getBlockState(this.worldPosition);
        return this.level != null && blockState.hasProperty((Property)StockpotBlock.HAS_LID) && (Boolean)blockState.getValue((Property)StockpotBlock.HAS_LID) != false;
    }

    public void tick(Level level) {
        if (this.status == 0) {
            return;
        }
        if (!this.hasHeatSource(level)) {
            return;
        }
        boolean hasLid = this.hasLid();
        if (level.getGameTime() % 15L == 0L) {
            float volume = hasLid ? 0.075f : 0.2f;
            float pitch = hasLid ? 0.1f + level.random.nextFloat() * 0.05f : 1.0f + level.random.nextFloat() * 0.1f;
            level.playSound(null, (double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5, (SoundEvent)ModSounds.BLOCK_STOCKPOT.get(), SoundSource.BLOCKS, volume, pitch);
        }
        if (!hasLid) {
            this.spawnParticleWithoutLid(level);
            return;
        }
        this.spawnParticleWithLid(level);
        if (this.status == 1 && level.getGameTime() % 5L == 0L && !this.isEmpty()) {
            this.setRecipe(level);
            this.status = 2;
            this.refresh();
            return;
        }
        if (this.status == 2) {
            if (this.currentTick > 0) {
                --this.currentTick;
                return;
            }
            this.status = 3;
            this.currentTick = -1;
            this.inputs.clear();
            this.refresh();
        }
    }

    private void spawnParticleWithLid(Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (level.random.nextFloat() < 0.05f) {
                RandomSource random = serverLevel.random;
                serverLevel.sendParticles((ParticleOptions)((SimpleParticleType)ModParticles.COOKING.get()), (double)this.worldPosition.getX() + 0.5 + random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), (double)this.worldPosition.getY() + 0.375 + random.nextDouble() / 3.0, (double)this.worldPosition.getZ() + 0.5 + random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), 1, 0.0, 0.0, 0.0, 0.05);
            }
        }
    }

    private void spawnParticleWithoutLid(Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (serverLevel.random.nextFloat() < 0.25f) {
                int color = this.getBubbleColor();
                serverLevel.sendParticles((ParticleOptions)new StockpotParticleOptions(Vec3.fromRGB24((int)color).toVector3f(), 1.0f), (double)this.worldPosition.getX() + 0.25 + (double)(level.random.nextFloat() * 0.5f), (double)this.worldPosition.getY() + 0.375, (double)this.worldPosition.getZ() + 0.25 + (double)(level.random.nextFloat() * 0.5f), 2, ((double)level.random.nextFloat() - 0.5) * (double)0.1f, 0.0, ((double)level.random.nextFloat() - 0.5) * (double)0.1f, 0.0);
            }
        }
    }

    private int getBubbleColor() {
        if (this.level != null && this.recipeId != StockpotRecipeSerializer.EMPTY_ID && this.recipe.id() == StockpotRecipeSerializer.EMPTY_ID) {
            RecipeHolder stockpotRecipe = this.level.getRecipeManager().byKeyTyped(ModRecipes.STOCKPOT_RECIPE, this.recipeId);
            this.recipe = Objects.requireNonNullElseGet(stockpotRecipe, StockpotRecipeSerializer::getEmptyRecipe);
        }
        if (this.status == 2) {
            return ((StockpotRecipe)this.recipe.value()).cookingBubbleColor();
        }
        if (this.status == 3) {
            return ((StockpotRecipe)this.recipe.value()).finishedBubbleColor();
        }
        ISoupBase soup = this.getSoupBase();
        if (soup != null) {
            return soup.getBubbleColor();
        }
        return 0xFFFFFF;
    }

    @Override
    public boolean onLitClick(Level level, LivingEntity user, ItemStack stack) {
        BlockState blockState = level.getBlockState(this.worldPosition);
        boolean hasLid = this.hasLid();
        if (!hasLid && stack.is((Item)ModItems.STOCKPOT_LID.get())) {
            this.setLidItem(stack.split(1));
            this.setChanged();
            level.setBlockAndUpdate(this.worldPosition, (BlockState)blockState.setValue((Property)StockpotBlock.HAS_LID, (Comparable)Boolean.valueOf(true)));
            user.playSound(SoundEvents.LANTERN_PLACE, 0.5f, 0.5f);
            ((ModEventTrigger)((Object)ModTrigger.EVENT.get())).trigger(user, "use_lid_on_stockpot");
            return true;
        }
        if (hasLid) {
            ItemStack lid = this.getLidItem().isEmpty() ? ((Item)ModItems.STOCKPOT_LID.get()).getDefaultInstance() : this.getLidItem().copy();
            this.setLidItem(ItemStack.EMPTY);
            if (stack.isEmpty()) {
                user.setItemInHand(InteractionHand.MAIN_HAND, lid);
            } else {
                BlockDrop.popResource(level, this.worldPosition, 0.5, lid);
            }
            this.setChanged();
            level.setBlockAndUpdate(this.worldPosition, (BlockState)blockState.setValue((Property)StockpotBlock.HAS_LID, (Comparable)Boolean.valueOf(false)));
            user.playSound(SoundEvents.LANTERN_BREAK, 0.5f, 0.5f);
            return true;
        }
        return false;
    }

    public StockpotInput getContainer() {
        return new StockpotInput((List<ItemStack>)this.inputs, this.soupBaseId);
    }

    private void setRecipe(Level levelIn) {
        StockpotInput container = this.getContainer();
        StockpotMatchRecipeEvent.Pre preEvent = new StockpotMatchRecipeEvent.Pre(levelIn, this, container);
        NeoForge.EVENT_BUS.post((Event)preEvent);
        if (preEvent.getOutput() != null) {
            this.applyRecipe(levelIn, container, preEvent.getOutput());
        }
        this.quickCheck.getRecipeFor((RecipeInput)container, levelIn).ifPresentOrElse(recipe -> this.applyRecipe(levelIn, container, (RecipeHolder<StockpotRecipe>)recipe), () -> {
            this.recipeId = StockpotRecipeSerializer.EMPTY_ID;
            this.recipe = StockpotRecipeSerializer.getEmptyRecipe();
            this.result = Items.SUSPICIOUS_STEW.getDefaultInstance();
            this.currentTick = 300;
            this.takeoutCount = 1;
        });
        StockpotMatchRecipeEvent.Post postEvent = new StockpotMatchRecipeEvent.Post(levelIn, this, container, this.recipe);
        NeoForge.EVENT_BUS.post((Event)postEvent);
        if (postEvent.getOutput() != null) {
            this.applyRecipe(levelIn, container, postEvent.getOutput());
        }
    }

    private void applyRecipe(Level level, StockpotInput container, RecipeHolder<StockpotRecipe> recipe) {
        this.recipeId = recipe.id();
        this.recipe = recipe;
        this.result = ((StockpotRecipe)recipe.value()).assemble(container, (HolderLookup.Provider)level.registryAccess());
        this.currentTick = ((StockpotRecipe)recipe.value()).time();
        this.takeoutCount = Math.min(this.result.getCount(), 9);
    }

    @Override
    public boolean addSoupBase(Level level, LivingEntity user, ItemStack bucket) {
        if (this.hasLid()) {
            return false;
        }
        if (this.status != 0) {
            return false;
        }
        for (Map.Entry<ResourceLocation, ISoupBase> entry : SoupBaseManager.getAllSoupBases().entrySet()) {
            ResourceLocation key = entry.getKey();
            ISoupBase soupBase = entry.getValue();
            if (!soupBase.isSoupBase(bucket)) continue;
            this.soupBaseId = key;
            this.status = 1;
            this.refresh();
            ItemStack container = soupBase.getReturnContainer(level, user, bucket);
            bucket.shrink(1);
            ItemUtils.getItemToLivingEntity(user, container);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeSoupBase(Level level, LivingEntity user, ItemStack bucket) {
        if (this.status == 1 && this.isEmpty() && SoupBaseManager.containsSoupBase(this.soupBaseId)) {
            ISoupBase soupBase = this.getSoupBase();
            if (soupBase == null || !soupBase.isContainer(bucket)) {
                return false;
            }
            this.renderEntity = null;
            this.soupBaseId = ModSoupBases.WATER;
            this.status = 0;
            this.refresh();
            ItemStack container = soupBase.getReturnSoupBase(level, user, bucket);
            bucket.shrink(1);
            ItemUtils.getItemToLivingEntity(user, container);
            return true;
        }
        return false;
    }

    public void addAllIngredients(List<ItemStack> ingredients, LivingEntity user) {
        if (this.level == null) {
            return;
        }
        if (this.hasLid()) {
            return;
        }
        if (this.status != 1) {
            return;
        }
        for (int i = 0; i < Math.min(ingredients.size(), this.inputs.size()); ++i) {
            ItemStack stack = ingredients.get(i);
            if (stack.isEmpty()) continue;
            Item containerItem = ItemUtils.getContainerItem(stack);
            if (containerItem != Items.AIR) {
                ItemUtils.getItemToLivingEntity(user, containerItem.getDefaultInstance());
            }
            this.inputs.set(i, (Object)stack.copyWithCount(1));
        }
        this.level.playSound(null, this.worldPosition, SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, ((this.level.random.nextFloat() - this.level.random.nextFloat()) * 0.7f + 1.0f) * 2.0f);
        this.refresh();
    }

    @Override
    public boolean addIngredient(Level level, LivingEntity user, ItemStack itemStack) {
        if (this.hasLid()) {
            return false;
        }
        if (this.status != 1) {
            return false;
        }
        if (!itemStack.has(DataComponents.FOOD) && !itemStack.is(TagMod.POT_INGREDIENT)) {
            return false;
        }
        for (int i = 0; i < this.inputs.size(); ++i) {
            if (!((ItemStack)this.inputs.get(i)).isEmpty()) continue;
            Item containerItem = ItemUtils.getContainerItem(itemStack);
            if (containerItem != Items.AIR) {
                ItemUtils.getItemToLivingEntity(user, containerItem.getDefaultInstance());
            }
            this.inputs.set(i, (Object)itemStack.split(1));
            level.playSound(null, user.getX(), user.getY() + 0.5, user.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, ((level.random.nextFloat() - level.random.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            this.refresh();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeIngredient(Level level, LivingEntity user) {
        if (this.hasLid()) {
            return false;
        }
        if (this.status != 1) {
            return false;
        }
        for (int i = this.inputs.size() - 1; i >= 0; --i) {
            FluidSoupBase fluidSoupBase;
            ItemStack stack = (ItemStack)this.inputs.get(i);
            if (stack.isEmpty()) continue;
            if (!this.containerIsMatch(user, stack)) {
                return false;
            }
            this.inputs.set(i, (Object)ItemStack.EMPTY);
            ItemUtils.getItemToLivingEntity(user, stack.copy());
            ISoupBase soupBase = this.getSoupBase();
            if (soupBase instanceof FluidSoupBase && (fluidSoupBase = (FluidSoupBase)soupBase).getFluid().getFluidType().getTemperature() > 500) {
                user.hurt(level.damageSources().inFire(), 1.0f);
                ((ModEventTrigger)((Object)ModTrigger.EVENT.get())).trigger(user, "hurt_when_takeout_from_stockpot");
            }
            this.refresh();
            return true;
        }
        return false;
    }

    private boolean containerIsMatch(LivingEntity user, ItemStack stack) {
        Item containerItem = ItemUtils.getContainerItem(stack);
        if (containerItem == Items.AIR) {
            return true;
        }
        if (user.getMainHandItem().is(containerItem)) {
            user.getMainHandItem().shrink(1);
            return true;
        }
        this.sendActionBarMessage(user, "tip.kaleidoscope_cookery.kitchen.remove_ingredient.need_container", containerItem.getDefaultInstance().getHoverName());
        return false;
    }

    @Override
    public boolean takeOutProduct(Level level, LivingEntity user, ItemStack stack) {
        if (this.hasLid()) {
            return false;
        }
        if (this.status != 3 || this.result.isEmpty() || this.takeoutCount <= 0) {
            return false;
        }
        Ingredient carrier = ((StockpotRecipe)this.recipe.value()).carrier();
        if (!carrier.isEmpty() && !carrier.test(stack)) {
            Component carrierName = carrier.getItems()[0].getHoverName();
            this.sendActionBarMessage(user, "tip.kaleidoscope_cookery.pot.need_carrier", carrierName);
            return false;
        }
        if (!carrier.isEmpty()) {
            stack.shrink(1);
        }
        ItemStack resultCopy = this.result.copyWithCount(1);
        ItemUtils.getItemToLivingEntity(user, resultCopy);
        --this.takeoutCount;
        if (this.takeoutCount <= 0) {
            this.status = 0;
            this.inputs.clear();
            this.recipeId = StockpotRecipeSerializer.EMPTY_ID;
            this.soupBaseId = ModSoupBases.WATER;
            this.result = ItemStack.EMPTY;
            this.currentTick = -1;
            this.renderEntity = null;
        }
        this.refresh();
        return true;
    }

    private void sendActionBarMessage(LivingEntity user, String key, Object ... args) {
        if (user instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)user;
            MutableComponent message = Component.translatable((String)key, (Object[])args);
            serverPlayer.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)message));
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put(INPUTS, (Tag)ContainerHelper.saveAllItems((CompoundTag)new CompoundTag(), this.inputs, (HolderLookup.Provider)registries));
        tag.putString(RECIPE_ID, this.recipeId.toString());
        tag.putString(SOUP_BASE_ID, this.soupBaseId.toString());
        tag.put(RESULT, this.result.saveOptional(registries));
        tag.putInt(STATUS, this.status);
        tag.putInt(CURRENT_TICK, this.currentTick);
        tag.putInt(TAKEOUT_COUNT, this.takeoutCount);
        tag.put(LID_ITEM, this.lidItem.saveOptional(registries));
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains(INPUTS)) {
            this.inputs = NonNullList.withSize((int)9, (Object)ItemStack.EMPTY);
            ContainerHelper.loadAllItems((CompoundTag)tag.getCompound(INPUTS), this.inputs, (HolderLookup.Provider)registries);
        }
        if (tag.contains(RECIPE_ID)) {
            this.recipeId = ResourceLocation.tryParse((String)tag.getString(RECIPE_ID));
            if (this.level != null) {
                RecipeHolder stockpotRecipe = this.level.getRecipeManager().byKeyTyped(ModRecipes.STOCKPOT_RECIPE, this.recipeId);
                this.recipe = Objects.requireNonNullElseGet(stockpotRecipe, StockpotRecipeSerializer::getEmptyRecipe);
            }
        }
        if (tag.contains(SOUP_BASE_ID)) {
            this.soupBaseId = ResourceLocation.tryParse((String)tag.getString(SOUP_BASE_ID));
        }
        if (tag.contains(RESULT)) {
            this.result = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound(RESULT));
        }
        this.status = tag.getInt(STATUS);
        this.currentTick = tag.getInt(CURRENT_TICK);
        this.takeoutCount = tag.getInt(TAKEOUT_COUNT);
        if (tag.contains(LID_ITEM)) {
            this.lidItem = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound(LID_ITEM));
        }
    }

    public boolean isEmpty() {
        for (ItemStack stack : this.inputs) {
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public NonNullList<ItemStack> getInputs() {
        return this.inputs;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    public int getTakeoutCount() {
        return this.takeoutCount;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public ResourceLocation getSoupBaseId() {
        return this.soupBaseId;
    }

    @Nullable
    public ISoupBase getSoupBase() {
        return SoupBaseManager.getSoupBase(this.soupBaseId);
    }

    public ItemStack getLidItem() {
        return this.lidItem;
    }

    public void setLidItem(ItemStack lidItem) {
        this.lidItem = lidItem;
    }
}

