/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.client.render.block;

import com.github.ysbbbbbb.kaleidoscopecookery.block.kitchen.MillstoneBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.blockentity.kitchen.MillstoneBlockEntity;
import com.github.ysbbbbbb.kaleidoscopecookery.client.model.MillstoneModel;
import com.github.ysbbbbbb.kaleidoscopecookery.client.resources.ItemRenderReplacer;
import com.github.ysbbbbbb.kaleidoscopecookery.client.resources.ItemRenderReplacerReloadListener;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class MillstoneBlockEntityRender
implements BlockEntityRenderer<MillstoneBlockEntity> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"kaleidoscope_cookery", (String)"textures/block/millstone.png");
    private final BlockEntityRendererProvider.Context context;
    private final MillstoneModel bodyModel;

    public MillstoneBlockEntityRender(BlockEntityRendererProvider.Context context) {
        this.context = context;
        this.bodyModel = new MillstoneModel(context.bakeLayer(MillstoneModel.LAYER_LOCATION));
    }

    public void render(MillstoneBlockEntity millstone, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        Level level = millstone.getLevel();
        if (level == null) {
            return;
        }
        Direction facing = (Direction)millstone.getBlockState().getValue((Property)MillstoneBlock.FACING);
        this.renderBody(poseStack, buffer, packedLight, packedOverlay, partialTick, facing, millstone, level);
        if (!millstone.getOutput().isEmpty()) {
            this.renderItems(millstone, poseStack, buffer, packedLight, packedOverlay, millstone.getOutput(), this.context.getItemRenderer());
        } else if (!millstone.getInput().isEmpty()) {
            this.renderItems(millstone, poseStack, buffer, packedLight, packedOverlay, millstone.getInput(), this.context.getItemRenderer());
        }
    }

    private void renderBody(PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, float partialTick, Direction facing, MillstoneBlockEntity millstone, Level level) {
        int facingDeg = facing.get2DDataValue() * 90;
        if (millstone.hasEntity()) {
            rot = (float)facingDeg + millstone.getRotation(level, partialTick);
            this.bodyModel.getWheel().yRot = -rot * ((float)Math.PI / 180);
            this.bodyModel.getRoll().zRot = rot * ((float)Math.PI / 180);
            this.bodyModel.getRotStick().xRot = -millstone.getLiftAngle() * ((float)Math.PI / 180);
        } else {
            rot = (float)facingDeg + millstone.getCacheRot();
            this.bodyModel.getWheel().yRot = -rot * ((float)Math.PI / 180);
        }
        poseStack.pushPose();
        poseStack.translate(0.5, 1.5, 0.5);
        poseStack.mulPose(Axis.ZN.rotationDegrees(180.0f));
        poseStack.mulPose(Axis.YN.rotationDegrees((float)(180 - facingDeg)));
        VertexConsumer checkerBoardBuff = bufferIn.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)TEXTURE));
        this.bodyModel.renderToBuffer(poseStack, checkerBoardBuff, combinedLightIn, combinedOverlayIn);
        poseStack.popPose();
        this.bodyModel.getWheel().yRot = 0.0f;
        this.bodyModel.getRoll().zRot = 0.0f;
        this.bodyModel.getRotStick().xRot = 0.0f;
    }

    private void renderItems(MillstoneBlockEntity millstone, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay, ItemStack renderItem, ItemRenderer itemRenderer) {
        RandomSource source = RandomSource.create((long)millstone.hashCode());
        int maxCount = Math.min(renderItem.getCount(), 8);
        BakedModel model = ItemRenderReplacer.getModel(millstone.getLevel(), renderItem, ItemRenderReplacerReloadListener.INSTANCE.millstone());
        for (int i = 0; i < maxCount; ++i) {
            poseStack.pushPose();
            poseStack.translate(0.0, 0.875, 0.0);
            poseStack.rotateAround(Axis.YP.rotationDegrees((float)(i * 45 + source.nextInt(15))), 0.5f, 0.0f, 0.5f);
            poseStack.mulPose(Axis.YP.rotationDegrees((float)source.nextInt(20)));
            poseStack.mulPose(Axis.XN.rotationDegrees((float)(80 + source.nextInt(20))));
            poseStack.scale(0.65f, 0.65f, 0.65f);
            itemRenderer.render(renderItem, ItemDisplayContext.FIXED, false, poseStack, buffer, packedLight, packedOverlay, model);
            poseStack.popPose();
        }
    }

    public boolean shouldRenderOffScreen(MillstoneBlockEntity millstone) {
        return true;
    }

    public AABB getRenderBoundingBox(MillstoneBlockEntity blockEntity) {
        BlockPos pos = blockEntity.getBlockPos();
        return MillstoneBlockEntityRender.getAABB(pos.offset(-3, 0, -3), pos.offset(3, 1, 3));
    }

    private static AABB getAABB(BlockPos pStart, BlockPos pEnd) {
        return new AABB((double)pStart.getX(), (double)pStart.getY(), (double)pStart.getZ(), (double)pEnd.getX(), (double)pEnd.getY(), (double)pEnd.getZ());
    }
}

