/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.compat.kubejs.util;

import com.github.ysbbbbbb.kaleidoscopecookery.crafting.serializer.StockpotRecipeSerializer;
import com.github.ysbbbbbb.kaleidoscopecookery.crafting.soupbase.SimpleSoupBase;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.function.TriFunction;

@Info(value="A builder for simple soup base, used in KubeJS. <br>\n\u7b80\u6613\u6c64\u5e95\u7684\u6784\u5efa\u5668\uff0c\u7528\u4e8e KubeJS\n")
public final class SimpleSoupBaseBuilder {
    private final ResourceLocation name;
    private ItemStack displayStack = Items.APPLE.getDefaultInstance();
    private ResourceLocation soupBaseTexture = StockpotRecipeSerializer.DEFAULT_COOKING_TEXTURE;
    private int bubbleColor = 16772291;
    private Predicate<ItemStack> soupBasePredicate = stack -> false;
    private Predicate<ItemStack> containerPredicate = stack -> false;
    private TriFunction<Level, LivingEntity, ItemStack, ItemStack> returnContainerFunction = (level, entity, stack) -> ItemStack.EMPTY;
    private TriFunction<Level, LivingEntity, ItemStack, ItemStack> returnSoupBaseFunction = (level, entity, stack) -> ItemStack.EMPTY;

    private SimpleSoupBaseBuilder(ResourceLocation name) {
        this.name = name;
    }

    @Info(value="Create a soup base, need to provide an id, this id will be used in subsequent stockpot recipes. <br>\n\u521b\u5efa\u4e00\u4e2a\u6c64\u5e95\uff0c\u9700\u8981\u586b\u5199 id\uff0c\u8fd9\u4e2a id \u5c06\u7528\u4e8e\u540e\u7eed\u6c64\u9505\u914d\u65b9\u3002\n")
    public static SimpleSoupBaseBuilder create(ResourceLocation name) {
        return new SimpleSoupBaseBuilder(name);
    }

    @Info(value="The item used to display the soup base in the JEI UI. <br>\n\u5728 JEI \u754c\u9762\u4e2d\u7528\u4e8e\u663e\u793a\u6c64\u5e95\u7684\u7269\u54c1\u3002\n")
    public SimpleSoupBaseBuilder displayStack(ItemStack displayStack) {
        this.displayStack = displayStack;
        return this;
    }

    @Info(value="The texture used to render the soup base in the soup pot. Supports dynamic textures. The texture needs to be registered in atlases/block.json. <br>\n\u5728\u6c64\u9505\u4e2d\u7528\u4e8e\u6e32\u67d3\u6c64\u5e95\u7684\u6750\u8d28\uff0c\u652f\u6301\u52a8\u6001\u6750\u8d28\u3002\u6750\u8d28\u9700\u8981\u5728 atlases/block.json \u4e2d\u6ce8\u518c\u3002\n")
    public SimpleSoupBaseBuilder soupBaseTexture(ResourceLocation soupBaseTexture) {
        this.soupBaseTexture = soupBaseTexture;
        return this;
    }

    @Info(value="The color of the bubble particles when the soup base is first added to the soup pot. <br>\n\u521a\u653e\u5165\u6c64\u5e95\u65f6\uff0c\u6c64\u9505\u4e2d\u6c14\u6ce1\u7c92\u5b50\u7684\u989c\u8272\u3002\n")
    public SimpleSoupBaseBuilder bubbleColor(int bubbleColor) {
        this.bubbleColor = bubbleColor;
        return this;
    }

    @Info(value="A predicate to test whether an item is the soup base. <br>\n\u5f53\u73a9\u5bb6\u5c06\u7269\u54c1\u653e\u5165\u6c64\u9505\u65f6\uff0c\u5224\u65ad\u8be5\u7269\u54c1\u662f\u5426\u4e3a\u8be5\u6c64\u5e95\u7684\u7269\u54c1\u3002\n")
    public SimpleSoupBaseBuilder soupBasePredicate(Predicate<ItemStack> soupBasePredicate) {
        this.soupBasePredicate = soupBasePredicate;
        return this;
    }

    @Info(value="A predicate to test whether an item is a valid container to retrieve the soup base. <br>\n\u5f53\u73a9\u5bb6\u5c06\u7269\u54c1\u653e\u5165\u6c64\u9505\u65f6\uff0c\u5224\u65ad\u8be5\u7269\u54c1\u662f\u5426\u4e3a\u53d6\u56de\u6c64\u5e95\u7684\u6709\u6548\u5bb9\u5668\u3002\n")
    public SimpleSoupBaseBuilder containerPredicate(Predicate<ItemStack> containerPredicate) {
        this.containerPredicate = containerPredicate;
        return this;
    }

    @Info(value="When soupBasePredicate tests true, this function is called to get the item returned to the player. <br>\n\u5f53 soupBasePredicate \u5224\u65ad\u6c64\u5e95\u7269\u54c1\u7b26\u5408\u65f6\uff0c\u8c03\u7528\u8be5\u51fd\u6570\u83b7\u53d6\u8fd4\u56de\u7ed9\u73a9\u5bb6\u7684\u7269\u54c1\u3002\n")
    public SimpleSoupBaseBuilder returnContainerFunction(TriFunction<Level, LivingEntity, ItemStack, ItemStack> returnContainerFunction) {
        this.returnContainerFunction = returnContainerFunction;
        return this;
    }

    @Info(value="When containerPredicate tests true, this function is called to get the item returned to the player. <br>\n\u5f53 containerPredicate \u5224\u65ad\u5bb9\u5668\u7269\u54c1\u7b26\u5408\u65f6\uff0c\u8c03\u7528\u8be5\u51fd\u6570\u83b7\u53d6\u8fd4\u56de\u7ed9\u73a9\u5bb6\u7684\u7269\u54c1\u3002\n")
    public SimpleSoupBaseBuilder returnSoupBaseFunction(TriFunction<Level, LivingEntity, ItemStack, ItemStack> returnSoupBaseFunction) {
        this.returnSoupBaseFunction = returnSoupBaseFunction;
        return this;
    }

    @HideFromJS
    public SimpleSoupBase build() {
        return new SimpleSoupBase(this.name, this.displayStack, this.soupBaseTexture, this.bubbleColor, this.soupBasePredicate, this.containerPredicate, this.returnContainerFunction, this.returnSoupBaseFunction);
    }
}

