/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.datagen.lootable;

import com.github.ysbbbbbb.kaleidoscopecookery.init.ModItems;
import com.github.ysbbbbbb.kaleidoscopecookery.init.tag.TagMod;
import com.github.ysbbbbbb.kaleidoscopecookery.loot.AdvanceEntityMatchTool;
import com.google.common.collect.Sets;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.EntityLootSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.EnchantedCountIncreaseFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class EntityLootTables
extends EntityLootSubProvider {
    public final Set<EntityType<?>> knownEntities = Sets.newHashSet();

    public EntityLootTables(HolderLookup.Provider registries) {
        super(FeatureFlags.REGISTRY.allFlags(), registries);
    }

    public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> output) {
        super.generate(output);
        ItemPredicate hasKnife = ItemPredicate.Builder.item().of(TagMod.KITCHEN_KNIFE).build();
        LootItemCondition.Builder toolMatches = AdvanceEntityMatchTool.toolMatches(EquipmentSlot.MAINHAND, hasKnife);
        LootItemConditionalFunction.Builder count = SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f));
        EnchantedCountIncreaseFunction.Builder looting = EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f));
        LootPoolSingletonContainer.Builder oil = LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.OIL.get())).apply((LootItemFunction.Builder)count).apply((LootItemFunction.Builder)looting);
        LootPoolSingletonContainer.Builder donkeyMeat = LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.RAW_DONKEY_MEAT.get())).apply((LootItemFunction.Builder)count).apply((LootItemFunction.Builder)looting);
        LootTable.Builder lessOil = LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)oil).when(toolMatches));
        LootTable.Builder moreOil = LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)2.0f)).add((LootPoolEntryContainer.Builder)oil).when(toolMatches));
        LootTable.Builder moreDonkeyMeat = LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)2.0f)).add((LootPoolEntryContainer.Builder)donkeyMeat).when(toolMatches));
        output.accept(this.modLoc("pig"), lessOil);
        output.accept(this.modLoc("zombified_piglin"), lessOil);
        output.accept(this.modLoc("piglin"), moreOil);
        output.accept(this.modLoc("piglin_brute"), moreOil);
        output.accept(this.modLoc("hoglin"), moreOil);
        output.accept(this.modLoc("zoglin"), moreOil);
        output.accept(this.modLoc("donkey"), moreDonkeyMeat);
    }

    public void generate() {
    }

    protected boolean canHaveLootTable(EntityType<?> type) {
        return true;
    }

    protected Stream<EntityType<?>> getKnownEntityTypes() {
        return this.knownEntities.stream();
    }

    protected void add(EntityType<?> type, LootTable.Builder builder) {
        this.add(type, (ResourceKey<LootTable>)type.getDefaultLootTable(), builder);
    }

    protected void add(EntityType<?> type, ResourceKey<LootTable> lootTable, LootTable.Builder builder) {
        super.add(type, lootTable, builder);
        this.knownEntities.add(type);
    }

    public ResourceKey<LootTable> modLoc(String name) {
        return ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"kaleidoscope_cookery", (String)name));
    }
}

