/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.item;

import com.github.ysbbbbbb.kaleidoscopecookery.init.ModBlocks;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModDataComponents;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class OilPotItem
extends BlockItem {
    public static final ResourceLocation HAS_OIL_PROPERTY = ResourceLocation.fromNamespaceAndPath((String)"kaleidoscope_cookery", (String)"has_oil");
    private static final String OIL_COUNT = "oil_count";
    private static final int NO_OIL = 0;
    private static final int HAS_OIL = 1;

    public OilPotItem() {
        super((Block)ModBlocks.OIL_POT.get(), new Item.Properties().stacksTo(1));
    }

    public static void setOilCount(ItemStack stack, int count) {
        count = Mth.clamp((int)count, (int)0, (int)256);
        stack.set(ModDataComponents.OIL_POT_OIL_COUNT, (Object)count);
    }

    public static int getOilCount(ItemStack stack) {
        return (Integer)stack.getOrDefault(ModDataComponents.OIL_POT_OIL_COUNT, (Object)0);
    }

    public static boolean hasOil(ItemStack stack) {
        return OilPotItem.getOilCount(stack) > 0;
    }

    public static void shrinkOilCount(ItemStack stack) {
        int currentCount = OilPotItem.getOilCount(stack);
        if (currentCount > 0) {
            OilPotItem.setOilCount(stack, currentCount - 1);
        }
    }

    public static ItemStack getFullOilPot() {
        ItemStack stack = new ItemStack((ItemLike)ModBlocks.OIL_POT.get());
        OilPotItem.setOilCount(stack, 256);
        return stack;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static float getTexture(ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int seed) {
        if (OilPotItem.hasOil(stack)) {
            return 1.0f;
        }
        return 0.0f;
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext context, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        int oilCount = OilPotItem.getOilCount(pStack);
        if (oilCount > 0) {
            pTooltipComponents.add((Component)Component.translatable((String)"tooltip.kaleidoscope_cookery.oil_pot.count", (Object[])new Object[]{oilCount}).withStyle(ChatFormatting.GRAY));
        } else {
            pTooltipComponents.add((Component)Component.translatable((String)"tooltip.kaleidoscope_cookery.oil_pot.empty").withStyle(ChatFormatting.GRAY));
        }
    }
}

