/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.item;

import com.github.ysbbbbbb.kaleidoscopecookery.advancements.critereon.ModEventTrigger;
import com.github.ysbbbbbb.kaleidoscopecookery.blockentity.decoration.FruitBasketBlockEntity;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModDataComponents;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModTrigger;
import com.github.ysbbbbbb.kaleidoscopecookery.inventory.tooltip.ItemContainerTooltip;
import com.github.ysbbbbbb.kaleidoscopecookery.util.ItemUtils;
import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;

public class TransmutationLunchBagItem
extends Item {
    public static final ResourceLocation HAS_ITEMS_PROPERTY = ResourceLocation.fromNamespaceAndPath((String)"kaleidoscope_cookery", (String)"has_items");
    public static final int NO_ITEMS = 0;
    public static final int HAS_ITEMS = 1;
    private static final int MAX_SIZE = 16;
    private static final String TAG_ITEMS = "Items";

    public TransmutationLunchBagItem() {
        super(new Item.Properties().stacksTo(1));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static float getTexture(ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int seed) {
        if (!TransmutationLunchBagItem.hasItems(stack)) {
            return 0.0f;
        }
        return 1.0f;
    }

    public static boolean hasItems(ItemStack bag) {
        return bag.has(ModDataComponents.TRANSMUTATION_LUNCH_BAG_ITEMS);
    }

    public static ItemStackHandler getItems(ItemStack bag) {
        ItemContainer container = (ItemContainer)bag.get(ModDataComponents.TRANSMUTATION_LUNCH_BAG_ITEMS);
        if (container != null) {
            return container.items();
        }
        return new ItemStackHandler(16);
    }

    public static void setItems(ItemStack bag, ItemStackHandler items) {
        boolean allEmpty = true;
        for (int i = 0; i < items.getSlots(); ++i) {
            if (items.getStackInSlot(i).isEmpty()) continue;
            allEmpty = false;
            break;
        }
        if (allEmpty) {
            bag.remove(ModDataComponents.TRANSMUTATION_LUNCH_BAG_ITEMS);
        } else {
            bag.set(ModDataComponents.TRANSMUTATION_LUNCH_BAG_ITEMS, (Object)ItemContainer.of(items));
        }
    }

    public InteractionResult useOn(UseOnContext context) {
        int i;
        BlockEntity blockEntity = context.getLevel().getBlockEntity(context.getClickedPos());
        if (!(blockEntity instanceof FruitBasketBlockEntity)) {
            return super.useOn(context);
        }
        FruitBasketBlockEntity fruitBasket = (FruitBasketBlockEntity)blockEntity;
        Player player = context.getPlayer();
        if (player == null) {
            return super.useOn(context);
        }
        ItemStack bag = context.getItemInHand();
        ItemStackHandler bagItems = TransmutationLunchBagItem.getItems(bag);
        ItemStackHandler fruitBasketItems = fruitBasket.getItems();
        boolean basketEmpty = true;
        for (i = 0; i < fruitBasketItems.getSlots(); ++i) {
            if (fruitBasketItems.getStackInSlot(i).isEmpty()) continue;
            basketEmpty = false;
            break;
        }
        if (TransmutationLunchBagItem.hasItems(bag) && basketEmpty) {
            for (i = 0; i < bagItems.getSlots(); ++i) {
                ItemStack stack = bagItems.getStackInSlot(i);
                if (stack.isEmpty() || !stack.getItem().canFitInsideContainerItems()) continue;
                ItemStack remaining = ItemHandlerHelper.insertItemStacked((IItemHandler)fruitBasketItems, (ItemStack)stack, (boolean)false);
                bagItems.extractItem(i, stack.getCount() - remaining.getCount(), false);
            }
            TransmutationLunchBagItem.setItems(bag, bagItems);
            fruitBasket.refresh();
            this.playRemoveOneSound((Entity)player);
            return InteractionResult.sidedSuccess((boolean)context.getLevel().isClientSide);
        }
        for (i = 0; i < fruitBasketItems.getSlots(); ++i) {
            ItemStack stack = fruitBasketItems.getStackInSlot(i);
            if (stack.isEmpty() || !TransmutationLunchBagItem.canAdd(stack)) continue;
            ItemStack remaining = ItemHandlerHelper.insertItemStacked((IItemHandler)bagItems, (ItemStack)stack, (boolean)false);
            fruitBasketItems.extractItem(i, stack.getCount() - remaining.getCount(), false);
        }
        TransmutationLunchBagItem.setItems(bag, bagItems);
        fruitBasket.refresh();
        this.playDropContentsSound((Entity)player);
        return InteractionResult.sidedSuccess((boolean)context.getLevel().isClientSide);
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity, InteractionHand hand) {
        Player player;
        if (entity instanceof Player && (player = (Player)entity).isSecondaryUseActive() && TransmutationLunchBagItem.dropContents(stack, player)) {
            this.playDropContentsSound((Entity)player);
            return true;
        }
        return super.onEntitySwing(stack, entity, hand);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemInHand = player.getItemInHand(hand);
        if (TransmutationLunchBagItem.hasItems(itemInHand)) {
            boolean hasFood = false;
            ItemStackHandler items = TransmutationLunchBagItem.getItems(itemInHand);
            for (int i = 0; i < items.getSlots(); ++i) {
                ItemStack stackInSlot = items.getStackInSlot(i);
                if (stackInSlot.isEmpty()) continue;
                hasFood = true;
                break;
            }
            if (hasFood) {
                player.startUsingItem(hand);
                return InteractionResultHolder.consume((Object)itemInHand);
            }
        }
        return InteractionResultHolder.fail((Object)itemInHand);
    }

    public ItemStack finishUsingItem(ItemStack bag, Level level, LivingEntity entity) {
        block14: {
            ItemStackHandler items;
            ArrayList effects;
            block17: {
                Item containerItem;
                block15: {
                    ItemStack returnStack;
                    block16: {
                        if (!TransmutationLunchBagItem.hasItems(bag)) {
                            return bag;
                        }
                        ItemStack food = ItemStack.EMPTY;
                        effects = Lists.newArrayList();
                        items = TransmutationLunchBagItem.getItems(bag);
                        for (int i = 0; i < items.getSlots(); ++i) {
                            ItemStack stackInSlot = items.getStackInSlot(i);
                            if (stackInSlot.isEmpty()) continue;
                            FoodProperties foodProperties = stackInSlot.getItem().getFoodProperties(stackInSlot, null);
                            if (foodProperties != null) {
                                if (!food.isEmpty()) {
                                    List foodEffects = foodProperties.effects();
                                    effects.add(foodEffects);
                                    continue;
                                }
                                food = items.extractItem(i, 1, false);
                                continue;
                            }
                            PotionContents potionContents = (PotionContents)stackInSlot.get(DataComponents.POTION_CONTENTS);
                            if (potionContents == null) continue;
                            if (!food.isEmpty()) {
                                ArrayList potionEffects = Lists.newArrayList();
                                potionContents.forEachEffect(e -> potionEffects.add(new FoodProperties.PossibleEffect(() -> e, 1.0f)));
                                effects.add(potionEffects);
                                continue;
                            }
                            food = items.extractItem(i, 1, false);
                        }
                        if (food.isEmpty()) break block14;
                        returnStack = food.finishUsingItem(level, entity);
                        containerItem = ItemUtils.getContainerItem(food);
                        if (returnStack.isEmpty()) break block15;
                        if (!(entity instanceof Player)) break block16;
                        Player player = (Player)entity;
                        if (player.getAbilities().instabuild) break block17;
                    }
                    ItemUtils.getItemToLivingEntity(entity, returnStack);
                    break block17;
                }
                if (containerItem != Items.AIR) {
                    ItemUtils.getItemToLivingEntity(entity, containerItem.getDefaultInstance());
                }
            }
            boolean hasExtraEffects = false;
            Collections.shuffle(effects, new Random());
            int effectsToApply = Math.min(3, effects.size());
            for (int i = 0; i < effectsToApply; ++i) {
                List selected = (List)effects.get(i);
                for (FoodProperties.PossibleEffect effect : selected) {
                    if (level.isClientSide || effect.probability() <= 0.0f || level.random.nextFloat() >= effect.probability()) continue;
                    entity.addEffect(new MobEffectInstance(effect.effect()));
                    hasExtraEffects = true;
                }
            }
            if (hasExtraEffects) {
                IntArrayList foodSlots = new IntArrayList();
                for (int i = 0; i < items.getSlots(); ++i) {
                    ItemStack stackInSlot = items.getStackInSlot(i);
                    if (stackInSlot.isEmpty()) continue;
                    foodSlots.add(i);
                }
                if (!foodSlots.isEmpty()) {
                    int randomIndex = level.random.nextInt(foodSlots.size());
                    int slotToExtract = foodSlots.getInt(randomIndex);
                    items.extractItem(slotToExtract, 1, false);
                }
            }
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                ((ModEventTrigger)((Object)ModTrigger.EVENT.get())).trigger((LivingEntity)player, "use_transmutation_lunch_bag");
            }
            TransmutationLunchBagItem.setItems(bag, items);
            return bag;
        }
        return bag;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return TransmutationLunchBagItem.hasItems(stack) ? UseAnim.EAT : UseAnim.NONE;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 32;
    }

    public boolean overrideStackedOnOther(ItemStack bag, Slot slot, ClickAction action, Player player) {
        int addCount;
        if (bag.getCount() != 1 || action != ClickAction.SECONDARY) {
            return false;
        }
        ItemStack clickItem = slot.getItem();
        if (clickItem.isEmpty()) {
            this.playRemoveOneSound((Entity)player);
            TransmutationLunchBagItem.removeOne(bag).ifPresent(stack -> TransmutationLunchBagItem.add(bag, slot.safeInsert(stack)));
        } else if (clickItem.getItem().canFitInsideContainerItems() && TransmutationLunchBagItem.canAdd(clickItem) && (addCount = TransmutationLunchBagItem.add(bag, clickItem, true)) > 0) {
            ItemStack takeout = slot.safeTake(clickItem.getCount(), addCount, player);
            if (!takeout.isEmpty()) {
                TransmutationLunchBagItem.add(bag, takeout);
            }
            this.playInsertSound((Entity)player);
        }
        return true;
    }

    public boolean overrideOtherStackedOnMe(ItemStack bag, ItemStack other, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (bag.getCount() != 1) {
            return false;
        }
        if (action != ClickAction.SECONDARY || !slot.allowModification(player)) {
            return false;
        }
        if (other.isEmpty()) {
            TransmutationLunchBagItem.removeOne(bag).ifPresent(stack -> {
                this.playRemoveOneSound((Entity)player);
                access.set(stack);
            });
        } else {
            int added = TransmutationLunchBagItem.add(bag, other);
            if (added > 0) {
                this.playInsertSound((Entity)player);
                other.shrink(added);
            }
        }
        return true;
    }

    public static boolean canAdd(ItemStack food) {
        if (food.isEmpty()) {
            return false;
        }
        if (!food.getItem().canFitInsideContainerItems()) {
            return false;
        }
        return food.has(DataComponents.FOOD) || food.has(DataComponents.POTION_CONTENTS);
    }

    private static Optional<ItemStack> removeOne(ItemStack bag) {
        if (!TransmutationLunchBagItem.hasItems(bag)) {
            return Optional.empty();
        }
        ItemStackHandler items = TransmutationLunchBagItem.getItems(bag);
        for (int i = 0; i < items.getSlots(); ++i) {
            ItemStack extractItem = items.extractItem(i, items.getSlotLimit(i), false);
            if (extractItem.isEmpty()) continue;
            TransmutationLunchBagItem.setItems(bag, items);
            return Optional.of(extractItem);
        }
        return Optional.empty();
    }

    private static int add(ItemStack bag, ItemStack food) {
        return TransmutationLunchBagItem.add(bag, food, false);
    }

    private static int add(ItemStack bag, ItemStack food, boolean simulate) {
        if (food.isEmpty() || !food.getItem().canFitInsideContainerItems() || !TransmutationLunchBagItem.canAdd(food)) {
            return 0;
        }
        int totalCount = food.getCount();
        ItemStackHandler items = TransmutationLunchBagItem.getItems(bag);
        ItemStack remaining = ItemHandlerHelper.insertItemStacked((IItemHandler)items, (ItemStack)food, (boolean)simulate);
        int addCount = totalCount - (remaining.isEmpty() ? 0 : remaining.getCount());
        if (!simulate && addCount > 0) {
            TransmutationLunchBagItem.setItems(bag, items);
        }
        return addCount;
    }

    private static boolean dropContents(ItemStack bag, Player player) {
        if (!TransmutationLunchBagItem.hasItems(bag)) {
            return false;
        }
        boolean result = false;
        ItemStackHandler items = TransmutationLunchBagItem.getItems(bag);
        for (int i = 0; i < items.getSlots(); ++i) {
            ItemStack stack = items.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack);
            result = true;
        }
        if (result) {
            items = new ItemStackHandler(16);
            TransmutationLunchBagItem.setItems(bag, items);
        }
        return result;
    }

    private void playRemoveOneSound(Entity pEntity) {
        pEntity.playSound(SoundEvents.BUNDLE_REMOVE_ONE, 0.8f, 0.8f + pEntity.level().getRandom().nextFloat() * 0.4f);
    }

    private void playInsertSound(Entity pEntity) {
        pEntity.playSound(SoundEvents.BUNDLE_INSERT, 0.8f, 0.8f + pEntity.level().getRandom().nextFloat() * 0.4f);
    }

    private void playDropContentsSound(Entity pEntity) {
        pEntity.playSound(SoundEvents.BUNDLE_DROP_CONTENTS, 0.8f, 0.8f + pEntity.level().getRandom().nextFloat() * 0.4f);
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        if (!TransmutationLunchBagItem.hasItems(stack)) {
            return Optional.empty();
        }
        ItemStackHandler items = TransmutationLunchBagItem.getItems(stack);
        return Optional.of(new ItemContainerTooltip((IItemHandler)items));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.kaleidoscope_cookery.transmutation_lunch_bag").withStyle(ChatFormatting.GRAY));
    }

    public record ItemContainer(ItemStackHandler items) {
        public static final Codec<ItemContainer> CODEC = ItemStack.OPTIONAL_CODEC.listOf().xmap(list -> {
            ItemStackHandler handler = new ItemStackHandler(16);
            for (int i = 0; i < Math.min(list.size(), handler.getSlots()); ++i) {
                handler.setStackInSlot(i, (ItemStack)list.get(i));
            }
            return new ItemContainer(handler);
        }, container -> {
            ItemStackHandler handler = container.items();
            ArrayList output = Lists.newArrayList();
            for (int i = 0; i < handler.getSlots(); ++i) {
                output.add(handler.getStackInSlot(i));
            }
            return output;
        });
        public static final StreamCodec<RegistryFriendlyByteBuf, ItemContainer> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, ItemContainer>(){

            public ItemContainer decode(RegistryFriendlyByteBuf buffer) {
                CompoundTag compoundTag = buffer.readNbt();
                ItemStackHandler handler = new ItemStackHandler(16);
                if (compoundTag != null) {
                    handler.deserializeNBT((HolderLookup.Provider)buffer.registryAccess(), compoundTag);
                }
                return new ItemContainer(handler);
            }

            public void encode(RegistryFriendlyByteBuf buffer, ItemContainer value) {
                CompoundTag compoundTag = value.items().serializeNBT((HolderLookup.Provider)buffer.registryAccess());
                buffer.writeNbt((Tag)compoundTag);
            }
        };

        public static ItemContainer of(ItemStackHandler items) {
            ItemStackHandler copy = new ItemStackHandler(16);
            for (int i = 0; i < Math.min(items.getSlots(), copy.getSlots()); ++i) {
                copy.setStackInSlot(i, items.getStackInSlot(i).copy());
            }
            return new ItemContainer(copy);
        }
    }
}

