/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.network.message;

import com.github.ysbbbbbb.kaleidoscopecookery.entity.ThrowableBaoziEntity;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModEffects;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModItems;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModSounds;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SimpleC2SModMessage(int index) implements CustomPacketPayload
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"kaleidoscope_cookery", (String)"simple_c2s");
    public static final CustomPacketPayload.Type<SimpleC2SModMessage> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<ByteBuf, SimpleC2SModMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, SimpleC2SModMessage::index, SimpleC2SModMessage::new);
    public static final int FLATULENCE = 0;
    public static final int THROW_BAOZI = 1;

    public static void handle(SimpleC2SModMessage message, IPayloadContext context) {
        if (context.flow().isServerbound()) {
            context.enqueueWork(() -> SimpleC2SModMessage.onHandle(context, message.index));
        }
    }

    private static void onHandle(IPayloadContext context, int index) {
        if (index == 0) {
            SimpleC2SModMessage.handleFlatulenceEffect(context);
        }
        if (index == 1) {
            SimpleC2SModMessage.handleBaozi(context);
        }
    }

    private static void handleFlatulenceEffect(IPayloadContext context) {
        ServerPlayer player;
        Player player2 = context.player();
        if (player2 instanceof ServerPlayer && (player = (ServerPlayer)player2).hasEffect(ModEffects.FLATULENCE)) {
            ServerLevel serverLevel = player.serverLevel();
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.CLOUD, player.getX(), player.getY() + 0.25, player.getZ(), 10, 0.25, 0.25, 0.25, 0.1);
            serverLevel.playSound(null, player.blockPosition(), (SoundEvent)ModSounds.ENTITY_FART.get(), SoundSource.PLAYERS, 1.0f, 0.8f + (float)Math.random() * 0.4f);
        }
    }

    private static void handleBaozi(IPayloadContext context) {
        ServerPlayer player;
        Player player2 = context.player();
        if (!(player2 instanceof ServerPlayer && (player = (ServerPlayer)player2).getMainHandItem().is((Item)ModItems.BAOZI.get()) && player.isSecondaryUseActive())) {
            return;
        }
        ItemStack stack = player.getMainHandItem();
        Level level = player.level();
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.SNOWBALL_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
        ThrowableBaoziEntity baozi = new ThrowableBaoziEntity(level, (LivingEntity)player);
        baozi.setItem(stack.copyWithCount(1));
        baozi.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.5f, 1.0f);
        level.addFreshEntity((Entity)baozi);
        stack.shrink(1);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

